/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.rewriters;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.NumberTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.data.BackwardsMappingData;
import com.viaversion.viabackwards.api.data.MappedItem;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.FullMappings;
import com.viaversion.viaversion.api.minecraft.data.StructuredData;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataContainer;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataKey;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.viaversion.viaversion.rewriter.StructuredItemRewriter;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BackwardsStructuredItemRewriter<C extends ClientboundPacketType, S extends ServerboundPacketType, T extends BackwardsProtocol<C, ?, ?, S>>
extends StructuredItemRewriter<C, S, T> {
    public BackwardsStructuredItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType) {
        super(protocol, itemType, itemArrayType);
    }

    public BackwardsStructuredItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType, Type<Item> mappedItemType, Type<Item[]> mappedItemArrayType) {
        super(protocol, itemType, itemArrayType, mappedItemType, mappedItemArrayType);
    }

    public Item handleItemToClient(UserConnection connection, Item item) {
        MappedItem mappedItem;
        if (item.isEmpty()) {
            return item;
        }
        StructuredDataContainer dataContainer = item.dataContainer();
        BackwardsMappingData mappingData = ((BackwardsProtocol)this.protocol).getMappingData();
        if (mappingData != null && mappingData.getDataComponentSerializerMappings() != null) {
            FullMappings mappings = mappingData.getDataComponentSerializerMappings();
            dataContainer.setIdLookup(this.protocol, true);
            dataContainer.updateIds(this.protocol, arg_0 -> ((FullMappings)mappings).getNewId(arg_0));
        }
        if (((BackwardsProtocol)this.protocol).getComponentRewriter() != null) {
            this.updateComponent(connection, item, StructuredDataKey.ITEM_NAME, "item_name");
            this.updateComponent(connection, item, StructuredDataKey.CUSTOM_NAME, "custom_name");
            StructuredData loreData = dataContainer.getNonEmpty(StructuredDataKey.LORE);
            if (loreData != null) {
                for (Tag tag : (Tag[])loreData.value()) {
                    ((BackwardsProtocol)this.protocol).getComponentRewriter().processTag(connection, tag);
                }
            }
        }
        Int2IntFunction itemIdRewriter = null;
        Int2IntFunction blockIdRewriter = null;
        if (mappingData != null) {
            Int2IntFunction int2IntFunction = mappingData.getItemMappings() != null ? mappingData::getNewItemId : (itemIdRewriter = null);
            blockIdRewriter = mappingData.getBlockMappings() != null ? mappingData::getNewBlockId : null;
        }
        MappedItem mappedItem2 = mappedItem = mappingData != null ? mappingData.getMappedItem(item.identifier()) : null;
        if (mappedItem == null) {
            if (mappingData != null && mappingData.getItemMappings() != null) {
                item.setIdentifier(mappingData.getNewItemId(item.identifier()));
            }
            this.updateItemComponents(connection, dataContainer, this::handleItemToClient, itemIdRewriter, blockIdRewriter);
            return item;
        }
        CompoundTag tag = this.createCustomTag(item);
        tag.putInt(this.nbtTagName("id"), item.identifier());
        item.setIdentifier(mappedItem.id());
        if (mappedItem.customModelData() != null && !dataContainer.contains(StructuredDataKey.CUSTOM_MODEL_DATA)) {
            dataContainer.set(StructuredDataKey.CUSTOM_MODEL_DATA, (Object)mappedItem.customModelData());
        }
        if (!dataContainer.contains(StructuredDataKey.CUSTOM_NAME)) {
            dataContainer.set(StructuredDataKey.CUSTOM_NAME, (Object)mappedItem.tagName());
            tag.putBoolean(this.nbtTagName("added_custom_name"), true);
        }
        this.updateItemComponents(connection, dataContainer, this::handleItemToClient, itemIdRewriter, blockIdRewriter);
        return item;
    }

    public Item handleItemToServer(UserConnection connection, Item item) {
        Tag originalId;
        CompoundTag tag;
        if (item.isEmpty()) {
            return item;
        }
        BackwardsMappingData mappingData = ((BackwardsProtocol)this.protocol).getMappingData();
        StructuredDataContainer dataContainer = item.dataContainer();
        if (mappingData != null) {
            FullMappings dataComponentMappings;
            if (mappingData.getItemMappings() != null) {
                item.setIdentifier(mappingData.getOldItemId(item.identifier()));
            }
            if ((dataComponentMappings = mappingData.getDataComponentSerializerMappings()) != null) {
                dataContainer.setIdLookup(this.protocol, false);
                dataContainer.updateIds(this.protocol, id -> dataComponentMappings.inverse().getNewId(id));
            }
        }
        if ((tag = this.customTag(item)) != null && (originalId = tag.remove(this.nbtTagName("id"))) instanceof IntTag) {
            item.setIdentifier(((NumberTag)originalId).asInt());
        }
        this.restoreTextComponents(item);
        Int2IntFunction itemIdRewriter = null;
        Int2IntFunction blockIdRewriter = null;
        if (mappingData != null) {
            Int2IntFunction int2IntFunction = mappingData.getItemMappings() != null ? mappingData::getOldItemId : (itemIdRewriter = null);
            blockIdRewriter = mappingData.getBlockMappings() != null ? arg_0 -> ((BackwardsMappingData)mappingData).getOldBlockId(arg_0) : null;
        }
        this.updateItemComponents(connection, dataContainer, this::handleItemToServer, itemIdRewriter, blockIdRewriter);
        return item;
    }

    protected @Nullable CompoundTag customTag(Item item) {
        StructuredData customData = item.dataContainer().getNonEmpty(StructuredDataKey.CUSTOM_DATA);
        return customData != null ? (CompoundTag)customData.value() : null;
    }

    protected void saveListTag(CompoundTag tag, ListTag<?> original, String name) {
        String backupName = this.nbtTagName(name);
        if (!tag.contains(backupName)) {
            tag.put(backupName, (Tag)original.copy());
        }
    }

    public <T extends Tag> @Nullable ListTag<T> removeListTag(CompoundTag tag, String tagName, Class<T> tagType) {
        String backupName = this.nbtTagName(tagName);
        ListTag data = tag.getListTag(backupName, tagType);
        if (data == null) {
            return null;
        }
        tag.remove(backupName);
        return data;
    }

    protected void saveGenericTagList(CompoundTag tag, List<Tag> original, String name) {
        String backupName = this.nbtTagName(name);
        if (!tag.contains(backupName)) {
            CompoundTag output = new CompoundTag();
            for (int i = 0; i < original.size(); ++i) {
                output.put(Integer.toString(i), original.get(i));
            }
            tag.put(backupName, (Tag)output);
        }
    }

    protected List<Tag> removeGenericTagList(CompoundTag tag, String name) {
        String backupName = this.nbtTagName(name);
        CompoundTag data = tag.getCompoundTag(backupName);
        if (data == null) {
            return null;
        }
        tag.remove(backupName);
        return new ArrayList<Tag>(data.values());
    }

    public String nbtTagName() {
        return "VB|" + ((Object)((Object)((BackwardsProtocol)this.protocol))).getClass().getSimpleName();
    }
}

