/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.provider.providers;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import net.ess3.provider.PotionMetaProvider;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class LegacyPotionMetaProvider
implements PotionMetaProvider {
    private static final Map<Integer, PotionType> damageValueToType = ImmutableMap.builder().put((Object)1, (Object)PotionType.REGEN).put((Object)2, (Object)PotionType.SPEED).put((Object)3, (Object)PotionType.FIRE_RESISTANCE).put((Object)4, (Object)PotionType.POISON).put((Object)5, (Object)PotionType.INSTANT_HEAL).put((Object)6, (Object)PotionType.NIGHT_VISION).put((Object)8, (Object)PotionType.WEAKNESS).put((Object)9, (Object)PotionType.STRENGTH).put((Object)10, (Object)PotionType.SLOWNESS).put((Object)11, (Object)PotionType.JUMP).put((Object)12, (Object)PotionType.INSTANT_DAMAGE).put((Object)13, (Object)PotionType.WATER_BREATHING).put((Object)14, (Object)PotionType.INVISIBILITY).build();

    private static int getBit(int n, int k) {
        return n >> k & 1;
    }

    @Override
    public ItemStack createPotionItem(Material initial, int effectId) {
        ItemStack potion = new ItemStack(initial, 1);
        if (effectId == 0) {
            return potion;
        }
        int damageValue = LegacyPotionMetaProvider.getBit(effectId, 0) + 2 * LegacyPotionMetaProvider.getBit(effectId, 1) + 4 * LegacyPotionMetaProvider.getBit(effectId, 2) + 8 * LegacyPotionMetaProvider.getBit(effectId, 3);
        PotionType type = damageValueToType.get(damageValue);
        if (type == null) {
            throw new IllegalArgumentException("Unable to process potion effect ID " + effectId + " with damage value " + damageValue);
        }
        if (LegacyPotionMetaProvider.getBit(effectId, 14) == 1 && initial == Material.POTION) {
            potion = new ItemStack(Material.SPLASH_POTION, 1);
        }
        PotionMeta meta = (PotionMeta)potion.getItemMeta();
        PotionData data = new PotionData(type, LegacyPotionMetaProvider.getBit(effectId, 6) == 1, LegacyPotionMetaProvider.getBit(effectId, 5) == 1);
        meta.setBasePotionData(data);
        potion.setItemMeta((ItemMeta)meta);
        return potion;
    }

    @Override
    public void setSplashPotion(ItemStack stack, boolean isSplash) {
        if (stack == null) {
            throw new IllegalArgumentException("ItemStack cannot be null");
        }
        if (isSplash && stack.getType() == Material.POTION) {
            stack.setType(Material.SPLASH_POTION);
        } else if (!isSplash && stack.getType() == Material.SPLASH_POTION) {
            stack.setType(Material.POTION);
        }
    }

    @Override
    public boolean isSplashPotion(ItemStack stack) {
        return stack != null && stack.getType() == Material.SPLASH_POTION;
    }

    @Override
    public Collection<PotionEffect> getCustomEffects(ItemStack stack) {
        PotionMeta meta = (PotionMeta)stack.getItemMeta();
        return meta.getCustomEffects();
    }

    @Override
    public boolean isExtended(ItemStack stack) {
        PotionMeta meta = (PotionMeta)stack.getItemMeta();
        PotionData data = meta.getBasePotionData();
        return data.isExtended();
    }

    @Override
    public boolean isUpgraded(ItemStack stack) {
        PotionMeta meta = (PotionMeta)stack.getItemMeta();
        PotionData data = meta.getBasePotionData();
        return data.isUpgraded();
    }

    @Override
    public PotionType getBasePotionType(ItemStack stack) {
        PotionMeta meta = (PotionMeta)stack.getItemMeta();
        PotionData data = meta.getBasePotionData();
        return data.getType();
    }

    @Override
    public void setBasePotionType(ItemStack stack, PotionType type, boolean extended, boolean upgraded) {
        if (stack == null) {
            throw new IllegalArgumentException("ItemStack cannot be null");
        }
        if (extended && upgraded) {
            throw new IllegalArgumentException("Potion cannot be both extended and upgraded");
        }
        PotionData data = new PotionData(type, extended, upgraded);
        PotionMeta meta = (PotionMeta)stack.getItemMeta();
        meta.setBasePotionData(data);
        stack.setItemMeta((ItemMeta)meta);
    }

    @Override
    public String getDescription() {
        return "1.9-1.20.4 Potion Meta Provider";
    }
}

