/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ess3.api.IUser;
import org.bukkit.ChatColor;
import org.bukkit.Color;

public final class FormatUtil {
    public static final Pattern IPPATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final Set<ChatColor> COLORS = EnumSet.of(ChatColor.BLACK, new ChatColor[]{ChatColor.DARK_BLUE, ChatColor.DARK_GREEN, ChatColor.DARK_AQUA, ChatColor.DARK_RED, ChatColor.DARK_PURPLE, ChatColor.GOLD, ChatColor.GRAY, ChatColor.DARK_GRAY, ChatColor.BLUE, ChatColor.GREEN, ChatColor.AQUA, ChatColor.RED, ChatColor.LIGHT_PURPLE, ChatColor.YELLOW, ChatColor.WHITE});
    private static final Set<ChatColor> FORMATS = EnumSet.of(ChatColor.BOLD, ChatColor.STRIKETHROUGH, ChatColor.UNDERLINE, ChatColor.ITALIC, ChatColor.RESET);
    private static final Set<ChatColor> MAGIC = EnumSet.of(ChatColor.MAGIC);
    private static final Pattern STRIP_ALL_PATTERN = Pattern.compile("\u00a7+([0-9a-fk-orA-FK-OR])");
    private static final Pattern STRIP_RGB_PATTERN = Pattern.compile("\u00a7x((?:\u00a7[0-9a-fA-F]){6})");
    private static final Pattern REPLACE_ALL_PATTERN = Pattern.compile("(&)?&([0-9a-fk-orA-FK-OR])");
    private static final Pattern REPLACE_ALL_RGB_PATTERN = Pattern.compile("(&)?&#([0-9a-fA-F]{6})");
    private static final Pattern LOGCOLOR_PATTERN = Pattern.compile("\\x1B\\[([0-9]{1,2}(;[0-9]{1,2})?)?[m|K]");
    private static final Pattern URL_PATTERN = Pattern.compile("((?:(?:https?)://)?[\\w-_\\.]{2,})\\.([a-zA-Z]{2,3}(?:/\\S+)?)");
    private static final Pattern ANSI_CONTROL_PATTERN = Pattern.compile("[\\x1B\\x9B][\\[\\]()#;?]*(?:(?:(?:;[-a-zA-Z\\d/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d/#&.:=?%@~_]*)*)?\\x07|(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-nq-uy=><~])");
    private static final Pattern PAPER_CONTROL_PATTERN = Pattern.compile("(?i)\u007f[0-9A-FK-ORX]");

    private FormatUtil() {
    }

    public static String stripFormat(String input) {
        if (input == null) {
            return null;
        }
        return ChatColor.stripColor((String)input);
    }

    public static String stripMiniFormat(String input) {
        if (input == null) {
            return null;
        }
        return AdventureUtil.miniMessage().stripTags(input);
    }

    public static String stripEssentialsFormat(String input) {
        if (input == null) {
            return null;
        }
        return FormatUtil.stripColor(FormatUtil.stripColor(input, REPLACE_ALL_PATTERN), REPLACE_ALL_RGB_PATTERN);
    }

    public static String stripAnsi(String input) {
        if (input == null) {
            return null;
        }
        return FormatUtil.stripColor(input, ANSI_CONTROL_PATTERN);
    }

    public static String stripPaper(String input) {
        if (input == null) {
            return null;
        }
        return FormatUtil.stripColor(input, PAPER_CONTROL_PATTERN);
    }

    public static String formatMessage(IUser user, String permBase, String input) {
        if (input == null) {
            return null;
        }
        String message = FormatUtil.formatString(user, permBase, input);
        if (!user.isAuthorized(permBase + ".url")) {
            message = FormatUtil.blockURL(message);
        }
        return message;
    }

    public static String replaceFormat(String input) {
        if (input == null) {
            return null;
        }
        return FormatUtil.replaceColor(input, EnumSet.allOf(ChatColor.class), true);
    }

    static String replaceColor(String input, Set<ChatColor> supported, boolean rgb) {
        StringBuffer legacyBuilder = new StringBuffer();
        Matcher legacyMatcher = REPLACE_ALL_PATTERN.matcher(input);
        block2: while (legacyMatcher.find()) {
            boolean isEscaped;
            boolean bl = isEscaped = legacyMatcher.group(1) != null;
            if (!isEscaped) {
                char code = legacyMatcher.group(2).toLowerCase(Locale.ROOT).charAt(0);
                for (ChatColor color : supported) {
                    if (color.getChar() != code) continue;
                    legacyMatcher.appendReplacement(legacyBuilder, "\u00a7$2");
                    continue block2;
                }
            }
            legacyMatcher.appendReplacement(legacyBuilder, "&$2");
        }
        legacyMatcher.appendTail(legacyBuilder);
        if (rgb) {
            StringBuffer rgbBuilder = new StringBuffer();
            Matcher rgbMatcher = REPLACE_ALL_RGB_PATTERN.matcher(legacyBuilder.toString());
            while (rgbMatcher.find()) {
                boolean isEscaped;
                boolean bl = isEscaped = rgbMatcher.group(1) != null;
                if (!isEscaped) {
                    try {
                        String hexCode = rgbMatcher.group(2);
                        rgbMatcher.appendReplacement(rgbBuilder, FormatUtil.parseHexColor(hexCode));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                rgbMatcher.appendReplacement(rgbBuilder, "&#$2");
            }
            rgbMatcher.appendTail(rgbBuilder);
            return rgbBuilder.toString();
        }
        return legacyBuilder.toString();
    }

    public static String parseHexColor(String hexColor) throws NumberFormatException {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_16_1_R01)) {
            throw new NumberFormatException("Cannot use RGB colors in versions < 1.16");
        }
        if (hexColor.startsWith("#")) {
            hexColor = hexColor.substring(1);
        }
        if (hexColor.length() != 6) {
            throw new NumberFormatException("Invalid hex length");
        }
        Color.fromRGB((int)Integer.decode("#" + hexColor));
        StringBuilder assembledColorCode = new StringBuilder();
        assembledColorCode.append("\u00a7x");
        for (char curChar : hexColor.toCharArray()) {
            assembledColorCode.append('\u00a7').append(curChar);
        }
        return assembledColorCode.toString();
    }

    static String stripColor(String input, Set<ChatColor> strip) {
        StringBuffer builder = new StringBuffer();
        Matcher matcher = STRIP_ALL_PATTERN.matcher(input);
        block0: while (matcher.find()) {
            char code = matcher.group(1).toLowerCase(Locale.ROOT).charAt(0);
            for (ChatColor color : strip) {
                if (color.getChar() != code) continue;
                matcher.appendReplacement(builder, "");
                continue block0;
            }
            matcher.appendReplacement(builder, "$0");
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static String unformatString(String message) {
        if (message == null) {
            return null;
        }
        return FormatUtil.unformatString(message, EnumSet.allOf(ChatColor.class), true);
    }

    public static String unformatString(IUser user, String permBase, String message) {
        if (message == null) {
            return null;
        }
        return FormatUtil.unformatString(message, FormatUtil.getSupported(user, permBase), user.isAuthorized(permBase + ".rgb"));
    }

    public static String unformatString(String message, EnumSet<ChatColor> supported, boolean rgb) {
        if (message == null) {
            return null;
        }
        StringBuffer rgbBuilder = new StringBuffer();
        Matcher rgbMatcher = STRIP_RGB_PATTERN.matcher(message);
        while (rgbMatcher.find()) {
            String code = rgbMatcher.group(1).replace(String.valueOf('\u00a7'), "");
            if (rgb) {
                rgbMatcher.appendReplacement(rgbBuilder, "&#" + code);
                continue;
            }
            rgbMatcher.appendReplacement(rgbBuilder, "");
        }
        rgbMatcher.appendTail(rgbBuilder);
        message = rgbBuilder.toString();
        StringBuffer builder = new StringBuffer();
        Matcher matcher = STRIP_ALL_PATTERN.matcher(message);
        block1: while (matcher.find()) {
            char code = matcher.group(1).toLowerCase(Locale.ROOT).charAt(0);
            for (ChatColor color : supported) {
                if (color.getChar() != code) continue;
                matcher.appendReplacement(builder, "&" + code);
                continue block1;
            }
            matcher.appendReplacement(builder, "");
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static String formatString(IUser user, String permBase, String message) {
        if (message == null) {
            return null;
        }
        EnumSet<ChatColor> supported = FormatUtil.getSupported(user, permBase);
        EnumSet<ChatColor> strip = EnumSet.complementOf(supported);
        boolean rgb = user.isAuthorized(permBase + ".rgb");
        if (!strip.isEmpty()) {
            message = FormatUtil.stripColor(message, strip);
        }
        if (!supported.isEmpty() || rgb) {
            message = FormatUtil.replaceColor(message, supported, rgb);
        }
        return message;
    }

    private static EnumSet<ChatColor> getSupported(IUser user, String permBase) {
        EnumSet<ChatColor> supported = EnumSet.noneOf(ChatColor.class);
        if (user.isAuthorized(permBase + ".color")) {
            supported.addAll(COLORS);
        }
        if (user.isAuthorized(permBase + ".format")) {
            supported.addAll(FORMATS);
        }
        if (user.isAuthorized(permBase + ".magic")) {
            supported.addAll(MAGIC);
        }
        for (ChatColor chatColor : ChatColor.values()) {
            String node;
            String colorName = chatColor.name();
            if (chatColor == ChatColor.MAGIC) {
                colorName = "obfuscated";
            }
            if (!user.isPermissionSet(node = permBase + "." + colorName.toLowerCase(Locale.ROOT))) continue;
            if (user.isAuthorized(node)) {
                supported.add(chatColor);
                continue;
            }
            supported.remove(chatColor);
        }
        return supported;
    }

    public static String stripLogColorFormat(String input) {
        if (input == null) {
            return null;
        }
        return FormatUtil.stripColor(input, LOGCOLOR_PATTERN);
    }

    static String stripColor(String input, Pattern pattern) {
        return pattern.matcher(input).replaceAll("");
    }

    public static String lastCode(String input) {
        int pos = input.lastIndexOf(167);
        if (pos == -1 || pos + 1 == input.length()) {
            return "";
        }
        return input.substring(pos, pos + 2);
    }

    static String blockURL(String input) {
        if (input == null) {
            return null;
        }
        String text = URL_PATTERN.matcher(input).replaceAll("$1 $2");
        while (URL_PATTERN.matcher(text).find()) {
            text = URL_PATTERN.matcher(text).replaceAll("$1 $2");
        }
        return text;
    }

    public static boolean validIP(String ipAddress) {
        return IPPATTERN.matcher(ipAddress).matches();
    }
}

