/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.textreader;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.textreader.IResolvable;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.textreader.ITranslatableText;

public class SimpleTextPager {
    private final transient IResolvable resolvable;

    public SimpleTextPager(IResolvable resolvable) {
        this.resolvable = resolvable;
    }

    public void showPage(CommandSource sender) {
        block3: {
            block2: {
                if (!(this.resolvable instanceof ITranslatableText)) break block2;
                ITranslatableText text = (ITranslatableText)this.resolvable;
                for (ITranslatableText.TranslatableText line : text.getLines()) {
                    sender.sendTl(line.getKey(), line.getArgs());
                }
                break block3;
            }
            if (!(this.resolvable instanceof IText)) break block3;
            for (String line : ((IText)this.resolvable).getLines()) {
                sender.sendMessage(line);
            }
        }
    }

    public void showPage(CommandSource sender, String pageStr, String commandName) {
        int page = 1;
        if (pageStr != null) {
            try {
                page = Integer.parseInt(pageStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (page < 1) {
                page = 1;
            }
        }
        int start = (page - 1) * 9;
        int end = this.resolvable.getLineCount();
        int pages = end / 9 + (end % 9 > 0 ? 1 : 0);
        if (page > pages) {
            sender.sendTl("infoUnknownChapter", new Object[0]);
            return;
        }
        if (commandName != null) {
            StringBuilder content = new StringBuilder();
            String[] title = commandName.split(" ", 2);
            if (title.length > 1) {
                content.append(I18n.capitalCase(title[0])).append(": ");
                content.append(title[1]);
            } else {
                content.append(I18n.capitalCase(commandName));
            }
            sender.sendTl("infoPages", page, pages, content);
        }
        for (int i = start; i < end && i < start + 9; ++i) {
            if (this.resolvable instanceof ITranslatableText) {
                ITranslatableText.TranslatableText text = ((ITranslatableText)this.resolvable).getLines().get(i);
                sender.sendTl(text.getKey(), text.getArgs());
                continue;
            }
            if (!(this.resolvable instanceof IText)) continue;
            sender.sendMessage(((IText)this.resolvable).getLines().get(i));
        }
        if (page < pages && commandName != null) {
            sender.sendTl("readNextPage", commandName, page + 1);
        }
    }
}

