/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.config;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.config.EssentialsConfiguration;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;

public class EssentialsUserConfiguration
extends EssentialsConfiguration {
    private String username;
    private final UUID uuid;

    public EssentialsUserConfiguration(String username, UUID uuid, File configFile) {
        super(configFile);
        this.username = username;
        this.uuid = uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean legacyFileExists() {
        if (this.username == null) {
            return false;
        }
        return new File(this.configFile.getParentFile(), this.username + ".yml").exists();
    }

    @Override
    public void convertLegacyFile() {
        File file = new File(this.configFile.getParentFile(), this.username + ".yml");
        try {
            Files.move((File)file, (File)new File(this.configFile.getParentFile(), this.uuid + ".yml"));
        }
        catch (IOException ex) {
            Essentials.getWrappedLogger().log(Level.WARNING, "Failed to migrate user: " + this.username, ex);
        }
        this.setProperty("last-account-name", this.username);
    }

    private File getAltFile() {
        UUID fn = UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.username.toLowerCase(Locale.ENGLISH)).getBytes(Charsets.UTF_8));
        return new File(this.configFile.getParentFile(), fn + ".yml");
    }

    @Override
    public boolean altFileExists() {
        if (this.username == null || this.username.equals(this.username.toLowerCase())) {
            return false;
        }
        return this.getAltFile().exists();
    }

    @Override
    public void convertAltFile() {
        try {
            Files.move((File)this.getAltFile(), (File)new File(this.configFile.getParentFile(), this.uuid + ".yml"));
        }
        catch (IOException ex) {
            Essentials.getWrappedLogger().log(Level.WARNING, "Failed to migrate user: " + this.username, ex);
        }
    }
}

