/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.craftbukkit.SetExpFix;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.CommonPlaceholders;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.NumberUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.Server;
import org.bukkit.Statistic;

public class Commandwhois
extends EssentialsCommand {
    private static final Statistic PLAY_ONE_TICK = EnumUtil.getStatistic("PLAY_ONE_MINUTE", "PLAY_ONE_TICK");

    public Commandwhois() {
        super("whois");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        String location;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.getPlayer(server, sender, args, 0);
        sender.sendTl("whoisTop", user.getName());
        user.setDisplayNick();
        sender.sendTl("whoisNick", user.getDisplayName());
        sender.sendTl("whoisUuid", user.getBase().getUniqueId().toString());
        sender.sendTl("whoisHealth", user.getBase().getHealth());
        sender.sendTl("whoisHunger", user.getBase().getFoodLevel(), Float.valueOf(user.getBase().getSaturation()));
        sender.sendTl("whoisExp", SetExpFix.getTotalExperience(user.getBase()), user.getBase().getLevel());
        sender.sendTl("whoisLocation", user.getLocation().getWorld().getName(), user.getLocation().getBlockX(), user.getLocation().getBlockY(), user.getLocation().getBlockZ());
        long playtimeMs = System.currentTimeMillis() - (long)user.getBase().getStatistic(PLAY_ONE_TICK) * 50L;
        sender.sendTl("whoisPlaytime", DateUtil.formatDateDiff(playtimeMs));
        if (!this.ess.getSettings().isEcoDisabled()) {
            sender.sendTl("whoisMoney", NumberUtil.displayCurrency(user.getMoney(), this.ess));
        }
        if (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.whois.ip")) {
            sender.sendTl("whoisIPAddress", user.getBase().getAddress().getAddress().toString());
        }
        if ((location = user.getGeoLocation()) != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendTl("whoisGeoLocation", location);
        }
        sender.sendTl("whoisGamemode", sender.tl(user.getBase().getGameMode().toString().toLowerCase(Locale.ENGLISH), new Object[0]));
        sender.sendTl("whoisGod", CommonPlaceholders.trueFalse(sender, user.isGodModeEnabled()));
        sender.sendTl("whoisOp", CommonPlaceholders.trueFalse(sender, user.getBase().isOp()));
        sender.sendTl("whoisFly", CommonPlaceholders.trueFalse(sender, user.getBase().getAllowFlight()), AdventureUtil.parsed(user.getBase().isFlying() ? sender.tl("flying", new Object[0]) : sender.tl("notFlying", new Object[0])));
        sender.sendTl("whoisSpeed", Float.valueOf(user.getBase().isFlying() ? user.getBase().getFlySpeed() : user.getBase().getWalkSpeed()));
        sender.sendTl("whoisWhitelist", CommonPlaceholders.trueFalse(sender, user.getBase().isWhitelisted()));
        if (user.isAfk()) {
            sender.sendTl("whoisAFKSince", CommonPlaceholders.trueFalse(sender, true), DateUtil.formatDateDiff(user.getAfkSince()));
        } else {
            sender.sendTl("whoisAFK", CommonPlaceholders.trueFalse(sender, false));
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = AdventureUtil.parsed(user.isJailed() ? (user.getJailTimeout() > 0L ? user.getFormattedJailTime() : sender.tl("true", new Object[0])) : sender.tl("false", new Object[0]));
        sender.sendTl("whoisJail", objectArray);
        long muteTimeout = user.getMuteTimeout();
        if (!user.hasMuteReason()) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = AdventureUtil.parsed(user.isMuted() ? (muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : sender.tl("true", new Object[0])) : sender.tl("false", new Object[0]));
            sender.sendTl("whoisMuted", objectArray2);
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = AdventureUtil.parsed(user.isMuted() ? (muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : sender.tl("true", new Object[0])) : sender.tl("false", new Object[0]));
            objectArray3[1] = user.getMuteReason();
            sender.sendTl("whoisMutedReason", objectArray3);
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

