/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ess3.api.TranslatableException;
import net.essentialsx.api.v2.events.TeleportRequestResponseEvent;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandtpdeny
extends EssentialsCommand {
    public Commandtpdeny() {
        super("tpdeny");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        IUser.TpaRequest denyRequest;
        boolean denyAll = args.length > 0 ? args[0].equals("*") || args[0].equalsIgnoreCase("all") : false;
        if (!user.hasPendingTpaRequests(false, false)) {
            throw new TranslatableException("noPendingRequest", new Object[0]);
        }
        if (args.length > 0) {
            if (denyAll) {
                this.denyAllRequests(user);
                return;
            }
            denyRequest = user.getOutstandingTpaRequest(this.getPlayer(server, user, args, 0).getName(), false);
        } else {
            denyRequest = user.getNextTpaRequest(false, true, false);
        }
        if (denyRequest == null) {
            throw new TranslatableException("noPendingRequest", new Object[0]);
        }
        User player = this.ess.getUser(denyRequest.getRequesterUuid());
        if (player == null || !player.getBase().isOnline()) {
            throw new TranslatableException("noPendingRequest", new Object[0]);
        }
        if (this.sendEvent(user, player, denyRequest)) {
            return;
        }
        user.sendTl("requestDenied", new Object[0]);
        player.sendTl("requestDeniedFrom", user.getDisplayName());
        user.removeTpaRequest(denyRequest.getName());
    }

    private void denyAllRequests(User user) {
        IUser.TpaRequest request;
        int count = 0;
        while ((request = user.getNextTpaRequest(false, true, false)) != null) {
            User player = this.ess.getUser(request.getRequesterUuid());
            if (this.sendEvent(user, player, request)) continue;
            if (player != null && player.getBase().isOnline()) {
                player.sendTl("requestDeniedFrom", user.getDisplayName());
            }
            user.removeTpaRequest(request.getName());
            ++count;
        }
        user.sendTl("requestDeniedAll", count);
    }

    private boolean sendEvent(User user, User player, IUser.TpaRequest request) {
        TeleportRequestResponseEvent event = new TeleportRequestResponseEvent(user, player, request, false);
        Bukkit.getPluginManager().callEvent((Event)event);
        boolean cancelled = event.isCancelled();
        if (cancelled && this.ess.getSettings().isDebug()) {
            this.ess.getLogger().info("TPA deny cancelled by API for " + user.getName() + " (requested by " + player.getName() + ")");
        }
        return event.isCancelled();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>(user.getPendingTpaKeys());
            options.add("*");
            return options;
        }
        return Collections.emptyList();
    }
}

