/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.ess3.api.TranslatableException;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

public class Commandskull
extends EssentialsCommand {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[A-Za-z0-9_]+$");
    private static final Pattern URL_VALUE_PATTERN = Pattern.compile("^[0-9a-fA-F]{64}$");
    private static final Pattern BASE_64_PATTERN = Pattern.compile("^[A-Za-z0-9+/=]{180}$");
    private static final Material SKULL_ITEM = EnumUtil.getMaterial("PLAYER_HEAD", "SKULL_ITEM");
    private final boolean playerProfileSupported;

    public Commandskull() {
        super("skull");
        boolean playerProfileSupported = true;
        try {
            Class.forName("org.bukkit.profile.PlayerProfile");
        }
        catch (ClassNotFoundException e) {
            playerProfileSupported = false;
        }
        this.playerProfileSupported = playerProfileSupported;
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        SkullMeta metaSkull;
        String owner;
        if (args.length > 0 && user.isAuthorized("essentials.skull.others")) {
            if (BASE_64_PATTERN.matcher(args[0]).matches()) {
                try {
                    String decoded = new String(Base64.getDecoder().decode(args[0]));
                    JsonObject jsonObject = JsonParser.parseString((String)decoded).getAsJsonObject();
                    String url = jsonObject.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
                    owner = url.substring(url.lastIndexOf("/") + 1);
                }
                catch (Exception e) {
                    throw new TranslatableException("skullInvalidBase64", new Object[0]);
                }
                if (!URL_VALUE_PATTERN.matcher(owner).matches()) {
                    throw new TranslatableException("skullInvalidBase64", new Object[0]);
                }
            } else {
                if (!NAME_PATTERN.matcher(args[0]).matches()) {
                    throw new TranslatableException("alphaNames", new Object[0]);
                }
                owner = args[0];
            }
        } else {
            owner = user.getName();
        }
        ItemStack itemSkull = user.getItemInHand();
        boolean spawn = false;
        if (itemSkull != null && MaterialUtil.isPlayerHead(itemSkull)) {
            metaSkull = (SkullMeta)itemSkull.getItemMeta();
        } else if (user.isAuthorized("essentials.skull.spawn")) {
            itemSkull = new ItemStack(SKULL_ITEM, 1, 3);
            metaSkull = (SkullMeta)itemSkull.getItemMeta();
            spawn = true;
        } else {
            throw new TranslatableException("invalidSkull", new Object[0]);
        }
        if (metaSkull.hasOwner() && !user.isAuthorized("essentials.skull.modify")) {
            throw new TranslatableException("noPermissionSkull", new Object[0]);
        }
        this.editSkull(user, itemSkull, metaSkull, owner, spawn);
    }

    private void editSkull(User user, ItemStack stack, SkullMeta skullMeta, String owner, boolean spawn) {
        this.ess.runTaskAsynchronously(() -> {
            String shortOwnerName;
            if (URL_VALUE_PATTERN.matcher(owner).matches()) {
                URL url;
                if (!this.playerProfileSupported) {
                    user.sendTl("unsupportedFeature", new Object[0]);
                    return;
                }
                try {
                    url = new URL("https://textures.minecraft.net/texture/" + owner);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                PlayerProfile profile = this.ess.getServer().createPlayerProfile(UUID.randomUUID());
                profile.getTextures().setSkin(url);
                skullMeta.setOwnerProfile(profile);
                shortOwnerName = owner.substring(0, 7);
            } else {
                skullMeta.setOwner(owner);
                shortOwnerName = owner;
            }
            skullMeta.setDisplayName("\u00a7fSkull of " + shortOwnerName);
            this.ess.scheduleSyncDelayedTask(() -> {
                stack.setItemMeta((ItemMeta)skullMeta);
                if (spawn) {
                    Inventories.addItem(user.getBase(), stack);
                    user.sendTl("givenSkull", shortOwnerName);
                    return;
                }
                user.sendTl("skullChanged", shortOwnerName);
            });
        });
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            if (user.isAuthorized("essentials.skull.others")) {
                return this.getPlayers(server, user);
            }
            return Lists.newArrayList((Object[])new String[]{user.getName()});
        }
        return Collections.emptyList();
    }
}

