/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.Statistic;

public class Commandplaytime
extends EssentialsCommand {
    private static final Statistic PLAY_ONE_TICK = EnumUtil.getStatistic("PLAY_ONE_MINUTE", "PLAY_ONE_TICK");

    public Commandplaytime() {
        super("playtime");
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        String key;
        long playtime;
        String displayName;
        if (args.length > 0 && sender.isAuthorized("essentials.playtime.others")) {
            block7: {
                try {
                    User user = this.getPlayer(server, sender, args, 0);
                    displayName = user.getDisplayName();
                    playtime = user.getBase().getStatistic(PLAY_ONE_TICK);
                }
                catch (PlayerNotFoundException e) {
                    if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_15_2_R01)) {
                        throw e;
                    }
                    User user = this.getPlayer(server, args, 0, true, true);
                    displayName = user.getName();
                    playtime = Bukkit.getOfflinePlayer((UUID)user.getBase().getUniqueId()).getStatistic(PLAY_ONE_TICK);
                    if (!user.getBase().isOnline() || !user.isVanished()) break block7;
                    playtime -= (System.currentTimeMillis() - user.getLastVanishTime()) / 50L;
                }
            }
            key = "playtimeOther";
        } else if (sender.isPlayer()) {
            displayName = sender.getPlayer().getDisplayName();
            playtime = sender.getPlayer().getStatistic(PLAY_ONE_TICK);
            key = "playtime";
        } else {
            throw new NotEnoughArgumentsException();
        }
        long playtimeMs = System.currentTimeMillis() - playtime * 50L;
        sender.sendTl(key, DateUtil.formatDateDiff(playtimeMs), AdventureUtil.parsed(AdventureUtil.legacyToMini(displayName)));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1 && sender.isAuthorized("essentials.playtime.others")) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

