/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.AdventureUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;

public class Commandnear
extends EssentialsCommand {
    public Commandnear() {
        super("near");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        long maxRadius = this.ess.getSettings().getNearRadius();
        if (maxRadius == 0L) {
            maxRadius = 200L;
        }
        long radius = maxRadius;
        User otherUser = null;
        if (args.length > 0) {
            try {
                radius = Long.parseLong(args[0]);
            }
            catch (NumberFormatException e) {
                try {
                    otherUser = this.getPlayer(server, user, args, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (args.length > 1 && otherUser != null) {
                try {
                    radius = Long.parseLong(args[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((radius = Math.abs(radius)) > maxRadius && !user.isAuthorized("essentials.near.maxexempt")) {
            user.sendTl("radiusTooBig", maxRadius);
            radius = maxRadius;
        }
        if (otherUser == null || !user.isAuthorized("essentials.near.others")) {
            otherUser = user;
        }
        user.sendTl("nearbyPlayers", AdventureUtil.parsed(this.getLocal(user.getSource(), otherUser, radius)));
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        User otherUser = this.getPlayer(server, args, 0, true, false);
        long radius = 200L;
        if (args.length > 1) {
            try {
                radius = Long.parseLong(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        sender.sendTl("nearbyPlayers", AdventureUtil.parsed(this.getLocal(sender, otherUser, radius)));
    }

    private String getLocal(CommandSource source, User user, long radius) {
        Location loc = user.getLocation();
        World world = loc.getWorld();
        StringBuilder output = new StringBuilder();
        long radiusSquared = radius * radius;
        boolean showHidden = user.canInteractVanished();
        PriorityQueue<User> nearbyPlayers = new PriorityQueue<User>((o1, o2) -> (int)(o1.getLocation().distanceSquared(loc) - o2.getLocation().distanceSquared(loc)));
        for (User player : this.ess.getOnlineUsers()) {
            long delta;
            Location playerLoc;
            if (player.equals(user) || player.isAuthorized("essentials.near.exclude") || player.isHidden(user.getBase()) && !showHidden && player.isHiddenFrom(user.getBase()) || (playerLoc = player.getLocation()).getWorld() != world || (delta = (long)playerLoc.distanceSquared(loc)) >= radiusSquared) continue;
            nearbyPlayers.offer(player);
        }
        while (!nearbyPlayers.isEmpty()) {
            User nearbyPlayer;
            if (output.length() > 0) {
                output.append(", ");
            }
            if ((nearbyPlayer = (User)nearbyPlayers.poll()) == null) continue;
            output.append(user.playerTl("nearbyPlayersList", nearbyPlayer.getDisplayName(), (long)nearbyPlayer.getLocation().distance(loc)));
        }
        return output.length() > 1 ? output.toString() : source.tl("none", new Object[0]);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (user.isAuthorized("essentials.near.others")) {
            if (args.length == 1) {
                return this.getPlayers(server, user);
            }
            if (args.length == 2) {
                return Lists.newArrayList((Object[])new String[]{Integer.toString(this.ess.getSettings().getNearRadius())});
            }
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{Integer.toString(this.ess.getSettings().getNearRadius())});
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{Integer.toString(this.ess.getSettings().getNearRadius())});
        }
        return Collections.emptyList();
    }
}

