/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.ess3.api.TranslatableException;
import net.essentialsx.api.v2.events.UserActionEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Commandme
extends EssentialsCommand {
    public Commandme() {
        super("me");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (user.isMuted()) {
            String dateDiff;
            String string = dateDiff = user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : null;
            if (dateDiff == null) {
                throw new TranslatableException(user.hasMuteReason() ? "voiceSilencedReason" : "voiceSilenced", user.getMuteReason());
            }
            throw new TranslatableException(user.hasMuteReason() ? "voiceSilencedReasonTime" : "voiceSilencedTime", dateDiff, user.getMuteReason());
        }
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String message = Commandme.getFinalArg(args, 0);
        message = FormatUtil.formatMessage(user, "essentials.chat", message);
        user.setDisplayNick();
        long radius = this.ess.getSettings().getChatRadius();
        if (radius < 1L) {
            this.ess.broadcastTl("action", user.getDisplayName(), message);
            this.ess.getServer().getPluginManager().callEvent((Event)new UserActionEvent(user, message, Collections.unmodifiableCollection(this.ess.getServer().getOnlinePlayers())));
            return;
        }
        radius *= radius;
        World world = user.getWorld();
        Location loc = user.getLocation();
        HashSet<User> outList = new HashSet<User>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            User onlineUser = this.ess.getUser(player);
            if (!onlineUser.equals(user)) {
                boolean abort = false;
                Location playerLoc = onlineUser.getLocation();
                if (playerLoc.getWorld() != world) {
                    abort = true;
                } else if (onlineUser.isIgnoredPlayer(user)) {
                    abort = true;
                } else {
                    double delta = playerLoc.distanceSquared(loc);
                    if (delta > (double)radius) {
                        abort = true;
                    }
                }
                if (abort) {
                    if (!onlineUser.isAuthorized("essentials.chat.spy")) continue;
                    outList.add(onlineUser);
                    continue;
                }
                outList.add(onlineUser);
                continue;
            }
            outList.add(onlineUser);
        }
        if (outList.size() < 2) {
            user.sendTl("localNoOne", new Object[0]);
        }
        for (User onlineUser : outList) {
            onlineUser.sendTl("action", user.getDisplayName(), message);
        }
        if (UserActionEvent.getHandlerList().getRegisteredListeners().length > 0) {
            HashSet<Player> outListPlayers = new HashSet<Player>();
            for (User onlineUser : outList) {
                outListPlayers.add(onlineUser.getBase());
            }
            this.ess.getServer().getPluginManager().callEvent((Event)new UserActionEvent(user, message, Collections.unmodifiableCollection(outListPlayers)));
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String message = Commandme.getFinalArg(args, 0);
        message = FormatUtil.replaceFormat(message);
        this.ess.broadcastTl("action", "@", message);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        return Collections.emptyList();
    }
}

