/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerExemptException;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.ess3.api.MaxMoneyException;
import net.ess3.api.TranslatableException;
import net.ess3.api.events.UserBalanceUpdateEvent;
import org.bukkit.Server;

public class Commandeco
extends EssentialsLoopCommand {
    public Commandeco() {
        super("eco");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        BigDecimal amount;
        boolean isPercent;
        EcoCommands cmd;
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        try {
            cmd = EcoCommands.valueOf(args[0].toUpperCase(Locale.ENGLISH));
            isPercent = cmd != EcoCommands.RESET && args[2].endsWith("%");
            amount = cmd == EcoCommands.RESET ? this.ess.getSettings().getStartingBalance() : new BigDecimal(args[2].replaceAll("[^0-9\\.]", ""));
        }
        catch (Exception ex) {
            throw new NotEnoughArgumentsException(ex);
        }
        this.loopOfflinePlayersConsumer(server, sender, false, true, args[1], player -> {
            BigDecimal userAmount = amount;
            if (isPercent) {
                userAmount = player.getMoney().multiply(userAmount).scaleByPowerOfTen(-2);
            }
            switch (cmd.ordinal()) {
                case 0: {
                    player.giveMoney(userAmount, sender, UserBalanceUpdateEvent.Cause.COMMAND_ECO);
                    break;
                }
                case 1: {
                    if (player.getMoney().subtract(userAmount).compareTo(this.ess.getSettings().getMinMoney()) >= 0) {
                        player.takeMoney(userAmount, sender, UserBalanceUpdateEvent.Cause.COMMAND_ECO);
                        break;
                    }
                    this.ess.showError(sender, new TranslatableException("minimumBalanceError", NumberUtil.displayCurrency(this.ess.getSettings().getMinMoney(), this.ess)), commandLabel);
                    break;
                }
                case 2: 
                case 3: {
                    boolean aboveMax;
                    BigDecimal minBal = this.ess.getSettings().getMinMoney();
                    BigDecimal maxBal = this.ess.getSettings().getMaxMoney();
                    boolean underMin = userAmount.compareTo(minBal) < 0;
                    boolean bl = aboveMax = userAmount.compareTo(maxBal) > 0;
                    player.setMoney(underMin ? minBal : (aboveMax ? maxBal : userAmount), UserBalanceUpdateEvent.Cause.COMMAND_ECO);
                    player.sendTl("setBal", NumberUtil.displayCurrency(player.getMoney(), this.ess));
                    sender.sendTl("setBalOthers", player.getDisplayName(), NumberUtil.displayCurrency(player.getMoney(), this.ess));
                    break;
                }
            }
        });
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User user, String[] args) throws NotEnoughArgumentsException, PlayerExemptException, ChargeException, MaxMoneyException {
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList();
            for (EcoCommands command : EcoCommands.values()) {
                options.add(command.name().toLowerCase(Locale.ENGLISH));
            }
            return options;
        }
        if (args.length == 2) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 3 && !args[0].equalsIgnoreCase(EcoCommands.RESET.name())) {
            if (args[0].equalsIgnoreCase(EcoCommands.SET.name())) {
                return Lists.newArrayList((Object[])new String[]{"0", this.ess.getSettings().getStartingBalance().toString()});
            }
            return Lists.newArrayList((Object[])new String[]{"1", "10", "100", "1000"});
        }
        return Collections.emptyList();
    }

    private static enum EcoCommands {
        GIVE,
        TAKE,
        SET,
        RESET;

    }
}

