/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Collections;
import java.util.List;
import net.ess3.api.TranslatableException;
import org.bukkit.Server;

public class Commandback
extends EssentialsCommand {
    public Commandback() {
        super("back");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        CommandSource sender = user.getSource();
        if (args.length > 0 && user.isAuthorized("essentials.back.others")) {
            this.parseOthers(server, sender, args, commandLabel);
            return;
        }
        this.teleportBack(sender, user, commandLabel);
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        this.parseOthers(server, sender, args, commandLabel);
    }

    private void parseOthers(Server server, CommandSource sender, String[] args, String commandLabel) throws Exception {
        User player = this.getPlayer(server, args, 0, true, false);
        sender.sendTl("backOther", player.getName());
        this.teleportBack(sender, player, commandLabel);
    }

    private void teleportBack(CommandSource sender, User user, String commandLabel) throws Exception {
        if (user.getLastLocation() == null) {
            throw new TranslatableException("noLocationFound", new Object[0]);
        }
        String lastWorldName = user.getLastLocation().getWorld().getName();
        User requester = null;
        if (sender.isPlayer()) {
            requester = this.ess.getUser(sender.getPlayer());
            if (user.getWorld() != user.getLastLocation().getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + lastWorldName)) {
                throw new TranslatableException("noPerm", "essentials.worlds." + lastWorldName);
            }
            if (!requester.isAuthorized("essentials.back.into." + lastWorldName)) {
                throw new TranslatableException("noPerm", "essentials.back.into." + lastWorldName);
            }
        }
        if (requester == null) {
            user.getAsyncTeleport().back(null, null, this.getNewExceptionFuture(sender, commandLabel));
        } else if (!requester.equals(user)) {
            Trade charge = new Trade(this.getName(), this.ess);
            charge.isAffordableFor(requester);
            user.getAsyncTeleport().back(requester, charge, this.getNewExceptionFuture(sender, commandLabel));
        } else {
            Trade charge = new Trade(this.getName(), this.ess);
            charge.isAffordableFor(user);
            user.getAsyncTeleport().back(charge, this.getNewExceptionFuture(sender, commandLabel));
        }
        throw new NoChargeException();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (user.isAuthorized("essentials.back.others") && args.length == 1) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }
}

