/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.FakeAccessor;
import com.earth2me.essentials.FakeWorld;
import com.earth2me.essentials.OfflinePlayerStub;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.map.MapView;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scheduler.BukkitWorker;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.util.CachedServerIcon;

public final class FakeServer
implements Server {
    private final List<World> worlds = new ArrayList<World>();
    private final PluginManager pluginManager = new FakePluginManager();
    private final List<Player> players = new ArrayList<Player>();

    private FakeServer() {
        this.createWorld("testWorld", World.Environment.NORMAL);
    }

    public static FakeServer getServer() {
        if (Bukkit.getServer() == null) {
            Bukkit.setServer((Server)new FakeServer());
        }
        return (FakeServer)Bukkit.getServer();
    }

    public String getName() {
        return "Essentials Fake Server";
    }

    public String getVersion() {
        return "1.0";
    }

    public Collection<? extends Player> getOnlinePlayers() {
        return this.players;
    }

    public int getMaxPlayers() {
        return 100;
    }

    public int getPort() {
        return 25565;
    }

    public String getIp() {
        return "127.0.0.1";
    }

    public String getServerName() {
        return this.getName();
    }

    public String getServerId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int broadcastMessage(String string) {
        int i = 0;
        for (Player player : this.players) {
            player.sendMessage(string);
            ++i;
        }
        return i;
    }

    public String getUpdateFolder() {
        return "update";
    }

    public File getUpdateFolderFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isHardcore() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Player getPlayer(String string) {
        for (Player player : this.players) {
            if (!player.getName().equalsIgnoreCase(string)) continue;
            return player;
        }
        return null;
    }

    public List<Player> matchPlayer(String string) {
        ArrayList<Player> matches = new ArrayList<Player>();
        for (Player player : this.players) {
            if (!player.getName().substring(0, Math.min(player.getName().length(), string.length())).equalsIgnoreCase(string)) continue;
            matches.add(player);
        }
        return matches;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public BukkitScheduler getScheduler() {
        return new BukkitScheduler(){

            public int scheduleSyncDelayedTask(Plugin plugin, Runnable r, long l) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int scheduleSyncDelayedTask(Plugin plugin, BukkitRunnable bukkitRunnable, long l) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int scheduleSyncDelayedTask(Plugin plugin, Runnable r) {
                return -1;
            }

            public int scheduleSyncDelayedTask(Plugin plugin, BukkitRunnable bukkitRunnable) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int scheduleSyncRepeatingTask(Plugin plugin, Runnable r, long l, long l1) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int scheduleSyncRepeatingTask(Plugin plugin, BukkitRunnable bukkitRunnable, long l, long l1) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int scheduleAsyncRepeatingTask(Plugin plugin, Runnable r, long l, long l1) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public <T> Future<T> callSyncMethod(Plugin plugin, Callable<T> clbl) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void cancelTask(int i) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void cancelTasks(Plugin plugin) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void cancelAllTasks() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isCurrentlyRunning(int i) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isQueued(int i) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public List<BukkitWorker> getActiveWorkers() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public List<BukkitTask> getPendingTasks() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public BukkitTask runTask(Plugin plugin, Runnable r) throws IllegalArgumentException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public BukkitTask runTask(Plugin plugin, BukkitRunnable bukkitRunnable) throws IllegalArgumentException {
                return null;
            }

            public BukkitTask runTaskAsynchronously(Plugin plugin, Runnable r) throws IllegalArgumentException {
                r.run();
                return null;
            }

            public BukkitTask runTaskAsynchronously(Plugin plugin, BukkitRunnable bukkitRunnable) throws IllegalArgumentException {
                return null;
            }

            public BukkitTask runTaskLater(Plugin plugin, Runnable r, long l) throws IllegalArgumentException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public BukkitTask runTaskLater(Plugin plugin, BukkitRunnable bukkitRunnable, long l) throws IllegalArgumentException {
                return null;
            }

            public BukkitTask runTaskLaterAsynchronously(Plugin plugin, Runnable r, long l) throws IllegalArgumentException {
                r.run();
                return null;
            }

            public BukkitTask runTaskLaterAsynchronously(Plugin plugin, BukkitRunnable bukkitRunnable, long l) throws IllegalArgumentException {
                return null;
            }

            public BukkitTask runTaskTimer(Plugin plugin, Runnable r, long l, long l1) throws IllegalArgumentException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public BukkitTask runTaskTimer(Plugin plugin, BukkitRunnable bukkitRunnable, long l, long l1) throws IllegalArgumentException {
                return null;
            }

            public BukkitTask runTaskTimerAsynchronously(Plugin plugin, Runnable r, long l, long l1) throws IllegalArgumentException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public BukkitTask runTaskTimerAsynchronously(Plugin plugin, BukkitRunnable bukkitRunnable, long l, long l1) throws IllegalArgumentException {
                return null;
            }

            public int scheduleAsyncDelayedTask(Plugin plugin, Runnable r, long l) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int scheduleAsyncDelayedTask(Plugin plugin, Runnable r) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public ServicesManager getServicesManager() {
        return new ServicesManager(){

            public <T> void register(Class<T> service, T provider, Plugin plugin, ServicePriority priority) {
            }

            public void unregisterAll(Plugin plugin) {
            }

            public void unregister(Class<?> service, Object provider) {
            }

            public void unregister(Object provider) {
            }

            public <T> T load(Class<T> service) {
                return null;
            }

            public <T> RegisteredServiceProvider<T> getRegistration(Class<T> service) {
                return null;
            }

            public List<RegisteredServiceProvider<?>> getRegistrations(Plugin plugin) {
                return null;
            }

            public <T> Collection<RegisteredServiceProvider<T>> getRegistrations(Class<T> service) {
                return null;
            }

            public Collection<Class<?>> getKnownServices() {
                return null;
            }

            public <T> boolean isProvidedFor(Class<T> service) {
                return false;
            }
        };
    }

    public List<World> getWorlds() {
        return this.worlds;
    }

    public World createWorld(String string, World.Environment e) {
        FakeWorld w = new FakeWorld(string, e);
        this.worlds.add(w);
        return w;
    }

    public World getWorld(String string) {
        for (World world : this.worlds) {
            if (!world.getName().equalsIgnoreCase(string)) continue;
            return world;
        }
        return null;
    }

    public World getWorld(UUID uuid) {
        for (World world : this.worlds) {
            if (!world.getUID().equals(uuid)) continue;
            return world;
        }
        return null;
    }

    public MapView getMap(short id) {
        return null;
    }

    public void reload() {
    }

    public Logger getLogger() {
        return Logger.getLogger("Minecraft");
    }

    public PluginCommand getPluginCommand(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void savePlayers() {
    }

    public boolean dispatchCommand(CommandSender cs, String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean addRecipe(Recipe recipe) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void addPlayer(Player base1) {
        this.players.add(base1);
        this.pluginManager.callEvent((Event)new PlayerJoinEvent(base1, null));
    }

    OfflinePlayerStub createPlayer(String name) {
        OfflinePlayerStub player = new OfflinePlayerStub(name, (Server)this);
        player.setLocation(new Location(this.worlds.get(0), 0.0, 0.0, 0.0, 0.0f, 0.0f));
        return player;
    }

    public World createWorld(WorldCreator creator) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean unloadWorld(String string, boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean unloadWorld(World world, boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, String[]> getCommandAliases() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getSpawnRadius() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSpawnRadius(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean getOnlineMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MapView getMap(int id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getViewDistance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean getAllowNether() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasWhitelist() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MapView createMap(World world) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean getAllowFlight() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setWhitelist(boolean bln) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<OfflinePlayer> getWhitelistedPlayers() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reloadWhitelist() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Player getPlayerExact(String string) {
        for (Player player : this.players) {
            if (!player.getName().equals(string)) continue;
            return player;
        }
        return null;
    }

    public void shutdown() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int broadcast(String string, String string1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OfflinePlayer getOfflinePlayer(String string) {
        return this.createOPlayer(string);
    }

    private OfflinePlayer createOPlayer(final String string) {
        return new OfflinePlayer(){

            public boolean isOnline() {
                return false;
            }

            public String getName() {
                return string;
            }

            public boolean isBanned() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isWhitelisted() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void setWhitelisted(boolean bln) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Player getPlayer() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isOp() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Map<String, Object> serialize() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public long getFirstPlayed() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void setOp(boolean bln) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public long getLastPlayed() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean hasPlayedBefore() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Location getBedSpawnLocation() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public UUID getUniqueId() {
                switch (string) {
                    case "testPlayer1": {
                        return UUID.fromString("3c9ebe1a-9098-43fd-bc0c-a369b76817ba");
                    }
                    case "testPlayer2": {
                        return UUID.fromString("2c9ebe1a-9098-43fd-bc0c-a369b76817ba");
                    }
                    case "npc1": {
                        return UUID.fromString("f4a37409-5c40-3b2c-9cd6-57d3c5abdc76");
                    }
                }
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public Set<String> getIPBans() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void banIP(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unbanIP(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public GameMode getDefaultGameMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDefaultGameMode(GameMode gamemode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ConsoleCommandSender getConsoleSender() {
        return new ConsoleCommandSender(){

            public void sendMessage(String message) {
                System.out.println("Console message: " + message);
            }

            public void sendMessage(String[] messages) {
                for (String message : messages) {
                    System.out.println("Console message: " + message);
                }
            }

            public void sendMessage(UUID uuid, String message) {
                this.sendMessage(message);
            }

            public void sendMessage(UUID uuid, String[] messages) {
                this.sendMessage(messages);
            }

            public Server getServer() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String getName() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isPermissionSet(String name) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isPermissionSet(Permission perm) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean hasPermission(String name) {
                return true;
            }

            public boolean hasPermission(Permission perm) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public PermissionAttachment addAttachment(Plugin plugin) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void removeAttachment(PermissionAttachment attachment) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void recalculatePermissions() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Set<PermissionAttachmentInfo> getEffectivePermissions() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isOp() {
                return true;
            }

            public boolean isConversing() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void acceptConversationInput(String input) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void setOp(boolean value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean beginConversation(Conversation conversation) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void abandonConversation(Conversation conversation) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void sendRawMessage(String message) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public Set<OfflinePlayer> getOperators() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getBukkitVersion() {
        return "Essentials Fake-Server";
    }

    public File getWorldContainer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OfflinePlayerStub[] getOfflinePlayers() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean getAllowEnd() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Messenger getMessenger() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void sendPluginMessage(Plugin plugin, String string, byte[] bytes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<String> getListeningPluginChannels() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getTicksPerAnimalSpawns() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getTicksPerMonsterSpawns() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Recipe> getRecipesFor(ItemStack is) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Iterator<Recipe> recipeIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clearRecipes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resetRecipes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public HelpMap getHelpMap() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Inventory createInventory(InventoryHolder ih, InventoryType it) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Inventory createInventory(InventoryHolder ih, int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Inventory createInventory(InventoryHolder ih, int i, String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Merchant createMerchant(String s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getWorldType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean getGenerateStructures() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getConnectionThrottle() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getMonsterSpawnLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getAnimalSpawnLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getWaterAnimalSpawnLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isPrimaryThread() {
        return true;
    }

    public String getMotd() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Warning.WarningState getWarningState() {
        return Warning.WarningState.DEFAULT;
    }

    public int getAmbientSpawnLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getShutdownMessage() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ItemFactory getItemFactory() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ScoreboardManager getScoreboardManager() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CachedServerIcon getServerIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CachedServerIcon loadServerIcon(File file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CachedServerIcon loadServerIcon(BufferedImage bufferedImage) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getIdleTimeout() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setIdleTimeout(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ChunkGenerator.ChunkData createChunkData(World world) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BossBar createBossBar(String s, BarColor barColor, BarStyle barStyle, BarFlag ... barFlags) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public UnsafeValues getUnsafe() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BanList getBanList(BanList.Type arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Player getPlayer(UUID arg0) {
        for (Player player : this.players) {
            if (!player.getUniqueId().equals(arg0)) continue;
            return player;
        }
        return null;
    }

    public OfflinePlayer getOfflinePlayer(UUID arg0) {
        if (arg0.toString().equalsIgnoreCase("3c9ebe1a-9098-43fd-bc0c-a369b76817ba")) {
            return this.createOPlayer("testPlayer1");
        }
        if (arg0.toString().equalsIgnoreCase("f4a37409-5c40-3b2c-9cd6-57d3c5abdc76")) {
            return this.createOPlayer("npc1");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Inventory createInventory(InventoryHolder arg0, InventoryType arg1, String arg2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reloadData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Entity getEntity(UUID uuid) {
        return this.getPlayer(uuid);
    }

    public Advancement getAdvancement(NamespacedKey key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Iterator<Advancement> advancementIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static class FakePluginManager
    implements PluginManager {
        final ArrayList<RegisteredListener> listeners = new ArrayList();

        FakePluginManager() {
        }

        public void registerInterface(Class<? extends PluginLoader> loader) throws IllegalArgumentException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Plugin getPlugin(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Plugin[] getPlugins() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isPluginEnabled(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isPluginEnabled(Plugin plugin) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Plugin loadPlugin(File file) throws UnknownDependencyException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Plugin[] loadPlugins(File directory) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void disablePlugins() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void clearPlugins() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void callEvent(Event event) throws IllegalStateException {
            Logger.getLogger("Minecraft").info("Called event " + event.getEventName());
            if (event instanceof PlayerJoinEvent) {
                for (RegisteredListener listener : this.listeners) {
                    if (!(listener.getListener() instanceof FakeAccessor)) continue;
                    PlayerJoinEvent jEvent = (PlayerJoinEvent)event;
                    FakeAccessor epl = (FakeAccessor)listener.getListener();
                    epl.onPlayerJoin(jEvent);
                    Logger.getLogger("Essentials").info("Sending join event to Essentials");
                    epl.getUser(jEvent.getPlayer());
                }
            }
        }

        public void registerEvents(Listener listener, Plugin plugin) {
            this.listeners.add(new RegisteredListener(listener, null, null, plugin, false));
        }

        public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin) {
            this.listeners.add(new RegisteredListener(listener, executor, priority, plugin, false));
        }

        public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin, boolean ignoreCancelled) {
            this.listeners.add(new RegisteredListener(listener, executor, priority, plugin, false));
        }

        public void enablePlugin(Plugin plugin) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void disablePlugin(Plugin plugin) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Permission getPermission(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addPermission(Permission perm) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void removePermission(Permission perm) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void removePermission(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<Permission> getDefaultPermissions(boolean op) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void recalculatePermissionDefaults(Permission perm) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void subscribeToPermission(String permission, Permissible permissible) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void unsubscribeFromPermission(String permission, Permissible permissible) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<Permissible> getPermissionSubscriptions(String permission) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void subscribeToDefaultPerms(boolean op, Permissible permissible) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void unsubscribeFromDefaultPerms(boolean op, Permissible permissible) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<Permissible> getDefaultPermSubscriptions(boolean op) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<Permission> getPermissions() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean useTimings() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

