/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import com.earth2me.essentials.libs.kyori.adventure.text.Component;
import com.earth2me.essentials.utils.AdventureUtil;
import net.ess3.api.IUser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandSource {
    protected Essentials ess;
    protected CommandSender sender;

    public CommandSource(Essentials ess, CommandSender base) {
        this.ess = ess;
        this.sender = base;
    }

    public final CommandSender getSender() {
        return this.sender;
    }

    public final Player getPlayer() {
        if (this.sender instanceof Player) {
            return (Player)this.sender;
        }
        return null;
    }

    public void sendTl(String tlKey, Object ... args) {
        if (this.isPlayer()) {
            this.getUser().sendTl(tlKey, args);
            return;
        }
        String translation = I18n.tlLiteral(tlKey, args);
        if (!translation.isEmpty()) {
            this.sendComponent((Component)AdventureUtil.miniMessage().deserialize(translation));
        }
    }

    public String tl(String tlKey, Object ... args) {
        if (this.isPlayer()) {
            return this.getUser().playerTl(tlKey, args);
        }
        return I18n.tlLiteral(tlKey, args);
    }

    public Component tlComponent(String tlKey, Object ... args) {
        if (this.isPlayer()) {
            return this.getUser().tlComponent(tlKey, args);
        }
        String translation = I18n.tlLiteral(tlKey, args);
        return AdventureUtil.miniMessage().deserialize(translation);
    }

    public void sendComponent(Component component) {
        BukkitAudiences audiences = this.ess.getBukkitAudience();
        audiences.sender(this.sender).sendMessage(component);
    }

    public final IUser getUser() {
        if (this.sender instanceof Player) {
            return this.ess.getUser((Player)this.sender);
        }
        return null;
    }

    public final boolean isPlayer() {
        return this.sender instanceof Player;
    }

    public final CommandSender setSender(CommandSender base) {
        this.sender = base;
        return this.sender;
    }

    public void sendMessage(String message) {
        if (!message.isEmpty()) {
            this.sender.sendMessage(message);
        }
    }

    public boolean isAuthorized(String permission) {
        return !(this.sender instanceof Player) || this.getUser().isAuthorized(permission);
    }

    public String getSelfSelector() {
        return this.sender instanceof Player ? this.getPlayer().getName() : "*";
    }

    public String getDisplayName() {
        return this.sender instanceof Player ? this.getPlayer().getDisplayName() : this.getSender().getName();
    }
}

