/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.updatecheck;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.libs.kyori.adventure.text.Component;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public final class UpdateChecker {
    private static final String REPO = "EssentialsX/Essentials";
    private static final String BRANCH = "2.x";
    private static final String LATEST_RELEASE_URL = "https://api.github.com/repos/EssentialsX/Essentials/releases/latest";
    private static final String LATEST_RELEASE_PROXY_URL = "https://webapi.essentialsx.net/api/v1/github/essx-v2/releases/latest";
    private static final String DISTANCE_URL = "https://api.github.com/repos/EssentialsX/Essentials/compare/{0}...{1}";
    private static final String DISTANCE_PROXY_URL = "https://webapi.essentialsx.net/api/v1/github/essx-v2/compare/{0}/{1}";
    private final Essentials ess;
    private final String versionIdentifier;
    private final String versionBranch;
    private final boolean devBuild;
    private long lastFetchTime = 0L;
    private CompletableFuture<RemoteVersion> pendingDevFuture;
    private CompletableFuture<RemoteVersion> pendingReleaseFuture;
    private String latestRelease = null;
    private RemoteVersion cachedDev = null;
    private RemoteVersion cachedRelease = null;

    public UpdateChecker(Essentials ess) {
        List versionStr;
        String identifier = "INVALID";
        String branch = "INVALID";
        boolean dev = false;
        InputStream inputStream = UpdateChecker.class.getClassLoader().getResourceAsStream("release");
        if (inputStream != null && (versionStr = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList())).size() == 2) {
            if (((String)versionStr.get(0)).matches("\\d+\\.\\d+\\.\\d+-(?:dev|rc|beta|alpha)\\+\\d+-[0-9a-f]{7,40}")) {
                identifier = ((String)versionStr.get(0)).split("-")[2];
                dev = true;
            } else {
                identifier = (String)versionStr.get(0);
            }
            branch = (String)versionStr.get(1);
        }
        this.ess = ess;
        this.versionIdentifier = identifier;
        this.versionBranch = branch;
        this.devBuild = dev;
    }

    public boolean isDevBuild() {
        return this.devBuild;
    }

    public CompletableFuture<RemoteVersion> fetchLatestDev() {
        if (this.cachedDev == null || System.currentTimeMillis() - this.lastFetchTime > 1800000L) {
            if (this.pendingDevFuture != null) {
                return this.pendingDevFuture;
            }
            this.pendingDevFuture = new CompletableFuture();
            this.ess.runTaskAsynchronously(() -> {
                this.cachedDev = this.fetchDistance(BRANCH, this.getVersionIdentifier());
                this.pendingDevFuture.complete(this.cachedDev);
                this.pendingDevFuture = null;
                this.lastFetchTime = System.currentTimeMillis();
            });
            return this.pendingDevFuture;
        }
        return CompletableFuture.completedFuture(this.cachedDev);
    }

    public CompletableFuture<RemoteVersion> fetchLatestRelease() {
        if (this.cachedRelease == null || System.currentTimeMillis() - this.lastFetchTime > 1800000L) {
            if (this.pendingReleaseFuture != null) {
                return this.pendingReleaseFuture;
            }
            this.pendingReleaseFuture = new CompletableFuture();
            this.ess.runTaskAsynchronously(() -> {
                block11: {
                    try {
                        HttpURLConnection connection = this.tryRequestWithFallback(LATEST_RELEASE_URL, LATEST_RELEASE_PROXY_URL);
                        if (connection.getResponseCode() == 404) {
                            this.cachedRelease = new RemoteVersion(BranchStatus.UNKNOWN);
                            this.pendingReleaseFuture.complete(this.cachedRelease);
                            break block11;
                        }
                        if (connection.getResponseCode() == 500 || connection.getResponseCode() == 403) {
                            this.pendingReleaseFuture.complete(new RemoteVersion(BranchStatus.ERROR));
                            break block11;
                        }
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                            this.latestRelease = ((JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class)).get("tag_name").getAsString();
                            this.cachedRelease = this.fetchDistance(this.latestRelease, this.getVersionIdentifier());
                            this.pendingReleaseFuture.complete(this.cachedRelease);
                        }
                        catch (JsonSyntaxException | NumberFormatException e) {
                            e.printStackTrace();
                            this.pendingReleaseFuture.complete(new RemoteVersion(BranchStatus.ERROR));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.pendingReleaseFuture.complete(new RemoteVersion(BranchStatus.ERROR));
                    }
                }
                this.pendingReleaseFuture = null;
                this.lastFetchTime = System.currentTimeMillis();
            });
            return this.pendingReleaseFuture;
        }
        return CompletableFuture.completedFuture(this.cachedRelease);
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public String getVersionBranch() {
        return this.versionBranch;
    }

    public String getBuildInfo() {
        return "id:'" + this.getVersionIdentifier() + "' branch:'" + this.getVersionBranch() + "' isDev:" + this.isDevBuild();
    }

    public String getLatestRelease() {
        return this.latestRelease;
    }

    private HttpURLConnection tryRequestWithFallback(String githubUrl, String fallbackUrl) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(githubUrl).openConnection();
        try {
            connection.connect();
            if (connection.getResponseCode() != 500 && connection.getResponseCode() != 403) {
                return connection;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        connection = (HttpURLConnection)new URL(fallbackUrl).openConnection();
        connection.connect();
        return connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemoteVersion tryProcessDistance(HttpURLConnection connection) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            switch (obj.get("status").getAsString()) {
                case "identical": {
                    RemoteVersion remoteVersion = new RemoteVersion(BranchStatus.IDENTICAL, 0);
                    return remoteVersion;
                }
                case "ahead": {
                    RemoteVersion remoteVersion = new RemoteVersion(BranchStatus.AHEAD, 0);
                    return remoteVersion;
                }
                case "behind": {
                    RemoteVersion remoteVersion = new RemoteVersion(BranchStatus.BEHIND, obj.get("behind_by").getAsInt());
                    return remoteVersion;
                }
                case "diverged": {
                    RemoteVersion remoteVersion = new RemoteVersion(BranchStatus.DIVERGED, obj.get("behind_by").getAsInt());
                    return remoteVersion;
                }
            }
            RemoteVersion remoteVersion = new RemoteVersion(BranchStatus.UNKNOWN);
            return remoteVersion;
        }
        catch (JsonSyntaxException | NumberFormatException e) {
            e.printStackTrace();
            return new RemoteVersion(BranchStatus.ERROR);
        }
    }

    private RemoteVersion fetchDistance(String head, String hash) {
        try {
            HttpURLConnection connection = this.tryRequestWithFallback(MessageFormat.format(DISTANCE_URL, head, hash), MessageFormat.format(DISTANCE_PROXY_URL, head, hash));
            if (connection.getResponseCode() == 404) {
                return new RemoteVersion(BranchStatus.UNKNOWN);
            }
            if (connection.getResponseCode() == 500 || connection.getResponseCode() == 403) {
                return new RemoteVersion(BranchStatus.ERROR);
            }
            return this.tryProcessDistance(connection);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new RemoteVersion(BranchStatus.ERROR);
        }
    }

    public Component[] getVersionMessages(boolean sendLatestMessage, boolean verboseErrors, CommandSource source) {
        if (!this.ess.getSettings().isUpdateCheckEnabled()) {
            return new Component[]{source.tlComponent("versionCheckDisabled", new Object[0])};
        }
        if (this.isDevBuild()) {
            RemoteVersion latestDev = this.fetchLatestDev().join();
            switch (latestDev.getBranchStatus().ordinal()) {
                case 0: {
                    Component[] componentArray;
                    if (sendLatestMessage) {
                        Component[] componentArray2 = new Component[1];
                        componentArray = componentArray2;
                        componentArray2[0] = source.tlComponent("versionDevLatest", new Object[0]);
                    } else {
                        componentArray = new Component[]{};
                    }
                    return componentArray;
                }
                case 2: {
                    return new Component[]{source.tlComponent("versionDevBehind", latestDev.getDistance()), source.tlComponent("versionReleaseNewLink", "https://essentialsx.net/downloads.html")};
                }
                case 1: 
                case 3: {
                    return new Component[]{source.tlComponent(latestDev.getDistance() == 0 ? "versionDevDivergedLatest" : "versionDevDiverged", latestDev.getDistance()), source.tlComponent("versionDevDivergedBranch", this.getVersionBranch())};
                }
                case 5: {
                    Component[] componentArray;
                    if (verboseErrors) {
                        Component[] componentArray3 = new Component[1];
                        componentArray = componentArray3;
                        componentArray3[0] = source.tlComponent("versionCustom", this.getBuildInfo());
                    } else {
                        componentArray = new Component[]{};
                    }
                    return componentArray;
                }
                case 4: {
                    return new Component[]{source.tlComponent(verboseErrors ? "versionError" : "versionErrorPlayer", this.getBuildInfo())};
                }
            }
            return new Component[0];
        }
        RemoteVersion latestRelease = this.fetchLatestRelease().join();
        switch (latestRelease.getBranchStatus().ordinal()) {
            case 0: {
                Component[] componentArray;
                if (sendLatestMessage) {
                    Component[] componentArray4 = new Component[1];
                    componentArray = componentArray4;
                    componentArray4[0] = source.tlComponent("versionReleaseLatest", new Object[0]);
                } else {
                    componentArray = new Component[]{};
                }
                return componentArray;
            }
            case 2: {
                return new Component[]{source.tlComponent("versionReleaseNew", this.getLatestRelease()), source.tlComponent("versionReleaseNewLink", "https://essentialsx.net/downloads.html?branch=stable")};
            }
            case 1: 
            case 3: 
            case 5: {
                Component[] componentArray;
                if (verboseErrors) {
                    Component[] componentArray5 = new Component[1];
                    componentArray = componentArray5;
                    componentArray5[0] = source.tlComponent("versionCustom", this.getBuildInfo());
                } else {
                    componentArray = new Component[]{};
                }
                return componentArray;
            }
            case 4: {
                return new Component[]{source.tlComponent(verboseErrors ? "versionError" : "versionErrorPlayer", this.getBuildInfo())};
            }
        }
        return new Component[0];
    }

    private static class RemoteVersion {
        private final BranchStatus branchStatus;
        private final int distance;

        RemoteVersion(BranchStatus branchStatus) {
            this(branchStatus, 0);
        }

        RemoteVersion(BranchStatus branchStatus, int distance) {
            this.branchStatus = branchStatus;
            this.distance = distance;
        }

        public BranchStatus getBranchStatus() {
            return this.branchStatus;
        }

        public int getDistance() {
            return this.distance;
        }
    }

    private static enum BranchStatus {
        IDENTICAL,
        AHEAD,
        BEHIND,
        DIVERGED,
        ERROR,
        UNKNOWN;

    }
}

