/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.Kit;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.signs.SignException;
import java.util.Locale;
import net.ess3.api.IEssentials;

public class SignKit
extends EssentialsSign {
    public SignKit() {
        super("Kit");
    }

    @Override
    protected boolean onSignCreate(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException {
        this.validateTrade(sign, 3, ess);
        String kitName = sign.getLine(1).toLowerCase(Locale.ENGLISH).trim();
        if (kitName.isEmpty()) {
            sign.setLine(1, "\u00a7dKit name!");
            return false;
        }
        try {
            ess.getKits().getKit(kitName);
        }
        catch (Exception ex) {
            throw new SignException(ex, "errorWithMessage", ex.getMessage());
        }
        String group = sign.getLine(2);
        if ("Everyone".equalsIgnoreCase(group) || "Everybody".equalsIgnoreCase(group)) {
            sign.setLine(2, "\u00a72Everyone");
        }
        return true;
    }

    @Override
    protected boolean onSignInteract(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException, ChargeException {
        String kitName = sign.getLine(1).toLowerCase(Locale.ENGLISH).trim();
        String group = sign.getLine(2).trim();
        if (!group.isEmpty() && ("\u00a72Everyone".equals(group) || player.inGroup(group)) || group.isEmpty() && player.isAuthorized("essentials.kits." + kitName)) {
            Trade charge = this.getTrade(sign, 3, ess);
            charge.isAffordableFor(player);
            try {
                Kit kit = new Kit(kitName, ess);
                kit.checkDelay(player);
                kit.setTime(player);
                kit.expandItems(player);
                charge.charge(player);
                Trade.log("Sign", "Kit", "Interact", username, null, username, charge, sign.getBlock().getLocation(), player.getMoney(), ess);
            }
            catch (NoChargeException ex) {
                return false;
            }
            catch (Exception ex) {
                throw new SignException(ex, "errorWithMessage", ex.getMessage());
            }
            return true;
        }
        if (group.isEmpty()) {
            throw new SignException("noKitPermission", "essentials.kits." + kitName);
        }
        throw new SignException("noKitGroup", group);
    }
}

