/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.signs.SignException;
import net.ess3.api.IEssentials;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SignFree
extends EssentialsSign {
    public SignFree() {
        super("Free");
    }

    @Override
    protected boolean onSignCreate(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException {
        try {
            ItemStack item = this.getItemStack(sign.getLine(1), 1, ess);
            item = this.getItemMeta(item, sign.getLine(2), ess);
            item = this.getItemMeta(item, sign.getLine(3), ess);
        }
        catch (SignException ex) {
            sign.setLine(1, "\u00a7c<item>");
            throw new SignException(ex, "errorWithMessage", ex.getMessage());
        }
        return true;
    }

    @Override
    protected boolean onSignInteract(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException {
        ItemStack itemStack = this.getItemStack(sign.getLine(1), 1, ess);
        itemStack = this.getItemMeta(player.getSource(), itemStack, sign.getLine(2), ess);
        ItemStack item = this.getItemMeta(player.getSource(), itemStack, sign.getLine(3), ess);
        if (item.getType() == Material.AIR) {
            throw new SignException("cantSpawnItem", "Air");
        }
        item.setAmount(item.getType().getMaxStackSize());
        ItemMeta meta = item.getItemMeta();
        String displayName = meta.hasDisplayName() ? meta.getDisplayName() : item.getType().toString();
        Inventory invent = ess.getServer().createInventory((InventoryHolder)player.getBase(), 36, displayName);
        for (int i = 0; i < 36; ++i) {
            invent.addItem(new ItemStack[]{item});
        }
        player.getBase().openInventory(invent);
        Trade.log("Sign", "Free", "Interact", username, null, username, new Trade(item, ess), sign.getBlock().getLocation(), player.getMoney(), ess);
        return true;
    }
}

