/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.libs.kyori.adventure.text.minimessage.tag.standard;

import com.earth2me.essentials.libs.kyori.adventure.text.Component;
import com.earth2me.essentials.libs.kyori.adventure.text.TranslatableComponent;
import com.earth2me.essentials.libs.kyori.adventure.text.TranslationArgument;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.Context;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.ParsingException;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.tag.Tag;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.earth2me.essentials.libs.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

final class TranslatableTag {
    private static final String TR = "tr";
    private static final String TRANSLATE = "translate";
    private static final String LANG = "lang";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(StandardTags.names("lang", "translate", "tr"), TranslatableTag::create, TranslatableTag::claim);

    private TranslatableTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        List with;
        String key = args.popOr("A translation key is required").value();
        if (args.hasNext()) {
            with = new ArrayList();
            while (args.hasNext()) {
                with.add(ctx.deserialize(args.pop().value()));
            }
        } else {
            with = Collections.emptyList();
        }
        return Tag.inserting(Component.translatable(key, with));
    }

    @Nullable
    static Emitable claim(Component input) {
        if (!(input instanceof TranslatableComponent) || ((TranslatableComponent)input).fallback() != null) {
            return null;
        }
        TranslatableComponent tr = (TranslatableComponent)input;
        return emit -> {
            emit.tag(LANG);
            emit.argument(tr.key());
            for (TranslationArgument with : tr.arguments()) {
                emit.argument(with.asComponent());
            }
        };
    }
}

