/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.libs.configurate.serialize;

import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.Nullable;
import com.earth2me.essentials.libs.configurate.serialize.ScalarSerializer;
import com.earth2me.essentials.libs.configurate.serialize.SerializationException;
import com.earth2me.essentials.libs.configurate.util.EnumLookup;
import com.earth2me.essentials.libs.geantyref.GenericTypeReflector;
import com.earth2me.essentials.libs.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.function.Predicate;

final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    @Override
    public Enum<?> deserialize(Type type, Object obj) throws SerializationException {
        String enumConstant = obj.toString();
        @Nullable Enum ret = EnumLookup.lookupEnum(GenericTypeReflector.erase(type).asSubclass(Enum.class), enumConstant);
        if (ret == null) {
            throw new SerializationException(type, "Invalid enum constant provided, expected a value of enum, got " + enumConstant);
        }
        return ret;
    }

    @Override
    public Object serialize(Enum<?> item, Predicate<Class<?>> typeSupported) {
        return item.name();
    }
}

