/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ess3.api.TranslatableException;
import org.bukkit.Server;
import org.bukkit.World;

public class Commandweather
extends EssentialsCommand {
    public Commandweather() {
        super("weather");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        boolean isStorm;
        if (args.length == 0) {
            if (commandLabel.endsWith("sun")) {
                isStorm = false;
            } else {
                if (!commandLabel.endsWith("storm") && !commandLabel.endsWith("rain")) throw new NotEnoughArgumentsException();
                isStorm = true;
            }
        } else {
            isStorm = args[0].equalsIgnoreCase("storm");
        }
        World world = user.getWorld();
        if (args.length > 1) {
            world.setStorm(isStorm);
            world.setWeatherDuration(Integer.parseInt(args[1]) * 20);
            user.sendTl(isStorm ? "weatherStormFor" : "weatherSunFor", world.getName(), args[1]);
            return;
        }
        world.setStorm(isStorm);
        user.sendTl(isStorm ? "weatherStorm" : "weatherSun", world.getName());
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new Exception("When running from console, usage is: /" + commandLabel + " <world> <storm/sun> [duration]");
        }
        boolean isStorm = args[1].equalsIgnoreCase("storm");
        World world = server.getWorld(args[0]);
        if (world == null) {
            throw new TranslatableException("weatherInvalidWorld", args[0]);
        }
        if (args.length > 2) {
            world.setStorm(isStorm);
            world.setWeatherDuration(Integer.parseInt(args[2]) * 20);
            sender.sendTl(isStorm ? "weatherStormFor" : "weatherSunFor", world.getName(), args[2]);
            return;
        }
        world.setStorm(isStorm);
        sender.sendTl(isStorm ? "weatherStorm" : "weatherSun", world.getName());
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return Lists.newArrayList((Object[])new String[]{"storm", "sun"});
        }
        if (args.length == 2) {
            return COMMON_DURATIONS;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList worlds = Lists.newArrayList();
            for (World world : server.getWorlds()) {
                worlds.add(world.getName());
            }
            return worlds;
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"storm", "sun"});
        }
        if (args.length == 3) {
            return COMMON_DURATIONS;
        }
        return Collections.emptyList();
    }
}

