/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.AsyncTeleport;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.ess3.api.TranslatableException;
import net.ess3.api.events.TPARequestEvent;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtpa
extends EssentialsCommand {
    public Commandtpa() {
        super("tpa");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User player = this.getPlayer(server, user, args, 0);
        if (user.getName().equalsIgnoreCase(player.getName())) {
            throw new NotEnoughArgumentsException();
        }
        if (!player.isAuthorized("essentials.tpaccept")) {
            throw new TranslatableException("teleportNoAcceptPermission", player.getDisplayName());
        }
        if (!player.isTeleportEnabled()) {
            throw new TranslatableException("teleportDisabled", player.getDisplayName());
        }
        if (user.getWorld() != player.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + player.getWorld().getName())) {
            throw new TranslatableException("noPerm", "essentials.worlds." + player.getWorld().getName());
        }
        if (player.hasOutstandingTpaRequest(user.getName(), false)) {
            throw new TranslatableException("requestSentAlready", player.getDisplayName());
        }
        if (player.isAutoTeleportEnabled() && !player.isIgnoredPlayer(user)) {
            Trade charge = new Trade(this.getName(), this.ess);
            AsyncTeleport teleport = user.getAsyncTeleport();
            teleport.setTpType(AsyncTeleport.TeleportType.TPA);
            CompletableFuture<Boolean> future = this.getNewExceptionFuture(user.getSource(), commandLabel);
            teleport.teleport(player.getBase(), charge, PlayerTeleportEvent.TeleportCause.COMMAND, future);
            future.thenAccept(success -> {
                if (success.booleanValue()) {
                    player.sendTl("requestAcceptedAuto", user.getDisplayName());
                    user.sendTl("requestAcceptedFromAuto", player.getDisplayName());
                }
            });
            throw new NoChargeException();
        }
        if (!player.isIgnoredPlayer(user)) {
            TPARequestEvent tpaEvent = new TPARequestEvent(user.getSource(), player, false);
            this.ess.getServer().getPluginManager().callEvent((Event)tpaEvent);
            if (tpaEvent.isCancelled()) {
                throw new TranslatableException("teleportRequestCancelled", player.getDisplayName());
            }
            player.requestTeleport(user, false);
            player.sendTl("teleportRequest", user.getDisplayName());
            player.sendTl("typeTpaccept", new Object[0]);
            player.sendTl("typeTpdeny", new Object[0]);
            if (this.ess.getSettings().getTpaAcceptCancellation() != 0L) {
                player.sendTl("teleportRequestTimeoutInfo", this.ess.getSettings().getTpaAcceptCancellation());
            }
        }
        user.sendTl("requestSent", player.getDisplayName());
        if (user.isAuthorized("essentials.tpacancel")) {
            user.sendTl("typeTpacancel", new Object[0]);
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }
}

