/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.LocationUtil;
import com.earth2me.essentials.utils.NumberUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.ess3.api.IUser;
import net.ess3.api.TranslatableException;
import net.essentialsx.api.v2.events.HomeModifyEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandsethome
extends EssentialsCommand {
    public Commandsethome() {
        super("sethome");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        User usersHome = user;
        String name = "home";
        if (args.length > 0) {
            String[] nameParts = args[0].split(":");
            if (nameParts[0].length() != args[0].length()) {
                args = nameParts;
            }
            if (args.length < 2) {
                name = args[0].toLowerCase(Locale.ENGLISH);
            } else {
                name = args[1].toLowerCase(Locale.ENGLISH);
                if (user.isAuthorized("essentials.sethome.others") && (usersHome = this.getPlayer(server, args[0], true, true)) == null) {
                    throw new PlayerNotFoundException();
                }
            }
        }
        if (this.checkHomeLimit(user, usersHome, name)) {
            name = "home";
        }
        if ("bed".equals(name) || NumberUtil.isInt(name)) {
            throw new TranslatableException("invalidHomeName", new Object[0]);
        }
        Location location = user.getLocation();
        if (!(this.ess.getSettings().isTeleportSafetyEnabled() && this.ess.getSettings().isForceDisableTeleportSafety() || !LocationUtil.isBlockUnsafeForUser(this.ess, usersHome, location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ()))) {
            throw new TranslatableException("unsafeTeleportDestination", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }
        if (this.ess.getSettings().isConfirmHomeOverwrite() && usersHome.hasHome(name) && (!name.equals(usersHome.getLastHomeConfirmation()) || name.equals(usersHome.getLastHomeConfirmation()) && System.currentTimeMillis() - usersHome.getLastHomeConfirmationTimestamp() > TimeUnit.MINUTES.toMillis(2L))) {
            usersHome.setLastHomeConfirmation(name);
            usersHome.setLastHomeConfirmationTimestamp();
            user.sendTl("homeConfirmation", name);
            return;
        }
        Location prevHomeLoc = usersHome.getHome(name);
        HomeModifyEvent event = prevHomeLoc == null ? new HomeModifyEvent((IUser)user, (IUser)usersHome, name, location, true) : new HomeModifyEvent((IUser)user, (IUser)usersHome, name, prevHomeLoc, location);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().info("HomeModifyEvent canceled for /sethome execution by " + user.getDisplayName());
            }
            return;
        }
        usersHome.setHome(name, location);
        user.sendTl("homeSet", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), name);
        usersHome.setLastHomeConfirmation(null);
    }

    private boolean checkHomeLimit(User user, User usersHome, String name) throws Exception {
        if (!user.isAuthorized("essentials.sethome.multiple.unlimited")) {
            int limit = this.ess.getSettings().getHomeLimit(user);
            if (usersHome.getHomes().size() >= limit) {
                if (usersHome.getHomes().contains(name)) {
                    return false;
                }
                throw new TranslatableException("maxHomes", this.ess.getSettings().getHomeLimit(user));
            }
            return limit == 1;
        }
        return false;
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        return Collections.emptyList();
    }
}

