/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.ess3.api.TranslatableException;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commandpowertool
extends EssentialsCommand {
    public Commandpowertool() {
        super("powertool");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        String command = Commandpowertool.getFinalArg(args, 0);
        ItemStack itemStack = Inventories.getItemInHand(user.getBase());
        this.powertool(user.getSource(), user, itemStack, command);
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 3) {
            throw new Exception("When running from console, usage is: /" + commandLabel + " <player> <itemid> <command>");
        }
        User user = this.getPlayer(server, args, 0, true, true);
        ItemStack itemStack = this.ess.getItemDb().get(args[1]);
        String command = Commandpowertool.getFinalArg(args, 2);
        this.powertool(sender, user, itemStack, command);
    }

    protected void powertool(CommandSource sender, User user, ItemStack itemStack, String command) throws Exception {
        ArrayList powertools;
        if (command != null && command.equalsIgnoreCase("d:")) {
            user.clearAllPowertools();
            sender.sendTl("powerToolClearAll", new Object[0]);
            return;
        }
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            throw new TranslatableException("powerToolAir", new Object[0]);
        }
        String itemName = itemStack.getType().toString().toLowerCase(Locale.ENGLISH).replaceAll("_", " ");
        List<Object> list = powertools = user.getPowertool(itemStack) != null ? user.getPowertool(itemStack) : Lists.newArrayList();
        if (command != null && !command.isEmpty()) {
            if (command.equalsIgnoreCase("l:")) {
                if (powertools.isEmpty()) {
                    throw new TranslatableException("powerToolListEmpty", itemName);
                }
                sender.sendTl("powerToolList", StringUtil.joinList(powertools), itemName);
                throw new NoChargeException();
            }
            if (command.startsWith("r:")) {
                if (!powertools.contains(command = command.substring(2))) {
                    throw new TranslatableException("powerToolNoSuchCommandAssigned", command, itemName);
                }
                powertools.remove(command);
                sender.sendTl("powerToolRemove", command, itemName);
            } else {
                if (command.startsWith("a:")) {
                    if (sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.powertool.append")) {
                        throw new TranslatableException("noPerm", "essentials.powertool.append");
                    }
                    if (powertools.contains(command = command.substring(2))) {
                        throw new TranslatableException("powerToolAlreadySet", command, itemName);
                    }
                } else if (!powertools.isEmpty()) {
                    powertools.clear();
                }
                powertools.add(command);
                sender.sendTl("powerToolAttach", StringUtil.joinList(powertools), itemName);
            }
        } else {
            powertools.clear();
            sender.sendTl("powerToolRemoveAll", itemName);
        }
        if (!user.arePowerToolsEnabled()) {
            user.setPowerToolsEnabled(true);
            user.sendTl("powerToolsEnabled", new Object[0]);
        }
        user.setPowertool(itemStack, powertools);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"d:", "c:", "l:"});
            if (user.isAuthorized("essentials.powertool.append")) {
                for (String command : this.getCommands(server)) {
                    options.add("a:" + command);
                }
            }
            try {
                ItemStack itemStack = Inventories.getItemInHand(user.getBase());
                List<String> powertools = user.getPowertool(itemStack);
                for (String tool : powertools) {
                    options.add("r:" + tool);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return options;
        }
        if (args[0].startsWith("a:")) {
            return this.tabCompleteCommand(user.getSource(), server, args[0].substring(2), args, 1);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 2) {
            return this.getItems();
        }
        if (args.length == 3) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"d:", "c:", "l:"});
            for (String command : this.getCommands(server)) {
                options.add("a:" + command);
            }
            try {
                User user = this.getPlayer(server, args, 0, true, true);
                ItemStack itemStack = this.ess.getItemDb().get(args[1]);
                List<String> powertools = user.getPowertool(itemStack);
                for (String tool : powertools) {
                    options.add("r:" + tool);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return options;
        }
        if (args[2].startsWith("a:")) {
            return this.tabCompleteCommand(sender, server, args[2].substring(2), args, 3);
        }
        return Collections.emptyList();
    }
}

