/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Server;

public class Commandignore
extends EssentialsCommand {
    public Commandignore() {
        super("ignore");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        User player;
        if (args.length == 0) {
            StringBuilder sb = new StringBuilder();
            for (UUID uuid : user._getIgnoredPlayers()) {
                User curUser = this.ess.getUser(uuid);
                if (curUser == null || curUser.getName() == null || curUser.getName().trim().isEmpty()) continue;
                sb.append(curUser.getName()).append(" ");
            }
            String ignoredList = sb.toString().trim();
            user.sendTl(ignoredList.length() > 0 ? "ignoredList" : "noIgnored", ignoredList);
            return;
        }
        try {
            player = this.getPlayer(server, args, 0, true, true);
        }
        catch (PlayerNotFoundException ex) {
            player = this.ess.getOfflineUser(args[0]);
        }
        if (player == null) {
            throw new PlayerNotFoundException();
        }
        if (player.isIgnoreExempt()) {
            user.sendTl("ignoreExempt", new Object[0]);
        } else if (user.isIgnoredPlayer(player)) {
            user.setIgnoredPlayer(player, false);
            user.sendTl("unignorePlayer", player.getName());
        } else if (user.getUUID().equals(player.getUUID())) {
            user.sendTl("ignoreYourself", new Object[0]);
        } else {
            user.setIgnoredPlayer(player, true);
            user.sendTl("ignorePlayer", player.getName());
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }
}

