/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ess3.api.TranslatableException;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Commandbook
extends EssentialsCommand {
    private static final Material WRITABLE_BOOK = EnumUtil.getMaterial("WRITABLE_BOOK", "BOOK_AND_QUILL");

    public Commandbook() {
        super("book");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        ItemStack item = Inventories.getItemInMainHand(user.getBase());
        String player = user.getName();
        if (item.getType() == Material.WRITTEN_BOOK) {
            BookMeta bmeta = (BookMeta)item.getItemMeta();
            if (args.length > 1 && args[0].equalsIgnoreCase("author")) {
                if (!user.isAuthorized("essentials.book.author") || !this.isAuthor(bmeta, player) && !user.isAuthorized("essentials.book.others")) throw new TranslatableException("denyChangeAuthor", new Object[0]);
                String newAuthor = FormatUtil.formatString(user, "essentials.book.author", Commandbook.getFinalArg(args, 1)).trim();
                bmeta.setAuthor(newAuthor);
                item.setItemMeta((ItemMeta)bmeta);
                user.sendTl("bookAuthorSet", newAuthor);
                return;
            } else if (args.length > 1 && args[0].equalsIgnoreCase("title")) {
                if (!user.isAuthorized("essentials.book.title") || !this.isAuthor(bmeta, player) && !user.isAuthorized("essentials.book.others")) throw new TranslatableException("denyChangeTitle", new Object[0]);
                String newTitle = FormatUtil.formatString(user, "essentials.book.title", Commandbook.getFinalArg(args, 1)).trim();
                bmeta.setTitle(newTitle);
                item.setItemMeta((ItemMeta)bmeta);
                user.sendTl("bookTitleSet", newTitle);
                return;
            } else {
                if (!this.isAuthor(bmeta, player) && !user.isAuthorized("essentials.book.others")) throw new TranslatableException("denyBookEdit", new Object[0]);
                ItemStack newItem = new ItemStack(WRITABLE_BOOK, item.getAmount());
                newItem.setItemMeta((ItemMeta)bmeta);
                Inventories.setItemInMainHand(user.getBase(), newItem);
                user.sendTl("editBookContents", new Object[0]);
            }
            return;
        } else {
            if (item.getType() != WRITABLE_BOOK) throw new TranslatableException("holdBook", new Object[0]);
            BookMeta bmeta = (BookMeta)item.getItemMeta();
            if (!user.isAuthorized("essentials.book.author")) {
                bmeta.setAuthor(player);
            }
            ItemStack newItem = new ItemStack(Material.WRITTEN_BOOK, item.getAmount());
            newItem.setItemMeta((ItemMeta)bmeta);
            Inventories.setItemInMainHand(user.getBase(), newItem);
            user.sendTl("bookLocked", new Object[0]);
        }
    }

    private boolean isAuthor(BookMeta bmeta, String player) {
        String author = bmeta.getAuthor();
        return author != null && author.equalsIgnoreCase(player);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"sign", "unsign"});
            if (user.isAuthorized("essentials.book.author")) {
                options.add("author");
            }
            if (user.isAuthorized("essentials.book.title")) {
                options.add("title");
            }
            return options;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("author") && user.isAuthorized("essentials.book.author")) {
            List<String> options = this.getPlayers(server, user);
            options.add("Herobrine");
            return options;
        }
        return Collections.emptyList();
    }
}

