/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.model.player;

import ce.ajneb97.model.player.EventData;
import java.util.ArrayList;

public class PlayerData {
    private String uuid;
    private String name;
    private boolean modified;
    private ArrayList<EventData> eventData;

    public PlayerData(String uuid, String name) {
        this.uuid = uuid;
        this.name = name;
        this.eventData = new ArrayList();
        this.modified = false;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<EventData> getEventData() {
        return this.eventData;
    }

    public void setEventData(ArrayList<EventData> eventData) {
        this.eventData = eventData;
    }

    public EventData getEventData(String eventName) {
        for (EventData e : this.eventData) {
            if (!e.getName().equals(eventName)) continue;
            return e;
        }
        return null;
    }

    public void resetAll() {
        this.eventData.clear();
    }

    public void resetCooldown(String eventName) {
        this.setCooldown(eventName, 0L);
    }

    public void setCooldown(String eventName, long currentMillis) {
        EventData e = this.getEventData(eventName);
        if (e == null) {
            e = new EventData(eventName, currentMillis, false);
            this.eventData.add(e);
        } else {
            e.setCooldown(currentMillis);
        }
    }

    public long getCooldown(String eventName) {
        EventData e = this.getEventData(eventName);
        if (e == null) {
            return 0L;
        }
        return e.getCooldown();
    }

    public void setOneTime(String eventName, boolean oneTime) {
        EventData e = this.getEventData(eventName);
        if (e == null) {
            e = new EventData(eventName, 0L, oneTime);
            this.eventData.add(e);
        } else {
            e.setOneTime(oneTime);
        }
    }

    public boolean isEventOneTime(String eventName) {
        EventData e = this.getEventData(eventName);
        if (e == null) {
            return false;
        }
        return e.isOneTime();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

