/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.configs;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.configs.PlayerConfig;
import ce.ajneb97.model.player.EventData;
import ce.ajneb97.model.player.PlayerData;
import ce.ajneb97.utils.OtherUtils;
import java.io.File;
import java.util.ArrayList;
import org.bukkit.configuration.file.FileConfiguration;

public class PlayerConfigsManager {
    private ArrayList<PlayerConfig> configPlayers;
    private ConditionalEvents plugin;

    public PlayerConfigsManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.configPlayers = new ArrayList();
    }

    public void configure() {
        this.createPlayersFolder();
        this.registerPlayers();
        this.loadPlayerData();
    }

    public void createPlayersFolder() {
        try {
            File folder = new File(this.plugin.getDataFolder() + File.separator + "players");
            if (!folder.exists()) {
                folder.mkdirs();
            }
        }
        catch (SecurityException e) {
            Object folder = null;
        }
    }

    public void savePlayers() {
        for (int i = 0; i < this.configPlayers.size(); ++i) {
            this.configPlayers.get(i).savePlayerConfig();
        }
    }

    public void registerPlayers() {
        String path = this.plugin.getDataFolder() + File.separator + "players";
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            String pathName;
            String ext;
            if (!listOfFiles[i].isFile() || !(ext = OtherUtils.getFileExtension(pathName = listOfFiles[i].getName())).equals("yml")) continue;
            PlayerConfig config = new PlayerConfig(pathName, this.plugin);
            config.registerPlayerConfig();
            this.configPlayers.add(config);
        }
    }

    public ArrayList<PlayerConfig> getConfigPlayers() {
        return this.configPlayers;
    }

    public boolean fileAlreadyRegistered(String pathName) {
        for (int i = 0; i < this.configPlayers.size(); ++i) {
            if (!this.configPlayers.get(i).getPath().equals(pathName)) continue;
            return true;
        }
        return false;
    }

    public PlayerConfig getPlayerConfig(String pathName) {
        for (int i = 0; i < this.configPlayers.size(); ++i) {
            if (!this.configPlayers.get(i).getPath().equals(pathName)) continue;
            return this.configPlayers.get(i);
        }
        return null;
    }

    public ArrayList<PlayerConfig> getPlayerConfigs() {
        return this.configPlayers;
    }

    public boolean registerPlayer(String pathName) {
        if (!this.fileAlreadyRegistered(pathName)) {
            PlayerConfig config = new PlayerConfig(pathName, this.plugin);
            config.registerPlayerConfig();
            this.configPlayers.add(config);
            return true;
        }
        return false;
    }

    public void removeConfigPlayer(String path) {
        for (int i = 0; i < this.configPlayers.size(); ++i) {
            if (!this.configPlayers.get(i).getPath().equals(path)) continue;
            this.configPlayers.remove(i);
        }
    }

    public void loadPlayerData() {
        ArrayList<PlayerData> playerData = new ArrayList<PlayerData>();
        for (PlayerConfig playerConfig : this.configPlayers) {
            FileConfiguration players = playerConfig.getConfig();
            String name = players.getString("name");
            String uuid = playerConfig.getPath().replace(".yml", "");
            PlayerData p = new PlayerData(uuid, name);
            ArrayList<EventData> eventData = new ArrayList<EventData>();
            if (players.contains("events")) {
                for (String key : players.getConfigurationSection("events").getKeys(false)) {
                    boolean oneTime = players.getBoolean("events." + key + ".one_time");
                    long cooldown = players.getLong("events." + key + ".cooldown");
                    EventData event = new EventData(key, cooldown, oneTime);
                    eventData.add(event);
                }
            }
            p.setEventData(eventData);
            playerData.add(p);
        }
        this.plugin.getPlayerManager().setPlayerData(playerData);
    }

    public void savePlayer(PlayerData player) {
        String playerName = player.getName();
        PlayerConfig playerConfig = this.getPlayerConfig(player.getUuid() + ".yml");
        if (playerConfig == null) {
            this.registerPlayer(player.getUuid() + ".yml");
            playerConfig = this.getPlayerConfig(player.getUuid() + ".yml");
        }
        FileConfiguration players = playerConfig.getConfig();
        players.set("name", (Object)playerName);
        players.set("events", null);
        for (EventData event : player.getEventData()) {
            String path = "events." + event.getName();
            players.set(path + ".one_time", (Object)event.isOneTime());
            players.set(path + ".cooldown", (Object)event.getCooldown());
        }
        playerConfig.savePlayerConfig();
    }

    public void savePlayerData() {
        for (PlayerData player : this.plugin.getPlayerManager().getPlayerData()) {
            if (player.isModified()) {
                this.savePlayer(player);
            }
            player.setModified(false);
        }
    }
}

