/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.v1_20_5to1_20_3;

import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.data.BackwardsMappingData;
import com.viaversion.viabackwards.api.rewriters.SoundRewriter;
import com.viaversion.viabackwards.api.rewriters.TranslatableRewriter;
import com.viaversion.viabackwards.protocol.v1_20_5to1_20_3.provider.TransferProvider;
import com.viaversion.viabackwards.protocol.v1_20_5to1_20_3.rewriter.BlockItemPacketRewriter1_20_5;
import com.viaversion.viabackwards.protocol.v1_20_5to1_20_3.rewriter.EntityPacketRewriter1_20_5;
import com.viaversion.viabackwards.protocol.v1_20_5to1_20_3.storage.CookieStorage;
import com.viaversion.viabackwards.protocol.v1_20_5to1_20_3.storage.RegistryDataStorage;
import com.viaversion.viabackwards.protocol.v1_20_5to1_20_3.storage.SecureChatStorage;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.minecraft.RegistryType;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_20_5;
import com.viaversion.viaversion.api.platform.providers.Provider;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.packet.provider.PacketTypesProvider;
import com.viaversion.viaversion.api.protocol.packet.provider.SimplePacketTypesProvider;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.data.entity.EntityTrackerBase;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ServerboundLoginPackets;
import com.viaversion.viaversion.protocols.v1_19_3to1_19_4.rewriter.CommandRewriter1_19_4;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.packet.ClientboundConfigurationPackets1_20_3;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.packet.ClientboundPacket1_20_3;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.packet.ClientboundPackets1_20_3;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.packet.ServerboundPacket1_20_3;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.packet.ServerboundPackets1_20_3;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.Protocol1_20_3To1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ClientboundConfigurationPackets1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ClientboundPacket1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ClientboundPackets1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ServerboundConfigurationPackets1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ServerboundPacket1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ServerboundPackets1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.storage.ArmorTrimStorage;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.storage.BannerPatternStorage;
import com.viaversion.viaversion.protocols.v1_20to1_20_2.packet.ServerboundConfigurationPackets1_20_2;
import com.viaversion.viaversion.rewriter.ComponentRewriter;
import com.viaversion.viaversion.rewriter.StatisticsRewriter;
import com.viaversion.viaversion.rewriter.TagRewriter;
import com.viaversion.viaversion.util.ProtocolUtil;

public final class Protocol1_20_5To1_20_3
extends BackwardsProtocol<ClientboundPacket1_20_5, ClientboundPacket1_20_3, ServerboundPacket1_20_5, ServerboundPacket1_20_3> {
    public static final BackwardsMappingData MAPPINGS = new BackwardsMappingData("1.20.5", "1.20.3", Protocol1_20_3To1_20_5.class);
    private final EntityPacketRewriter1_20_5 entityRewriter = new EntityPacketRewriter1_20_5(this);
    private final BlockItemPacketRewriter1_20_5 itemRewriter = new BlockItemPacketRewriter1_20_5(this);
    private final TranslatableRewriter<ClientboundPacket1_20_5> translatableRewriter = new TranslatableRewriter<ClientboundPacket1_20_5>(this, ComponentRewriter.ReadType.NBT);
    private final TagRewriter<ClientboundPacket1_20_5> tagRewriter = new TagRewriter((Protocol)this);

    public Protocol1_20_5To1_20_3() {
        super(ClientboundPacket1_20_5.class, ClientboundPacket1_20_3.class, ServerboundPacket1_20_5.class, ServerboundPacket1_20_3.class);
    }

    @Override
    protected void registerPackets() {
        super.registerPackets();
        this.tagRewriter.addEmptyTag(RegistryType.ITEM, "minecraft:axolotl_tempt_items");
        this.tagRewriter.registerGeneric((ClientboundPacketType)ClientboundPackets1_20_5.UPDATE_TAGS);
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_20_5.UPDATE_TAGS, wrapper -> {
            this.sendRegistryData(wrapper.user());
            this.tagRewriter.getGenericHandler().handle(wrapper);
        });
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_20_5.FINISH_CONFIGURATION, wrapper -> this.sendRegistryData(wrapper.user()));
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.START_CONFIGURATION, wrapper -> ((RegistryDataStorage)wrapper.user().get(RegistryDataStorage.class)).clear());
        SoundRewriter<ClientboundPacket1_20_5> soundRewriter = new SoundRewriter<ClientboundPacket1_20_5>(this);
        soundRewriter.registerSound1_19_3((ClientboundPacket1_20_5)ClientboundPackets1_20_5.SOUND);
        soundRewriter.registerSound1_19_3((ClientboundPacket1_20_5)ClientboundPackets1_20_5.SOUND_ENTITY);
        soundRewriter.registerStopSound((ClientboundPacket1_20_5)ClientboundPackets1_20_5.STOP_SOUND);
        new StatisticsRewriter((Protocol)this).register((ClientboundPacketType)ClientboundPackets1_20_5.AWARD_STATS);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_20_5.SET_ACTION_BAR_TEXT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_20_5.SET_TITLE_TEXT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_20_5.SET_SUBTITLE_TEXT);
        this.translatableRewriter.registerBossEvent((ClientboundPacketType)ClientboundPackets1_20_5.BOSS_EVENT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_20_5.DISCONNECT);
        this.translatableRewriter.registerTabList((ClientboundPacketType)ClientboundPackets1_20_5.TAB_LIST);
        this.translatableRewriter.registerPlayerCombatKill1_20((ClientboundPacketType)ClientboundPackets1_20_5.PLAYER_COMBAT_KILL);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_20_5.SYSTEM_CHAT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_20_5.DISGUISED_CHAT);
        this.translatableRewriter.registerPing();
        this.registerClientbound(State.LOGIN, (ClientboundPacketType)ClientboundLoginPackets.HELLO, wrapper -> {
            wrapper.passthrough(Types.STRING);
            wrapper.passthrough(Types.BYTE_ARRAY_PRIMITIVE);
            wrapper.passthrough(Types.BYTE_ARRAY_PRIMITIVE);
            wrapper.read((Type)Types.BOOLEAN);
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.SERVER_DATA, wrapper -> {
            wrapper.passthrough(Types.TAG);
            wrapper.passthrough(Types.OPTIONAL_BYTE_ARRAY_PRIMITIVE);
            wrapper.write((Type)Types.BOOLEAN, (Object)((SecureChatStorage)wrapper.user().get(SecureChatStorage.class)).enforcesSecureChat());
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_20_3.CHAT_COMMAND, (ServerboundPacketType)ServerboundPackets1_20_5.CHAT_COMMAND_SIGNED, wrapper -> {
            String command = (String)wrapper.passthrough(Types.STRING);
            wrapper.passthrough((Type)Types.LONG);
            wrapper.passthrough((Type)Types.LONG);
            int signatures = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            if (signatures == 0) {
                wrapper.cancel();
                PacketWrapper chatCommand = wrapper.create((PacketType)ServerboundPackets1_20_5.CHAT_COMMAND);
                chatCommand.write(Types.STRING, (Object)command);
                chatCommand.sendToServer(Protocol1_20_5To1_20_3.class);
            }
        });
        this.registerClientbound(State.LOGIN, ClientboundLoginPackets.COOKIE_REQUEST.getId(), -1, wrapper -> this.handleCookieRequest(wrapper, (ServerboundPacketType)ServerboundLoginPackets.COOKIE_RESPONSE));
        this.cancelClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_20_5.RESET_CHAT);
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_20_5.COOKIE_REQUEST, null, wrapper -> this.handleCookieRequest(wrapper, (ServerboundPacketType)ServerboundConfigurationPackets1_20_5.COOKIE_RESPONSE));
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_20_5.STORE_COOKIE, null, this::handleStoreCookie);
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_20_5.TRANSFER, null, this::handleTransfer);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.COOKIE_REQUEST, null, wrapper -> this.handleCookieRequest(wrapper, (ServerboundPacketType)ServerboundPackets1_20_5.COOKIE_RESPONSE));
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.STORE_COOKIE, null, this::handleStoreCookie);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.TRANSFER, null, this::handleTransfer);
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_20_5.SELECT_KNOWN_PACKS, null, wrapper -> {
            wrapper.cancel();
            PacketWrapper response = wrapper.create((PacketType)ServerboundConfigurationPackets1_20_5.SELECT_KNOWN_PACKS);
            response.write((Type)Types.VAR_INT, (Object)0);
            response.sendToServer(Protocol1_20_5To1_20_3.class);
        });
        new CommandRewriter1_19_4<ClientboundPacket1_20_5>((Protocol)this){

            public void handleArgument(PacketWrapper wrapper, String argumentType) {
                if (argumentType.equals("minecraft:loot_table") || argumentType.equals("minecraft:loot_predicate") || argumentType.equals("minecraft:loot_modifier")) {
                    wrapper.write((Type)Types.VAR_INT, (Object)0);
                } else {
                    super.handleArgument(wrapper, argumentType);
                }
            }
        }.registerDeclareCommands1_19((ClientboundPacketType)ClientboundPackets1_20_5.COMMANDS);
        this.registerClientbound(State.LOGIN, (ClientboundPacketType)ClientboundLoginPackets.GAME_PROFILE, wrapper -> {
            wrapper.passthrough(Types.UUID);
            wrapper.passthrough(Types.STRING);
            int properties = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            for (int i = 0; i < properties; ++i) {
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.OPTIONAL_STRING);
            }
            wrapper.read((Type)Types.BOOLEAN);
        });
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_20_5.PROJECTILE_POWER);
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_20_5.DEBUG_SAMPLE);
    }

    private void sendRegistryData(UserConnection connection) {
        RegistryDataStorage registryDataStorage = (RegistryDataStorage)connection.get(RegistryDataStorage.class);
        if (!registryDataStorage.sentRegistryData()) {
            PacketWrapper registryDataPacket = PacketWrapper.create((PacketType)ClientboundConfigurationPackets1_20_3.REGISTRY_DATA, (UserConnection)connection);
            registryDataPacket.write(Types.COMPOUND_TAG, (Object)registryDataStorage.registryData().copy());
            registryDataPacket.send(Protocol1_20_5To1_20_3.class);
            registryDataStorage.setSentRegistryData();
        }
    }

    private void handleStoreCookie(PacketWrapper wrapper) {
        wrapper.cancel();
        String resourceLocation = (String)wrapper.read(Types.STRING);
        byte[] data = (byte[])wrapper.read(Types.BYTE_ARRAY_PRIMITIVE);
        if (data.length > 5120) {
            throw new IllegalArgumentException("Cookie data too large");
        }
        ((CookieStorage)wrapper.user().get(CookieStorage.class)).cookies().put(resourceLocation, data);
    }

    private void handleCookieRequest(PacketWrapper wrapper, ServerboundPacketType responseType) {
        wrapper.cancel();
        String resourceLocation = (String)wrapper.read(Types.STRING);
        byte[] data = ((CookieStorage)wrapper.user().get(CookieStorage.class)).cookies().get(resourceLocation);
        PacketWrapper responsePacket = wrapper.create((PacketType)responseType);
        responsePacket.write(Types.STRING, (Object)resourceLocation);
        responsePacket.write(Types.OPTIONAL_BYTE_ARRAY_PRIMITIVE, (Object)data);
        responsePacket.sendToServer(Protocol1_20_5To1_20_3.class);
    }

    private void handleTransfer(PacketWrapper wrapper) {
        wrapper.cancel();
        String host = (String)wrapper.read(Types.STRING);
        int port = (Integer)wrapper.read((Type)Types.VAR_INT);
        ((TransferProvider)Via.getManager().getProviders().get(TransferProvider.class)).connectToServer(wrapper.user(), host, port);
    }

    public void init(UserConnection user) {
        this.addEntityTracker(user, (EntityTracker)new EntityTrackerBase(user, (EntityType)EntityTypes1_20_5.PLAYER));
        user.put((StorableObject)new SecureChatStorage());
        user.put((StorableObject)new CookieStorage());
        user.put((StorableObject)new RegistryDataStorage());
        user.put((StorableObject)new BannerPatternStorage());
        user.put((StorableObject)new ArmorTrimStorage());
    }

    public void register(ViaProviders providers) {
        providers.register(TransferProvider.class, (Provider)TransferProvider.NOOP);
    }

    @Override
    public BackwardsMappingData getMappingData() {
        return MAPPINGS;
    }

    public EntityPacketRewriter1_20_5 getEntityRewriter() {
        return this.entityRewriter;
    }

    public BlockItemPacketRewriter1_20_5 getItemRewriter() {
        return this.itemRewriter;
    }

    @Override
    public TranslatableRewriter<ClientboundPacket1_20_5> getComponentRewriter() {
        return this.translatableRewriter;
    }

    public TagRewriter<ClientboundPacket1_20_5> getTagRewriter() {
        return this.tagRewriter;
    }

    protected PacketTypesProvider<ClientboundPacket1_20_5, ClientboundPacket1_20_3, ServerboundPacket1_20_5, ServerboundPacket1_20_3> createPacketTypesProvider() {
        return new SimplePacketTypesProvider(ProtocolUtil.packetTypeMap((Class)this.unmappedClientboundPacketType, (Class[])new Class[]{ClientboundPackets1_20_5.class, ClientboundConfigurationPackets1_20_5.class}), ProtocolUtil.packetTypeMap((Class)this.mappedClientboundPacketType, (Class[])new Class[]{ClientboundPackets1_20_3.class, ClientboundConfigurationPackets1_20_3.class}), ProtocolUtil.packetTypeMap((Class)this.mappedServerboundPacketType, (Class[])new Class[]{ServerboundPackets1_20_5.class, ServerboundConfigurationPackets1_20_5.class}), ProtocolUtil.packetTypeMap((Class)this.unmappedServerboundPacketType, (Class[])new Class[]{ServerboundPackets1_20_3.class, ServerboundConfigurationPackets1_20_2.class}));
    }
}

