/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.v1_20_5to1_21.storage;

import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_20_5to1_21.Protocol1_20_5To1_21;
import com.viaversion.viaversion.protocols.v1_20_5to1_21.packet.ClientboundPackets1_21;
import java.util.List;
import java.util.stream.Stream;

public final class EfficiencyAttributeStorage
implements StorableObject {
    private static final EnchantAttributeModifier EFFICIENCY = new EnchantAttributeModifier("minecraft:enchantment.efficiency/mainhand", 19, 0.0, level -> level * level + 1);
    private static final EnchantAttributeModifier SOUL_SPEED = new EnchantAttributeModifier("minecraft:enchantment.soul_speed", 21, 0.1, level -> 0.04 + (double)(level - 1) * 0.01);
    private static final EnchantAttributeModifier SWIFT_SNEAK = new EnchantAttributeModifier("minecraft:enchantment.swift_sneak", 25, 0.3, level -> (double)level * 0.15);
    private static final EnchantAttributeModifier AQUA_AFFINITY = new EnchantAttributeModifier("minecraft:enchantment.aqua_affinity", 28, 0.2, level -> level * 4, 2);
    private static final EnchantAttributeModifier DEPTH_STRIDER = new EnchantAttributeModifier("minecraft:enchantment.depth_strider", 30, 0.0, level -> (double)level / 3.0);
    private static final ActiveEnchants DEFAULT = new ActiveEnchants(-1, new ActiveEnchant(EFFICIENCY, 0, 0), new ActiveEnchant(SOUL_SPEED, 0, 0), new ActiveEnchant(SWIFT_SNEAK, 0, 0), new ActiveEnchant(AQUA_AFFINITY, 0, 0), new ActiveEnchant(DEPTH_STRIDER, 0, 0));
    private final Object lock = new Object();
    private volatile boolean attributesSent = true;
    private volatile boolean loginSent;
    private ActiveEnchants activeEnchants = DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnchants(int entityId, UserConnection connection, int efficiency, int soulSpeed, int swiftSneak, int aquaAffinity, int depthStrider) {
        if (efficiency == this.activeEnchants.efficiency.level && soulSpeed == this.activeEnchants.soulSpeed.level && swiftSneak == this.activeEnchants.swiftSneak.level && aquaAffinity == this.activeEnchants.aquaAffinity.level && depthStrider == this.activeEnchants.depthStrider.level) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.activeEnchants = new ActiveEnchants(entityId, new ActiveEnchant(this.activeEnchants.efficiency, efficiency), new ActiveEnchant(this.activeEnchants.soulSpeed, soulSpeed), new ActiveEnchant(this.activeEnchants.swiftSneak, swiftSneak), new ActiveEnchant(this.activeEnchants.aquaAffinity, aquaAffinity), new ActiveEnchant(this.activeEnchants.depthStrider, depthStrider));
            this.attributesSent = false;
        }
        this.sendAttributesPacket(connection, false);
    }

    public ActiveEnchants activeEnchants() {
        return this.activeEnchants;
    }

    public void onLoginSent(UserConnection connection) {
        this.loginSent = true;
        this.sendAttributesPacket(connection, false);
    }

    public void onRespawn(UserConnection connection) {
        this.sendAttributesPacket(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAttributesPacket(UserConnection connection, boolean forceSendAll) {
        ActiveEnchants enchants;
        Object object = this.lock;
        synchronized (object) {
            if (!(forceSendAll || this.loginSent && !this.attributesSent)) {
                return;
            }
            enchants = this.activeEnchants;
            this.attributesSent = true;
        }
        PacketWrapper attributesPacket = PacketWrapper.create(ClientboundPackets1_21.UPDATE_ATTRIBUTES, connection);
        attributesPacket.write(Types.VAR_INT, enchants.entityId());
        List<ActiveEnchant> list = Stream.of(enchants.efficiency(), enchants.soulSpeed(), enchants.swiftSneak(), enchants.aquaAffinity(), enchants.depthStrider()).filter(enchant -> forceSendAll || enchant.previousLevel != enchant.level).toList();
        attributesPacket.write(Types.VAR_INT, list.size());
        for (ActiveEnchant enchant2 : list) {
            EnchantAttributeModifier modifier = enchant2.modifier;
            attributesPacket.write(Types.VAR_INT, modifier.attributeId);
            attributesPacket.write(Types.DOUBLE, modifier.baseValue);
            if (enchant2.level > 0) {
                attributesPacket.write(Types.VAR_INT, 1);
                attributesPacket.write(Types.STRING, modifier.key);
                attributesPacket.write(Types.DOUBLE, enchant2.modifier.modifierFunction.get(enchant2.level));
                attributesPacket.write(Types.BYTE, modifier.operation);
                continue;
            }
            attributesPacket.write(Types.VAR_INT, 0);
        }
        attributesPacket.scheduleSend(Protocol1_20_5To1_21.class);
    }

    public record ActiveEnchants(int entityId, ActiveEnchant efficiency, ActiveEnchant soulSpeed, ActiveEnchant swiftSneak, ActiveEnchant aquaAffinity, ActiveEnchant depthStrider) {
    }

    public record ActiveEnchant(EnchantAttributeModifier modifier, int previousLevel, int level) {
        public ActiveEnchant(ActiveEnchant from, int level) {
            this(from.modifier, from.level, level);
        }
    }

    public record EnchantAttributeModifier(String key, int attributeId, double baseValue, LevelToModifier modifierFunction, byte operation) {
        private EnchantAttributeModifier(String key, int attributeId, double baseValue, LevelToModifier modifierFunction) {
            this(key, attributeId, baseValue, modifierFunction, 0);
        }
    }

    @FunctionalInterface
    private static interface LevelToModifier {
        public double get(int var1);
    }
}

