/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.minecraft.item.data.ToolRule;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import io.netty.buffer.ByteBuf;

public record ToolProperties(ToolRule[] rules, float defaultMiningSpeed, int damagePerBlock) {
    public static final Type<ToolProperties> TYPE = new Type<ToolProperties>(ToolProperties.class){

        @Override
        public ToolProperties read(ByteBuf buffer) {
            ToolRule[] rules = (ToolRule[])ToolRule.ARRAY_TYPE.read(buffer);
            float defaultMiningSpeed = buffer.readFloat();
            int damagePerBlock = Types.VAR_INT.readPrimitive(buffer);
            return new ToolProperties(rules, defaultMiningSpeed, damagePerBlock);
        }

        @Override
        public void write(ByteBuf buffer, ToolProperties value) {
            ToolRule.ARRAY_TYPE.write(buffer, value.rules());
            buffer.writeFloat(value.defaultMiningSpeed());
            Types.VAR_INT.writePrimitive(buffer, value.damagePerBlock());
        }
    };

    public ToolProperties rewrite(Int2IntFunction blockIdRewriter) {
        ToolRule[] rules = new ToolRule[this.rules.length];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = this.rules[i].rewrite(blockIdRewriter);
        }
        return new ToolProperties(rules, this.defaultMiningSpeed, this.damagePerBlock);
    }
}

