/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.data;

import com.google.common.base.Preconditions;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.FullMappings;
import com.viaversion.viaversion.api.minecraft.data.StructuredData;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataKey;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.viaversion.viaversion.libs.fastutil.objects.Reference2ObjectOpenHashMap;
import com.viaversion.viaversion.util.Unit;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StructuredDataContainer {
    private final Map<StructuredDataKey<?>, StructuredData<?>> data;
    private FullMappings lookup;
    private boolean mappedNames;

    public StructuredDataContainer(Map<StructuredDataKey<?>, StructuredData<?>> data) {
        this.data = data;
    }

    public StructuredDataContainer(StructuredData<?>[] dataArray) {
        this(new Reference2ObjectOpenHashMap(dataArray.length));
        for (StructuredData<?> data : dataArray) {
            this.data.put(data.key(), data);
        }
    }

    public StructuredDataContainer() {
        this(new Reference2ObjectOpenHashMap());
    }

    public <T> @Nullable StructuredData<T> get(StructuredDataKey<T> key) {
        return this.data.get(key);
    }

    public <T> @Nullable StructuredData<T> getNonEmpty(StructuredDataKey<T> key) {
        StructuredData<?> data = this.data.get(key);
        return data != null && data.isPresent() ? data : null;
    }

    public <T> StructuredData<T> computeIfAbsent(StructuredDataKey<T> key, Function<StructuredDataKey<T>, T> mappingFunction) {
        StructuredData<T> data = this.getNonEmpty(key);
        if (data != null) {
            return data;
        }
        int id = this.serializerId(key);
        StructuredData<T> empty = StructuredData.of(key, mappingFunction.apply(key), id);
        this.data.put(key, empty);
        return empty;
    }

    public <T> @Nullable StructuredData<T> updateIfPresent(StructuredDataKey<T> key, Function<T, T> mappingFunction) {
        StructuredData<T> data = this.getNonEmpty(key);
        if (data == null) {
            return null;
        }
        data.setValue(mappingFunction.apply(data.value()));
        return data;
    }

    public <T> void set(StructuredDataKey<T> key, T value) {
        int id = this.serializerId(key);
        if (id != -1) {
            this.data.put(key, StructuredData.of(key, value, id));
        }
    }

    public <T> void replaceKey(StructuredDataKey<T> key, StructuredDataKey<T> toKey) {
        this.replace(key, toKey, Function.identity());
    }

    public <T, V> void replace(StructuredDataKey<T> key, StructuredDataKey<V> toKey, Function<T, V> valueMapper) {
        StructuredData<T> data = this.remove(key);
        if (data == null) {
            return;
        }
        if (data.isPresent()) {
            this.set(toKey, valueMapper.apply(data.value()));
        } else {
            this.addEmpty(toKey);
        }
    }

    public void set(StructuredDataKey<Unit> key) {
        this.set(key, Unit.INSTANCE);
    }

    public void addEmpty(StructuredDataKey<?> key) {
        this.data.put(key, StructuredData.empty(key, this.serializerId(key)));
    }

    public <T> @Nullable StructuredData<T> remove(StructuredDataKey<T> key) {
        StructuredData<?> data = this.data.remove(key);
        return data != null ? data : null;
    }

    public boolean contains(StructuredDataKey<?> key) {
        return this.data.containsKey(key);
    }

    public void setIdLookup(Protocol<?, ?, ?, ?> protocol, boolean mappedNames) {
        this.lookup = protocol.getMappingData().getDataComponentSerializerMappings();
        Preconditions.checkNotNull((Object)this.lookup, (Object)"Data component serializer mappings are null");
        this.mappedNames = mappedNames;
    }

    public void updateIds(Protocol<?, ?, ?, ?> protocol, Int2IntFunction rewriter) {
        for (StructuredData<?> data : this.data.values()) {
            int mappedId = rewriter.applyAsInt(data.id());
            if (mappedId == -1) continue;
            data.setId(mappedId);
        }
    }

    public StructuredDataContainer copy() {
        StructuredDataContainer copy = new StructuredDataContainer(new Reference2ObjectOpenHashMap(this.data));
        copy.lookup = this.lookup;
        return copy;
    }

    private int serializerId(StructuredDataKey<?> key) {
        int id;
        int n = id = this.mappedNames ? this.lookup.mappedId(key.identifier()) : this.lookup.id(key.identifier());
        if (id == -1) {
            Via.getPlatform().getLogger().severe("Could not find item data serializer for type " + key);
        }
        return id;
    }

    public Map<StructuredDataKey<?>, StructuredData<?>> data() {
        return this.data;
    }

    public String toString() {
        return "StructuredDataContainer{data=" + this.data + ", lookup=" + this.lookup + ", mappedNames=" + this.mappedNames + "}";
    }
}

