/*
 * Decompiled with CFR 0.152.
 */
package jo.fundy.cmds;

import jo.fundy.WebServer;
import jo.fundy.handlers.HttpServerHandler;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WebServerCommands
implements CommandExecutor {
    private static final JavaPlugin plugin = WebServer.getPlugin(WebServer.class);

    public boolean onCommand(CommandSender sender, Command cmd, String tag, String[] args) {
        Player player;
        if (cmd.getName().equals("webserver") && (sender instanceof Player ? (player = (Player)sender).hasPermission("webserver.admin") || player.isOp() : sender instanceof ConsoleCommandSender)) {
            return WebServerCommands.serverCommandFunctions(sender, args);
        }
        return false;
    }

    public static void sendTitle(CommandSender sender, String title, String subtitle) {
        if (sender instanceof Player) {
            ((Player)sender).sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)title), ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle));
        }
    }

    private static boolean serverCommandFunctions(final CommandSender sender, String[] args) {
        switch (args[0]) {
            case "reload": {
                WebServer.reloadConfiguration();
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  All Files are Successfuly Reloaded and now enabled again!")));
                WebServerCommands.sendTitle(sender, "&c&lReloading", "&fWebServer");
                return true;
            }
            case "version": {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + ChatColor.RESET + ChatColor.BOLD + "version 1.4.0 (beta)")));
                return true;
            }
            case "stop": {
                if (!HttpServerHandler.isRunning()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Shutingdown all runned Taskes")));
                    return true;
                }
                try {
                    HttpServerHandler.stop();
                    WebServerCommands.sendTitle(sender, "&c&lShuting Down", "&fWebServer");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!HttpServerHandler.isRunning()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Website Successfuly shutted down!")));
                    return true;
                }
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Website can't shutdown unknown problem")));
                return true;
            }
            case "start": {
                if (HttpServerHandler.isRunning()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Your Website is already running?!")));
                    return true;
                }
                try {
                    HttpServerHandler.start();
                    WebServerCommands.sendTitle(sender, "&c&lStarting ...", "&fWebServer");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (HttpServerHandler.isRunning()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Your Website is already running?!")));
                    return true;
                }
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Website can't shutdown unknown problem")));
                return true;
            }
            case "info": {
                if (args[1].equals("discord")) {
                    TextComponent message = new TextComponent("\u00a79\u00a7lDiscord");
                    TextComponent message_real = new TextComponent(WebServer.prefix + " Join our Discord Server on ");
                    message_real.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&fJoin the Community"))));
                    message_real.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/wUDUTP5hPW"));
                    message_real.addExtra((BaseComponent)message);
                    sender.spigot().sendMessage((BaseComponent)message_real);
                } else if (args[1].equals("commands")) {
                    TextComponent nextpage = new TextComponent("\u00a7f\u00a7l\u00bb");
                    TextComponent skipper = new TextComponent(WebServer.prefix + "                                            ");
                    skipper.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/webserver info commands 1"));
                    skipper.addExtra((BaseComponent)nextpage);
                    TextComponent nextpage1 = new TextComponent("\u00a7f\u00a7l\u00ab");
                    TextComponent skipper1 = new TextComponent(WebServer.prefix + "");
                    skipper1.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/webserver info commands"));
                    skipper1.addExtra((BaseComponent)nextpage1);
                    if (args.length == 2) {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " -----------[WebServer]-----------")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " Page: 0")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " ")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f&l Stop &f(WebServer)")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f will set your Webserver Offline")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " ")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f&l Restart &f(WebServer)")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f will reboot the WebServer")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " ")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f&l Info &f(WebServer)")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f show you all the second Commands!")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "")));
                        sender.spigot().sendMessage((BaseComponent)skipper);
                    } else if (args.length == 3 && args[2].equals("1")) {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " -----------[WebServer]-----------")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " Page: 1")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " ")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f&l Reload &f(WebServer)")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f reload your Config files")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " ")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f&l Version &f(WebServer)")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " &f show you the Plugin Version")));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "")));
                        sender.spigot().sendMessage((BaseComponent)skipper1);
                    }
                }
                return true;
            }
            case "restart": {
                if (!HttpServerHandler.isRunning()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + " Website not running try to start now!")));
                    try {
                        HttpServerHandler.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (HttpServerHandler.isRunning()) {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Website is running!")));
                        return true;
                    }
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Impossible to start Website! try to reload if you can")));
                    return true;
                }
                try {
                    HttpServerHandler.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    new BukkitRunnable(){

                        public void run() {
                            try {
                                HttpServerHandler.start();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.runTaskLater((Plugin)plugin, 60L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                new BukkitRunnable(){

                    public void run() {
                        if (HttpServerHandler.isRunning()) {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Your Website is restarted with success")));
                        } else {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(WebServer.prefix + "  Not possible to restart your website!")));
                        }
                    }
                }.runTaskLater((Plugin)plugin, 60L);
                return true;
            }
        }
        return false;
    }
}

