import{s as gs,n as Is,o as Bs}from"../chunks/scheduler.0219f8bd.js";import{S as Zs,i as Gs,g as p,s as t,r as o,A as Cs,h as i,f as a,c as n,j as bs,u as c,x as r,k as fs,y as ks,a as e,v as J,d as M,t as h,w as T}from"../chunks/index.f61edf3b.js";import{C as Js}from"../chunks/CodeBlock.38e566ae.js";import{H as V}from"../chunks/Heading.d33122ca.js";function Ws(Ms){let w,Y,v,F,d,H,j,hs="Official utilities to use the Hugging Face hub API, still very experimental.",_,u,A,y,S,m,x,U,z,b,q,f,Ts='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',L,g,rs='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',P,I,D,B,K,Z,ws='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',O,G,ds="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",ss,C,ls,k,js='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',as,W,es,$,us="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",ts,Q,ys="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",ns,R,ms="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",ps,N,is,E,Us="<li><code>hash-wasm</code> : Only used in the browser, when committing files over 10 MB. Browsers do not natively support streaming sha256 computations.</li> <li><code>type-fest</code> : Typings only</li>",os,X,cs;return d=new V({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),u=new V({props:{title:"Install",local:"install",headingTag:"h2"}}),y=new Js({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),m=new V({props:{title:"Deno",local:"deno",headingTag:"h3"}}),U=new Js({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),b=new V({props:{title:"Usage",local:"usage",headingTag:"h2"}}),I=new Js({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFiles, uploadFilesWithProgress, deleteFile, deleteRepo, listFiles, whoAmI } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span>, <span class="hljs-title class_">Credentials</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };
<span class="hljs-keyword">const</span> <span class="hljs-attr">credentials</span>: <span class="hljs-title class_">Credentials</span> = { <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> <span class="hljs-title function_">whoAmI</span>({credentials});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> <span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, credentials})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({ repo, credentials, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFiles</span>({
  repo,
  credentials,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  credentials,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFile</span>({repo, credentials, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> <span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteRepo</span>({ repo, credentials });`,wrap:!1}}),B=new V({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),C=new Js({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),W=new V({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),N=new V({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),{c(){w=p("meta"),Y=t(),v=p("p"),F=t(),o(d.$$.fragment),H=t(),j=p("p"),j.textContent=hs,_=t(),o(u.$$.fragment),A=t(),o(y.$$.fragment),S=t(),o(m.$$.fragment),x=t(),o(U.$$.fragment),z=t(),o(b.$$.fragment),q=t(),f=p("p"),f.innerHTML=Ts,L=t(),g=p("p"),g.innerHTML=rs,P=t(),o(I.$$.fragment),D=t(),o(B.$$.fragment),K=t(),Z=p("p"),Z.innerHTML=ws,O=t(),G=p("p"),G.textContent=ds,ss=t(),o(C.$$.fragment),ls=t(),k=p("p"),k.innerHTML=js,as=t(),o(W.$$.fragment),es=t(),$=p("p"),$.innerHTML=us,ts=t(),Q=p("p"),Q.innerHTML=ys,ns=t(),R=p("p"),R.innerHTML=ms,ps=t(),o(N.$$.fragment),is=t(),E=p("ul"),E.innerHTML=Us,os=t(),X=p("p"),this.h()},l(s){const l=Cs("svelte-u9bgzb",document.head);w=i(l,"META",{name:!0,content:!0}),l.forEach(a),Y=n(s),v=i(s,"P",{}),bs(v).forEach(a),F=n(s),c(d.$$.fragment,s),H=n(s),j=i(s,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1rd1r5p"&&(j.textContent=hs),_=n(s),c(u.$$.fragment,s),A=n(s),c(y.$$.fragment,s),S=n(s),c(m.$$.fragment,s),x=n(s),c(U.$$.fragment,s),z=n(s),c(b.$$.fragment,s),q=n(s),f=i(s,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1nqczoz"&&(f.innerHTML=Ts),L=n(s),g=i(s,"P",{"data-svelte-h":!0}),r(g)!=="svelte-6ptpin"&&(g.innerHTML=rs),P=n(s),c(I.$$.fragment,s),D=n(s),c(B.$$.fragment,s),K=n(s),Z=i(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-bfok93"&&(Z.innerHTML=ws),O=n(s),G=i(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1az135e"&&(G.textContent=ds),ss=n(s),c(C.$$.fragment,s),ls=n(s),k=i(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1qsa6tj"&&(k.innerHTML=js),as=n(s),c(W.$$.fragment,s),es=n(s),$=i(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-1gspubq"&&($.innerHTML=us),ts=n(s),Q=i(s,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-em0etc"&&(Q.innerHTML=ys),ns=n(s),R=i(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-lja874"&&(R.innerHTML=ms),ps=n(s),c(N.$$.fragment,s),is=n(s),E=i(s,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-cfwqb4"&&(E.innerHTML=Us),os=n(s),X=i(s,"P",{}),bs(X).forEach(a),this.h()},h(){fs(w,"name","hf:doc:metadata"),fs(w,"content",$s)},m(s,l){ks(document.head,w),e(s,Y,l),e(s,v,l),e(s,F,l),J(d,s,l),e(s,H,l),e(s,j,l),e(s,_,l),J(u,s,l),e(s,A,l),J(y,s,l),e(s,S,l),J(m,s,l),e(s,x,l),J(U,s,l),e(s,z,l),J(b,s,l),e(s,q,l),e(s,f,l),e(s,L,l),e(s,g,l),e(s,P,l),J(I,s,l),e(s,D,l),J(B,s,l),e(s,K,l),e(s,Z,l),e(s,O,l),e(s,G,l),e(s,ss,l),J(C,s,l),e(s,ls,l),e(s,k,l),e(s,as,l),J(W,s,l),e(s,es,l),e(s,$,l),e(s,ts,l),e(s,Q,l),e(s,ns,l),e(s,R,l),e(s,ps,l),J(N,s,l),e(s,is,l),e(s,E,l),e(s,os,l),e(s,X,l),cs=!0},p:Is,i(s){cs||(M(d.$$.fragment,s),M(u.$$.fragment,s),M(y.$$.fragment,s),M(m.$$.fragment,s),M(U.$$.fragment,s),M(b.$$.fragment,s),M(I.$$.fragment,s),M(B.$$.fragment,s),M(C.$$.fragment,s),M(W.$$.fragment,s),M(N.$$.fragment,s),cs=!0)},o(s){h(d.$$.fragment,s),h(u.$$.fragment,s),h(y.$$.fragment,s),h(m.$$.fragment,s),h(U.$$.fragment,s),h(b.$$.fragment,s),h(I.$$.fragment,s),h(B.$$.fragment,s),h(C.$$.fragment,s),h(W.$$.fragment,s),h(N.$$.fragment,s),cs=!1},d(s){s&&(a(Y),a(v),a(F),a(H),a(j),a(_),a(A),a(S),a(x),a(z),a(q),a(f),a(L),a(g),a(P),a(D),a(K),a(Z),a(O),a(G),a(ss),a(ls),a(k),a(as),a(es),a($),a(ts),a(Q),a(ns),a(R),a(ps),a(is),a(E),a(os),a(X)),a(w),T(d,s),T(u,s),T(y,s),T(m,s),T(U,s),T(b,s),T(I,s),T(B,s),T(C,s),T(W,s),T(N,s)}}}const $s='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Qs(Ms){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vs extends Zs{constructor(w){super(),Gs(this,w,Qs,Ws,gs,{})}}export{vs as component};
