import{s as Qt,o as Yt,n as Jt}from"../chunks/scheduler.8c3d61f6.js";import{S as zt,i as Ft,g as p,s as l,r as m,A as Ht,h as c,f as n,c as o,j as Z,u as d,x as j,k as I,y as i,a as s,v as h,d as M,t as u,w as f,m as Tt,n as Ut}from"../chunks/index.da70eac4.js";import{T as at}from"../chunks/Tip.1d9b8c37.js";import{D as N}from"../chunks/Docstring.6b390b9a.js";import{C as Ie}from"../chunks/CodeBlock.00a903b3.js";import{E as Pt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as Q,E as St}from"../chunks/EditOnGithub.1e64e623.js";function Lt(T){let a,r='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers.md">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){a=p("p"),a.innerHTML=r},l(g){a=c(g,"P",{"data-svelte-h":!0}),j(a)!=="svelte-w7r39y"&&(a.innerHTML=r)},m(g,w){s(g,a,w)},p:Jt,d(g){g&&n(a)}}}function qt(T){let a,r,g="When enabling <code>force_zeros_for_empty_prompt</code>, it is recommended to run the text encoding step outside the autocast context in full precision.";return{c(){a=Tt(`The original Mochi implementation zeros out empty prompts. However, enabling this option and placing the entire pipeline under autocast can lead to numerical overflows with the T5 text encoder.
`),r=p("p"),r.innerHTML=g},l(w){a=Ut(w,`The original Mochi implementation zeros out empty prompts. However, enabling this option and placing the entire pipeline under autocast can lead to numerical overflows with the T5 text encoder.
`),r=c(w,"P",{"data-svelte-h":!0}),j(r)!=="svelte-16wuz5"&&(r.innerHTML=g)},m(w,J){s(w,a,J),s(w,r,J)},p:Jt,d(w){w&&(n(a),n(r))}}}function Dt(T){let a;return{c(){a=Tt("Decoding the latents in full precision is very memory intensive. You will need at least 70GB VRAM to generate the 163 frames in this example. To reduce memory, either reduce the number of frames or run the decoding step in `torch.bfloat16`.")},l(r){a=Ut(r,"Decoding the latents in full precision is very memory intensive. You will need at least 70GB VRAM to generate the 163 frames in this example. To reduce memory, either reduce the number of frames or run the decoding step in `torch.bfloat16`.")},m(r,g){s(r,a,g)},d(r){r&&n(a)}}}function Kt(T){let a;return{c(){a=Tt("Diffusers currently doesn't support using the FP8 scaled versions of the Mochi single file checkpoints.")},l(r){a=Ut(r,"Diffusers currently doesn't support using the FP8 scaled versions of the Mochi single file checkpoints.")},m(r,g){s(r,a,g)},d(r){r&&n(a)}}}function Ot(T){let a,r="Examples:",g,w,J;return w=new Ie({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEFwcm9tcHQlMjAlM0QlMjAlMjJDbG9zZS11cCUyMG9mJTIwYSUyMGNoYW1lbGVvbidzJTIwZXllJTJDJTIwd2l0aCUyMGl0cyUyMHNjYWx5JTIwc2tpbiUyMGNoYW5naW5nJTIwY29sb3IuJTIwVWx0cmElMjBoaWdoJTIwcmVzb2x1dGlvbiUyMDRrLiUyMiUwQWZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjUpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8oZnJhbWVzJTJDJTIwJTIybW9jaGkubXA0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_vae_tiling()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = pipe(prompt, num_inference_steps=<span class="hljs-number">28</span>, guidance_scale=<span class="hljs-number">3.5</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(frames, <span class="hljs-string">&quot;mochi.mp4&quot;</span>)`,wrap:!1}}),{c(){a=p("p"),a.textContent=r,g=l(),m(w.$$.fragment)},l(b){a=c(b,"P",{"data-svelte-h":!0}),j(a)!=="svelte-kvfsh7"&&(a.textContent=r),g=o(b),d(w.$$.fragment,b)},m(b,U){s(b,a,U),s(b,g,U),h(w,b,U),J=!0},p:Jt,i(b){J||(M(w.$$.fragment,b),J=!0)},o(b){u(w.$$.fragment,b),J=!1},d(b){b&&(n(a),n(g)),f(w,b)}}}function en(T){let a,r,g,w,J,b,U,vt='<a href="https://huggingface.co/genmo/mochi-1-preview" rel="nofollow">Mochi 1 Preview</a> from Genmo.',ke,Y,Zt="<em>Mochi 1 preview is an open state-of-the-art video generation model with high-fidelity motion and strong prompt adherence in preliminary evaluation. This model dramatically closes the gap between closed and open video generation systems. The model is released under a permissive Apache 2.0 license.</em>",Ge,G,We,z,$e,F,It="The following example will download the full precision <code>mochi-1-preview</code> weights and produce the highest quality results but will require at least 42GB VRAM to run.",Be,H,Ae,P,Xe,S,Ct="The following example will use the <code>bfloat16</code> variant of the model and requires 22GB VRAM to run. There is a slight drop in the quality of the generated video as a result.",Ve,L,Ee,q,xe,D,kt='The <a href="https://github.com/genmoai/mochi/tree/main" rel="nofollow">Genmo Mochi implementation</a> uses different precision values for each stage in the inference process. The text encoder and VAE use <code>torch.float32</code>, while the DiT uses <code>torch.bfloat16</code> with the <a href="https://pytorch.org/docs/stable/generated/torch.nn.attention.sdpa_kernel.html#torch.nn.attention.sdpa_kernel" rel="nofollow">attention kernel</a> set to <code>EFFICIENT_ATTENTION</code>. Diffusers pipelines currently do not support setting different <code>dtypes</code> for different stages of the pipeline. In order to run inference in the same way as the the original implementation, please refer to the following example.',Re,W,Ne,$,Qe,K,Ye,O,ze,ee,Gt="It is possible to split the large Mochi transformer across multiple GPUs using the <code>device_map</code> and <code>max_memory</code> options in <code>from_pretrained</code>. In the following example we split the model across two GPUs, each with 24GB of VRAM.",Fe,te,He,ne,Pe,se,Wt="You can use <code>from_single_file</code> to load the Mochi transformer in its original format.",Se,B,Le,le,qe,oe,De,y,ae,it,we,$t="The mochi pipeline for text-to-video generation.",rt,_e,Bt='Reference: <a href="https://github.com/genmoai/models" rel="nofollow">https://github.com/genmoai/models</a>',pt,v,ie,ct,be,At="Function invoked when calling the pipeline for generation.",mt,A,dt,X,re,ht,je,Xt=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Mt,V,pe,ut,Je,Vt=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,ft,E,ce,gt,Te,Et=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,yt,x,me,wt,Ue,xt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,_t,R,de,bt,ve,Rt="Encodes the prompt into text encoder hidden states.",Ke,he,Oe,C,Me,jt,Ze,Nt="Output class for Mochi pipelines.",et,ue,tt,Ce,nt;return J=new Q({props:{title:"Mochi 1 Preview",local:"mochi-1-preview",headingTag:"h1"}}),G=new at({props:{$$slots:{default:[Lt]},$$scope:{ctx:T}}}),z=new Q({props:{title:"Generating videos with Mochi-1 Preview",local:"generating-videos-with-mochi-1-preview",headingTag:"h2"}}),H=new Ie({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIpJTBBJTBBJTIzJTIwRW5hYmxlJTIwbWVtb3J5JTIwc2F2aW5ncyUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJDbG9zZS11cCUyMG9mJTIwYSUyMGNoYW1lbGVvbidzJTIwZXllJTJDJTIwd2l0aCUyMGl0cyUyMHNjYWx5JTIwc2tpbiUyMGNoYW5naW5nJTIwY29sb3IuJTIwVWx0cmElMjBoaWdoJTIwcmVzb2x1dGlvbiUyMDRrLiUyMiUwQSUwQXdpdGglMjB0b3JjaC5hdXRvY2FzdCglMjJjdWRhJTIyJTJDJTIwdG9yY2guYmZsb2F0MTYlMkMlMjBjYWNoZV9lbmFibGVkJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZnJhbWVzJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1fZnJhbWVzJTNEODUpLmZyYW1lcyU1QjAlNUQlMEElMEFleHBvcnRfdG9fdmlkZW8oZnJhbWVzJTJDJTIwJTIybW9jaGkubXA0JTIyJTJDJTIwZnBzJTNEMzAp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>)

<span class="hljs-comment"># Enable memory savings</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>

<span class="hljs-keyword">with</span> torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16, cache_enabled=<span class="hljs-literal">False</span>):
      frames = pipe(prompt, num_frames=<span class="hljs-number">85</span>).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;mochi.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),P=new Q({props:{title:"Using a lower precision variant to save memory",local:"using-a-lower-precision-variant-to-save-memory",headingTag:"h2"}}),L=new Ie({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIlMkMlMjB2YXJpYW50JTNEJTIyYmYxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBJTBBJTIzJTIwRW5hYmxlJTIwbWVtb3J5JTIwc2F2aW5ncyUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJDbG9zZS11cCUyMG9mJTIwYSUyMGNoYW1lbGVvbidzJTIwZXllJTJDJTIwd2l0aCUyMGl0cyUyMHNjYWx5JTIwc2tpbiUyMGNoYW5naW5nJTIwY29sb3IuJTIwVWx0cmElMjBoaWdoJTIwcmVzb2x1dGlvbiUyMDRrLiUyMiUwQWZyYW1lcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2ZyYW1lcyUzRDg1KS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMm1vY2hpLm1wNCUyMiUyQyUyMGZwcyUzRDMwKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, variant=<span class="hljs-string">&quot;bf16&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-comment"># Enable memory savings</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>
frames = pipe(prompt, num_frames=<span class="hljs-number">85</span>).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;mochi.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),q=new Q({props:{title:"Reproducing the results from the Genmo Mochi repo",local:"reproducing-the-results-from-the-genmo-mochi-repo",headingTag:"h2"}}),W=new at({props:{$$slots:{default:[qt]},$$scope:{ctx:T}}}),$=new at({props:{$$slots:{default:[Dt]},$$scope:{ctx:T}}}),K=new Ie({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> diffusers.video_processor <span class="hljs-keyword">import</span> VideoProcessor

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, force_zeros_for_empty_prompt=<span class="hljs-literal">True</span>)
pipe.enable_vae_tiling()
pipe.enable_model_cpu_offload()

prompt =  <span class="hljs-string">&quot;An aerial shot of a parade of elephants walking across the African savannah. The camera showcases the herd and the surrounding landscape.&quot;</span>

<span class="hljs-keyword">with</span> torch.no_grad():
    prompt_embeds, prompt_attention_mask, negative_prompt_embeds, negative_prompt_attention_mask = (
        pipe.encode_prompt(prompt=prompt)
    )

<span class="hljs-keyword">with</span> torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16):
    <span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.EFFICIENT_ATTENTION):
        frames = pipe(
            prompt_embeds=prompt_embeds,
            prompt_attention_mask=prompt_attention_mask,
            negative_prompt_embeds=negative_prompt_embeds,
            negative_prompt_attention_mask=negative_prompt_attention_mask,
            guidance_scale=<span class="hljs-number">4.5</span>,
            num_inference_steps=<span class="hljs-number">64</span>,
            height=<span class="hljs-number">480</span>,
            width=<span class="hljs-number">848</span>,
            num_frames=<span class="hljs-number">163</span>,
            generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
            output_type=<span class="hljs-string">&quot;latent&quot;</span>,
            return_dict=<span class="hljs-literal">False</span>,
        )[<span class="hljs-number">0</span>]

video_processor = VideoProcessor(vae_scale_factor=<span class="hljs-number">8</span>)
has_latents_mean = <span class="hljs-built_in">hasattr</span>(pipe.vae.config, <span class="hljs-string">&quot;latents_mean&quot;</span>) <span class="hljs-keyword">and</span> pipe.vae.config.latents_mean <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>
has_latents_std = <span class="hljs-built_in">hasattr</span>(pipe.vae.config, <span class="hljs-string">&quot;latents_std&quot;</span>) <span class="hljs-keyword">and</span> pipe.vae.config.latents_std <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> has_latents_mean <span class="hljs-keyword">and</span> has_latents_std:
    latents_mean = (
        torch.tensor(pipe.vae.config.latents_mean).view(<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>).to(frames.device, frames.dtype)
    )
    latents_std = (
        torch.tensor(pipe.vae.config.latents_std).view(<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>).to(frames.device, frames.dtype)
    )
    frames = frames * latents_std / pipe.vae.config.scaling_factor + latents_mean
<span class="hljs-keyword">else</span>:
    frames = frames / pipe.vae.config.scaling_factor

<span class="hljs-keyword">with</span> torch.no_grad():
    video = pipe.vae.decode(frames.to(pipe.vae.dtype), return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]

video = video_processor.postprocess_video(video)[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;mochi.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),O=new Q({props:{title:"Running inference with multiple GPUs",local:"running-inference-with-multiple-gpus",headingTag:"h2"}}),te=new Ie({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline, MochiTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>
transformer = MochiTransformer3DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;24GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;24GB&quot;</span>}
)

pipe = MochiPipeline.from_pretrained(model_id,  transformer=transformer)
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

<span class="hljs-keyword">with</span> torch.autocast(device_type=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16, cache_enabled=<span class="hljs-literal">False</span>):
    frames = pipe(
        prompt=<span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>,
        negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
        height=<span class="hljs-number">480</span>,
        width=<span class="hljs-number">848</span>,
        num_frames=<span class="hljs-number">85</span>,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">4.5</span>,
        num_videos_per_prompt=<span class="hljs-number">1</span>,
        generator=torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
        max_sequence_length=<span class="hljs-number">256</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    ).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),ne=new Q({props:{title:"Using single file loading with the Mochi Transformer",local:"using-single-file-loading-with-the-mochi-transformer",headingTag:"h2"}}),B=new at({props:{$$slots:{default:[Kt]},$$scope:{ctx:T}}}),le=new Ie({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline, MochiTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/Comfy-Org/mochi_preview_repackaged/blob/main/split_files/diffusion_models/mochi_preview_bf16.safetensors&quot;</span>

transformer = MochiTransformer3DModel.from_pretrained(ckpt_path, torch_dtype=torch.bfloat16)

pipe = MochiPipeline.from_pretrained(model_id,  transformer=transformer)
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

<span class="hljs-keyword">with</span> torch.autocast(device_type=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16, cache_enabled=<span class="hljs-literal">False</span>):
    frames = pipe(
        prompt=<span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>,
        negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
        height=<span class="hljs-number">480</span>,
        width=<span class="hljs-number">848</span>,
        num_frames=<span class="hljs-number">85</span>,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">4.5</span>,
        num_videos_per_prompt=<span class="hljs-number">1</span>,
        generator=torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
        max_sequence_length=<span class="hljs-number">256</span>,
        output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    ).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),oe=new Q({props:{title:"MochiPipeline",local:"diffusers.MochiPipeline",headingTag:"h2"}}),ae=new N({props:{name:"class diffusers.MochiPipeline",anchor:"diffusers.MochiPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": MochiTransformer3DModel"},{name:"force_zeros_for_empty_prompt",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.MochiPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/mochi_transformer3d#diffusers.MochiTransformer3DModel">MochiTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.MochiPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.MochiPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.MochiPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.MochiPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.MochiPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L156"}}),ie=new N({props:{name:"__call__",anchor:"diffusers.MochiPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": int = 19"},{name:"num_inference_steps",val:": int = 64"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.MochiPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.MochiPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.default_height</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.MochiPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.default_width</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.MochiPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>19</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.MochiPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.MochiPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.MochiPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>4.5</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.MochiPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.MochiPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.MochiPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.MochiPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.MochiPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.MochiPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.MochiPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.MochiPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.MochiPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.mochi.MochiPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.MochiPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.MochiPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.MochiPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.MochiPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>256</code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L487",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.mochi.MochiPipelineOutput</code> is returned, otherwise a <code>tuple</code>
is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.mochi.MochiPipelineOutput</code> or <code>tuple</code></p>
`}}),A=new Pt({props:{anchor:"diffusers.MochiPipeline.__call__.example",$$slots:{default:[Ot]},$$scope:{ctx:T}}}),re=new N({props:{name:"disable_vae_slicing",anchor:"diffusers.MochiPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L415"}}),pe=new N({props:{name:"disable_vae_tiling",anchor:"diffusers.MochiPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L430"}}),ce=new N({props:{name:"enable_vae_slicing",anchor:"diffusers.MochiPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L408"}}),me=new N({props:{name:"enable_vae_tiling",anchor:"diffusers.MochiPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L422"}}),de=new N({props:{name:"encode_prompt",anchor:"diffusers.MochiPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.MochiPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.MochiPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.MochiPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.MochiPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.MochiPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.MochiPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.MochiPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.MochiPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_mochi.py#L272"}}),he=new Q({props:{title:"MochiPipelineOutput",local:"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput",headingTag:"h2"}}),Me=new N({props:{name:"class diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput",anchor:"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/mochi/pipeline_output.py#L8"}}),ue=new St({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/mochi.md"}}),{c(){a=p("meta"),r=l(),g=p("p"),w=l(),m(J.$$.fragment),b=l(),U=p("p"),U.innerHTML=vt,ke=l(),Y=p("p"),Y.innerHTML=Zt,Ge=l(),m(G.$$.fragment),We=l(),m(z.$$.fragment),$e=l(),F=p("p"),F.innerHTML=It,Be=l(),m(H.$$.fragment),Ae=l(),m(P.$$.fragment),Xe=l(),S=p("p"),S.innerHTML=Ct,Ve=l(),m(L.$$.fragment),Ee=l(),m(q.$$.fragment),xe=l(),D=p("p"),D.innerHTML=kt,Re=l(),m(W.$$.fragment),Ne=l(),m($.$$.fragment),Qe=l(),m(K.$$.fragment),Ye=l(),m(O.$$.fragment),ze=l(),ee=p("p"),ee.innerHTML=Gt,Fe=l(),m(te.$$.fragment),He=l(),m(ne.$$.fragment),Pe=l(),se=p("p"),se.innerHTML=Wt,Se=l(),m(B.$$.fragment),Le=l(),m(le.$$.fragment),qe=l(),m(oe.$$.fragment),De=l(),y=p("div"),m(ae.$$.fragment),it=l(),we=p("p"),we.textContent=$t,rt=l(),_e=p("p"),_e.innerHTML=Bt,pt=l(),v=p("div"),m(ie.$$.fragment),ct=l(),be=p("p"),be.textContent=At,mt=l(),m(A.$$.fragment),dt=l(),X=p("div"),m(re.$$.fragment),ht=l(),je=p("p"),je.innerHTML=Xt,Mt=l(),V=p("div"),m(pe.$$.fragment),ut=l(),Je=p("p"),Je.innerHTML=Vt,ft=l(),E=p("div"),m(ce.$$.fragment),gt=l(),Te=p("p"),Te.textContent=Et,yt=l(),x=p("div"),m(me.$$.fragment),wt=l(),Ue=p("p"),Ue.textContent=xt,_t=l(),R=p("div"),m(de.$$.fragment),bt=l(),ve=p("p"),ve.textContent=Rt,Ke=l(),m(he.$$.fragment),Oe=l(),C=p("div"),m(Me.$$.fragment),jt=l(),Ze=p("p"),Ze.textContent=Nt,et=l(),m(ue.$$.fragment),tt=l(),Ce=p("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);a=c(t,"META",{name:!0,content:!0}),t.forEach(n),r=o(e),g=c(e,"P",{}),Z(g).forEach(n),w=o(e),d(J.$$.fragment,e),b=o(e),U=c(e,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1w3beu"&&(U.innerHTML=vt),ke=o(e),Y=c(e,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-16aanyn"&&(Y.innerHTML=Zt),Ge=o(e),d(G.$$.fragment,e),We=o(e),d(z.$$.fragment,e),$e=o(e),F=c(e,"P",{"data-svelte-h":!0}),j(F)!=="svelte-w0d3wt"&&(F.innerHTML=It),Be=o(e),d(H.$$.fragment,e),Ae=o(e),d(P.$$.fragment,e),Xe=o(e),S=c(e,"P",{"data-svelte-h":!0}),j(S)!=="svelte-gdmfoq"&&(S.innerHTML=Ct),Ve=o(e),d(L.$$.fragment,e),Ee=o(e),d(q.$$.fragment,e),xe=o(e),D=c(e,"P",{"data-svelte-h":!0}),j(D)!=="svelte-qbredq"&&(D.innerHTML=kt),Re=o(e),d(W.$$.fragment,e),Ne=o(e),d($.$$.fragment,e),Qe=o(e),d(K.$$.fragment,e),Ye=o(e),d(O.$$.fragment,e),ze=o(e),ee=c(e,"P",{"data-svelte-h":!0}),j(ee)!=="svelte-14s0l4"&&(ee.innerHTML=Gt),Fe=o(e),d(te.$$.fragment,e),He=o(e),d(ne.$$.fragment,e),Pe=o(e),se=c(e,"P",{"data-svelte-h":!0}),j(se)!=="svelte-14rhs7p"&&(se.innerHTML=Wt),Se=o(e),d(B.$$.fragment,e),Le=o(e),d(le.$$.fragment,e),qe=o(e),d(oe.$$.fragment,e),De=o(e),y=c(e,"DIV",{class:!0});var _=Z(y);d(ae.$$.fragment,_),it=o(_),we=c(_,"P",{"data-svelte-h":!0}),j(we)!=="svelte-11luvqp"&&(we.textContent=$t),rt=o(_),_e=c(_,"P",{"data-svelte-h":!0}),j(_e)!=="svelte-1br2zew"&&(_e.innerHTML=Bt),pt=o(_),v=c(_,"DIV",{class:!0});var k=Z(v);d(ie.$$.fragment,k),ct=o(k),be=c(k,"P",{"data-svelte-h":!0}),j(be)!=="svelte-v78lg8"&&(be.textContent=At),mt=o(k),d(A.$$.fragment,k),k.forEach(n),dt=o(_),X=c(_,"DIV",{class:!0});var fe=Z(X);d(re.$$.fragment,fe),ht=o(fe),je=c(fe,"P",{"data-svelte-h":!0}),j(je)!=="svelte-1s3c06i"&&(je.innerHTML=Xt),fe.forEach(n),Mt=o(_),V=c(_,"DIV",{class:!0});var ge=Z(V);d(pe.$$.fragment,ge),ut=o(ge),Je=c(ge,"P",{"data-svelte-h":!0}),j(Je)!=="svelte-pkn4ui"&&(Je.innerHTML=Vt),ge.forEach(n),ft=o(_),E=c(_,"DIV",{class:!0});var ye=Z(E);d(ce.$$.fragment,ye),gt=o(ye),Te=c(ye,"P",{"data-svelte-h":!0}),j(Te)!=="svelte-14bnrb6"&&(Te.textContent=Et),ye.forEach(n),yt=o(_),x=c(_,"DIV",{class:!0});var st=Z(x);d(me.$$.fragment,st),wt=o(st),Ue=c(st,"P",{"data-svelte-h":!0}),j(Ue)!=="svelte-1xwrf7t"&&(Ue.textContent=xt),st.forEach(n),_t=o(_),R=c(_,"DIV",{class:!0});var lt=Z(R);d(de.$$.fragment,lt),bt=o(lt),ve=c(lt,"P",{"data-svelte-h":!0}),j(ve)!=="svelte-16q0ax1"&&(ve.textContent=Rt),lt.forEach(n),_.forEach(n),Ke=o(e),d(he.$$.fragment,e),Oe=o(e),C=c(e,"DIV",{class:!0});var ot=Z(C);d(Me.$$.fragment,ot),jt=o(ot),Ze=c(ot,"P",{"data-svelte-h":!0}),j(Ze)!=="svelte-srx61f"&&(Ze.textContent=Nt),ot.forEach(n),et=o(e),d(ue.$$.fragment,e),tt=o(e),Ce=c(e,"P",{}),Z(Ce).forEach(n),this.h()},h(){I(a,"name","hf:doc:metadata"),I(a,"content",tn),I(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,a),s(e,r,t),s(e,g,t),s(e,w,t),h(J,e,t),s(e,b,t),s(e,U,t),s(e,ke,t),s(e,Y,t),s(e,Ge,t),h(G,e,t),s(e,We,t),h(z,e,t),s(e,$e,t),s(e,F,t),s(e,Be,t),h(H,e,t),s(e,Ae,t),h(P,e,t),s(e,Xe,t),s(e,S,t),s(e,Ve,t),h(L,e,t),s(e,Ee,t),h(q,e,t),s(e,xe,t),s(e,D,t),s(e,Re,t),h(W,e,t),s(e,Ne,t),h($,e,t),s(e,Qe,t),h(K,e,t),s(e,Ye,t),h(O,e,t),s(e,ze,t),s(e,ee,t),s(e,Fe,t),h(te,e,t),s(e,He,t),h(ne,e,t),s(e,Pe,t),s(e,se,t),s(e,Se,t),h(B,e,t),s(e,Le,t),h(le,e,t),s(e,qe,t),h(oe,e,t),s(e,De,t),s(e,y,t),h(ae,y,null),i(y,it),i(y,we),i(y,rt),i(y,_e),i(y,pt),i(y,v),h(ie,v,null),i(v,ct),i(v,be),i(v,mt),h(A,v,null),i(y,dt),i(y,X),h(re,X,null),i(X,ht),i(X,je),i(y,Mt),i(y,V),h(pe,V,null),i(V,ut),i(V,Je),i(y,ft),i(y,E),h(ce,E,null),i(E,gt),i(E,Te),i(y,yt),i(y,x),h(me,x,null),i(x,wt),i(x,Ue),i(y,_t),i(y,R),h(de,R,null),i(R,bt),i(R,ve),s(e,Ke,t),h(he,e,t),s(e,Oe,t),s(e,C,t),h(Me,C,null),i(C,jt),i(C,Ze),s(e,et,t),h(ue,e,t),s(e,tt,t),s(e,Ce,t),nt=!0},p(e,[t]){const _={};t&2&&(_.$$scope={dirty:t,ctx:e}),G.$set(_);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),W.$set(k);const fe={};t&2&&(fe.$$scope={dirty:t,ctx:e}),$.$set(fe);const ge={};t&2&&(ge.$$scope={dirty:t,ctx:e}),B.$set(ge);const ye={};t&2&&(ye.$$scope={dirty:t,ctx:e}),A.$set(ye)},i(e){nt||(M(J.$$.fragment,e),M(G.$$.fragment,e),M(z.$$.fragment,e),M(H.$$.fragment,e),M(P.$$.fragment,e),M(L.$$.fragment,e),M(q.$$.fragment,e),M(W.$$.fragment,e),M($.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(B.$$.fragment,e),M(le.$$.fragment,e),M(oe.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(A.$$.fragment,e),M(re.$$.fragment,e),M(pe.$$.fragment,e),M(ce.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(he.$$.fragment,e),M(Me.$$.fragment,e),M(ue.$$.fragment,e),nt=!0)},o(e){u(J.$$.fragment,e),u(G.$$.fragment,e),u(z.$$.fragment,e),u(H.$$.fragment,e),u(P.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(W.$$.fragment,e),u($.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(B.$$.fragment,e),u(le.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(A.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(Me.$$.fragment,e),u(ue.$$.fragment,e),nt=!1},d(e){e&&(n(r),n(g),n(w),n(b),n(U),n(ke),n(Y),n(Ge),n(We),n($e),n(F),n(Be),n(Ae),n(Xe),n(S),n(Ve),n(Ee),n(xe),n(D),n(Re),n(Ne),n(Qe),n(Ye),n(ze),n(ee),n(Fe),n(He),n(Pe),n(se),n(Se),n(Le),n(qe),n(De),n(y),n(Ke),n(Oe),n(C),n(et),n(tt),n(Ce)),n(a),f(J,e),f(G,e),f(z,e),f(H,e),f(P,e),f(L,e),f(q,e),f(W,e),f($,e),f(K,e),f(O,e),f(te,e),f(ne,e),f(B,e),f(le,e),f(oe,e),f(ae),f(ie),f(A),f(re),f(pe),f(ce),f(me),f(de),f(he,e),f(Me),f(ue,e)}}}const tn='{"title":"Mochi 1 Preview","local":"mochi-1-preview","sections":[{"title":"Generating videos with Mochi-1 Preview","local":"generating-videos-with-mochi-1-preview","sections":[],"depth":2},{"title":"Using a lower precision variant to save memory","local":"using-a-lower-precision-variant-to-save-memory","sections":[],"depth":2},{"title":"Reproducing the results from the Genmo Mochi repo","local":"reproducing-the-results-from-the-genmo-mochi-repo","sections":[],"depth":2},{"title":"Running inference with multiple GPUs","local":"running-inference-with-multiple-gpus","sections":[],"depth":2},{"title":"Using single file loading with the Mochi Transformer","local":"using-single-file-loading-with-the-mochi-transformer","sections":[],"depth":2},{"title":"MochiPipeline","local":"diffusers.MochiPipeline","sections":[],"depth":2},{"title":"MochiPipelineOutput","local":"diffusers.pipelines.mochi.pipeline_output.MochiPipelineOutput","sections":[],"depth":2}],"depth":1}';function nn(T){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mn extends zt{constructor(a){super(),Ft(this,a,nn,en,Qt,{})}}export{mn as component};
