GDPC                                                                                       	   $   .godot/global_script_class_cache.cfg4            Р88~$}P    D   .godot/imported/gdre_icon.png-8d41c83d97faf920ed253320806f28dd.ctex         N
      <_,dΟ&Y       .godot/uid_cache.binP@            ?L<C͍2       gdre_icon.png   4     m      `\<B]        gdre_icon.png.importP
             w>`&Խ       gdre_main.gd       tk      .7ƙ.       gdre_main.tscn  v      ~      ^ZnK/q[       gdre_theme.tres  }           W' _I ۫       project.binary  @           ֈFR K\            GST2   @   @      
               @ @        
  RIFF
  WEBPVP8L
  /?t!p!aoIlCP	kV$ɶ(R0Y8J ϑY ۳f^
бm[3$C0kCΚkV$9:Ai!DhDMӖ'&DK NonCm۶m->[~mmt7	$IRYE7w=Q;P) 0Q);S q=~:1Az6}>~uA-%C yXt^ 맗xb*KB0Mfy$\ pC 0qL"eo\~[@0z>/ }; N.R11k4םo.  )x5  .V=.p ZpYX
oq˼F<(E'ށ-_otVE4؋p5v{(18 v:PlS^ypU wxP	/P*ͦ1\yHW*(8谯XA M&'rPqO6]aby$+
 K5wD,\.~EaU@N`k] i|VsO`RnW6!
n$C@
 ηJ2vA),2X 
p0hoa`OK4fM n8EZ
 aɦĨB?S
7bl|_:on_H=:iEB-b`HF4ޥWR6tޅ{K+9fȉFezN+c1fUu	^~u*%h;|yEdor o~:w_Uwyq b "8?>p<u?q*s^ E͖|'?N5X#	" c
m'BFjI  (j u[
wq  m =(^x^l8AaH)Wg-	!+@$RlW=f8	b F" B2J¹ชɩߎ6gH5rk?=Og؃R D'>(^Ƒ"_0kh8.ĉu񧿾mWs#$WW??G[  pT$=v{AFoot+~*(vfc .aE {E!ZO[0+n L8i؉e!ZH+((YUiks klj t. 
Xuyud+>)]?#! K@ $y`.p0oIH sos -z 2
LD+B&G3 ӧ9 a|)<pn uxS#$*"ba#A!  hX&(L;z^^tXb}z F!j)4㒟-']r#BSHJa$]54j 4wR C53?bV(NW 6 W8tt*8<zۗ{E^&Ôb)p8 k[>xy!
>v|r  ^+i@0"G:K?_^Y RZ |ţ{uS ƮCm[?(	
_] `]gF( \%S)X]Vl59KVpE)b`;8*T[DHc㯗
GC5qan\(
 X.弁CWE4n8ua
9x	 Ċ!Z!FXbCjI| (4A4@tuXZ=YP1I 8/t@EFr
 *W\[mdFRs B90ןe@q!-Z^ @7#SVԠ$@
8f4hvqx^R;caLrsKSE؁CnPPi Z8~k
|pcA]cߜOp)l GcRoKcuSp~Vܪ~rG"{;, 8VLTq$6I Lp١{4IDq9{)@ӹ21`Xw ruw3e?DKK"O+=2cլ
НΡ{2D4`H?x$iX͂L' 5\s;eL$;8XG%5=LG g쾭{^Z`2	/F Q˥Ma[e6uLi h <~
,[[N8c4{ճX{oR8G8n\Cٮ>xG&B v;  Y*s 0F_U={p _$ Tph_  8bם.H\    [remap]

importer="texture"
type="CompressedTexture2D"
uid="uid://ced15puo3davk"
path="res://.godot/imported/gdre_icon.png-8d41c83d97faf920ed253320806f28dd.ctex"
metadata={
"vram_texture": false
}
           extends Control

var ver_major = 0
var ver_minor = 0
var scripts_only = false
var disable_multi_threading = false
var config: ConfigFile = null
var last_error = ""
var CONFIG_PATH = "user://gdre_settings.cfg"

func test_text_to_bin(txt_to_bin: String, output_dir: String):
	var importer:ImportExporter = ImportExporter.new()
	var dst_file = txt_to_bin.get_file().replace(".tscn", ".scn").replace(".tres", ".res")
	importer.convert_res_txt_2_bin(output_dir, txt_to_bin, dst_file)
	importer.convert_res_bin_2_txt(output_dir, output_dir.path_join(dst_file), dst_file.replace(".scn", ".tscn").replace(".res", ".tres"))

func dequote(arg):
	if arg.begins_with("\"") and arg.ends_with("\""):
		return arg.substr(1, arg.length() - 2)
	if arg.begins_with("'") and arg.ends_with("'"):
		return arg.substr(1, arg.length() - 2)
	return arg

func _on_re_editor_standalone_dropped_files(files: PackedStringArray):
	if files.size() == 0:
		return
	var new_files = []
	for file in files:
		new_files.append(dequote(file))
	$re_editor_standalone.pck_select_request(new_files)

func _on_re_editor_standalone_write_log_message(message):
	$log_window.text += message
	$log_window.scroll_to_line($log_window.get_line_count() - 1)

func register_dropped_files():
	pass
	var window = get_viewport()
	var err = window.files_dropped.connect(_on_re_editor_standalone_dropped_files)
	if err != OK:
		print("Error: failed to connect window to files_dropped signal")
		print("Type: " + self.get_class())
		print("name: " + str(self.get_name()))


var repo_url = "https://github.com/bruvzg/gdsdecomp"
var latest_release_url = "https://github.com/bruvzg/gdsdecomp/releases/latest"

func _on_version_lbl_pressed():
	OS.shell_open(repo_url)

func is_dev_version()-> bool:
	var version = GDRESettings.get_gdre_version()
	if "-dev" in version:
		return true
	return false

func check_version() -> bool:
	# check the version
	var http = HTTPRequest.new()
	# add it to the tree so it doesn't get deleted
	add_child(http)
	http.request_completed.connect(_on_version_check_completed)
	http.request("https://api.github.com/repos/bruvzg/gdsdecomp/releases/latest")
	return true
	
func is_new_version(new_version: String):
	var curr_version = GDRESettings.get_gdre_version()
	if curr_version == new_version:
		return false
	var curr_semver = SemVer.parse_semver(curr_version)
	var new_semver = SemVer.parse_semver(new_version)
	if curr_semver == null or new_semver == null:
		print("Error: invalid semver format")
		print("Current version: " + curr_version)
		print("New version: " + new_version)
		return false
	if new_semver.gt(curr_semver):
		return true
	return false


func _on_version_check_completed(_result, response_code, _headers, body):
	if response_code != 200:
		print("Error: failed to check for latest version")
		return
	var json = JSON.parse_string(body.get_string_from_utf8())
	var checked_version = json["tag_name"].strip_edges()
	var draft = json["draft"]
	var prerelease = json["prerelease"]
	var curr_version = GDRESettings.get_gdre_version()
	
	if draft or (prerelease and not ("-" in curr_version)) or not is_new_version(checked_version):
		return
	
	var update_str = "Update available! Click here! " + curr_version
	repo_url = latest_release_url
	$version_lbl.text = update_str
	print("New version of GDRE available: " + checked_version)
	print("Get it here: " + repo_url)

func _make_new_config():
	config = ConfigFile.new()
	set_showed_disclaimer(false)
	save_config()

func _load_config():
	config = ConfigFile.new()
	if config.load(CONFIG_PATH) != OK:
		_make_new_config()
	return true

func should_show_disclaimer():
	var curr_version = GDRESettings.get_gdre_version()
	var last_showed = config.get_value("General", "last_showed_disclaimer", "<NONE>")
	if last_showed == "<NONE>":
		return true
	if last_showed == curr_version:
		return false
	var curr_semver = SemVer.parse_semver(curr_version)
	var last_semver = SemVer.parse_semver(last_showed)
	if curr_semver == null or last_semver == null:
		return true
	return not (curr_semver.major == last_semver.major and curr_semver.minor == last_semver.minor)

func set_showed_disclaimer(setting: bool):
	var version = "<NONE>"
	if setting:
		version = GDRESettings.get_gdre_version()
	config.set_value("General", "last_showed_disclaimer", version)

func save_config():
	if config == null:
		return ERR_DOES_NOT_EXIST
	if GDRESettings.is_pack_loaded():
		return ERR_FILE_CANT_WRITE
	return config.save(CONFIG_PATH)

func handle_quit(save_cfg = true):
	if GDRESettings.is_pack_loaded():
		GDRESettings.unload_project()
	if save_cfg:
		var ret = save_config()
		if ret != OK and ret != ERR_DOES_NOT_EXIST:
			print("Couldn't save config file!")


func _ready():
	$version_lbl.text = GDRESettings.get_gdre_version()
	# If CLI arguments were passed in, just quit
	var args = get_sanitized_args()
	if handle_cli(args):
		get_tree().quit()
	else:
		_load_config()
		var show_disclaimer = should_show_disclaimer()
		show_disclaimer = show_disclaimer and len(args) == 0
		if show_disclaimer:
			set_showed_disclaimer(true)
			save_config()
		register_dropped_files()
		check_version()
		if show_disclaimer:
			$re_editor_standalone.show_about_dialog()
		if len(args) > 0:
			var window = get_viewport()
			window.emit_signal("files_dropped", args)

func _notification(what: int) -> void:
	if what == NOTIFICATION_EXIT_TREE:
		handle_quit()
	elif what == NOTIFICATION_WM_ABOUT:
		$re_editor_standalone.show_about_dialog()
	


func get_glob_files(glob: String) -> PackedStringArray:
	var files: PackedStringArray = Glob.rglob(glob)
	# doing this because non-windows platforms can have '?' and '[' in filenames
	if files.size() == 0 and FileAccess.file_exists(glob):
		files.append(glob)
	return files

func get_globs_files(globs: PackedStringArray) -> PackedStringArray:
	var files: PackedStringArray = []
	for glob in globs:
		files.append_array(get_glob_files(glob))
	return files

func get_arg_value(arg):
	var split_args = arg.split("=")
	if split_args.size() < 2:
		last_error = "Error: args have to be in the format of --key=value (with equals sign)"
		return ""
	return dequote(split_args[1])

func normalize_path(path: String):
	return path.replace("\\","/")

func test_decomp(fname):
	var decomp = GDScriptDecomp_ed80f45.new()
	var f = fname
	if f.get_extension() == "gdc":
		print("decompiling " + f)
		#
		#if decomp.decompile_byte_code(output_dir.path_join(f)) != OK: 
		if decomp.decompile_byte_code(f) != OK: 
			print("error decompiling " + f)
		else:
			var text = decomp.get_script_text()
			var gdfile:FileAccess = FileAccess.open(f.replace(".gdc",".gd"), FileAccess.WRITE)
			if gdfile == null:
				gdfile.store_string(text)
				gdfile.close()
				#da.remove(f)
				print("successfully decompiled " + f)
			else:
				print("error failed to save "+ f)

func export_imports(output_dir:String, files: PackedStringArray):
	var importer:ImportExporter = ImportExporter.new()
	importer.set_multi_thread(not disable_multi_threading)
	importer.export_imports(output_dir, files)
	importer.reset()
				
	
func dump_files(output_dir:String, files: PackedStringArray, ignore_checksum_errors: bool = false) -> int:
	var err:int = OK;
	var pckdump = PckDumper.new()
	# var start_time = Time.get_ticks_msec()
	pckdump.set_multi_thread(not disable_multi_threading)
	err = pckdump.check_md5_all_files()
	if err != OK:
		if (err != ERR_SKIP and not ignore_checksum_errors):
			print("MD5 checksum failed, not proceeding...")
			return err
		elif (ignore_checksum_errors):
			print("MD5 checksum failed, but --ignore_checksum_errors specified, proceeding anyway...")
	err = pckdump.pck_dump_to_dir(output_dir, files)
	if err != OK:
		print("error dumping to dir")
	# var end_time = Time.get_ticks_msec()
	# var secs_taken = (end_time - start_time) / 1000
	# print("Extraction complete in %02dm%02ds" % [(secs_taken) / 60, (secs_taken) % 60])
	return err;

var MAIN_COMMANDS = ["--recover", "--extract", "--compile", "--list-bytecode-versions"]
var MAIN_CMD_NOTES = """Main commands:
--recover=<GAME_PCK/EXE/APK/DIR>   Perform full project recovery on the specified PCK, APK, EXE, or extracted project directory.
--extract=<GAME_PCK/EXE/APK>       Extract the specified PCK, APK, or EXE.
--compile=<GD_FILE>                Compile GDScript files to bytecode (can be repeated and use globs, requires --bytecode)
--decompile=<GDC_FILE>             Decompile GDC files to text (can be repeated and use globs)
--list-bytecode-versions           List all available bytecode versions
--txt-to-bin=<FILE>                Convert text-based scene or resource files to binary format (can be repeated)
--bin-to-txt=<FILE>                Convert binary scene or resource files to text-based format (can be repeated)
"""

var GLOB_NOTES = """Notes on Include/Exclude globs:
	- Recursive patterns can be specified with '**'
		- Example: 'res://**/*.gdc' matches 'res://main.gdc', 'res://scripts/script.gdc', etc.)
	- Globs should be rooted to 'res://' or 'user://'
		- Example: 'res://*.gdc' will match all .gdc files in the root of the project, but not any of the subdirectories.
	- If not rooted, globs will be rooted to 'res://'
		- Example: 'addons/plugin/main.gdc' is equivalent to 'res://addons/plugin/main.gdc'
	- As a special case, if the glob has a wildcard and does contain a directory, it will be assumed to be a recursive pattern.
		- Example: '*.gdc' would be equivalent to 'res://**/*.gdc'
	- Include/Exclude globs will only match files that are actually in the project PCK/dir, not any non-present resource source files.
		Example: 
			- A project contains the file "res://main.gdc". 'res://main.gd' is the source file of 'res://main.gdc',
			  but is not included in the project PCK.
			- Performing project recovery with the include glob 'res://main.gd' would not recover 'main.gd'.
			- Performing project recovery with the include glob 'res://main.gdc' would recover 'res://main.gd'
"""

var RECOVER_OPTS_NOTES = """Recover/Extract Options:

--key=<KEY>                 The Key to use if project is encrypted as a 64-character hex string,
							e.g.: '000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F'
--output-dir=<DIR>          Output directory, defaults to <NAME_extracted>, or the project directory if one of specified
--scripts-only              Only extract/recover scripts
--include=<GLOB>            Include files matching the glob pattern (can be repeated)
--exclude=<GLOB>            Exclude files matching the glob pattern (can be repeated)
--ignore-checksum-errors    Ignore MD5 checksum errors when extracting/recovering
"""
# todo: handle --key option
var COMPILE_OPTS_NOTES = """Decompile/Compile Options:
--bytecode=<COMMIT_OR_VERSION>          Either the commit hash of the bytecode revision (e.g. 'f3f05dc'),
										   or the version of the engine (e.g. '4.3.0')
--output-dir=<DIR>                      Directory where compiled files will be output to. 
										  - If not specified, compiled files will be output to the same location 
										  (e.g. '<PROJ_DIR>/main.gd' -> '<PROJ_DIR>/main.gdc')
"""
func print_usage():
	print("Godot Reverse Engineering Tools")
	print("")
	print("Without any CLI options, the tool will start in GUI mode")
	print("\nGeneral options:")
	print("  -h, --help: Display this help message")
	print("\nFull Project Recovery options:")
	print("Usage: GDRE_Tools.exe --headless <main_command> [options]")
	print(MAIN_CMD_NOTES)
	print(RECOVER_OPTS_NOTES)
	print(GLOB_NOTES)
	print(COMPILE_OPTS_NOTES)


# TODO: remove this hack
var translation_only = false
var SCRIPTS_EXT = ["gd", "gdc", "gde"]
func copy_dir(src:String, dst:String) -> int:
	var da:DirAccess = DirAccess.open(src)
	if !da.dir_exists(src):
		print("Error: " + src + " does not appear to be a directory")
		return ERR_FILE_NOT_FOUND
	da.make_dir_recursive(dst)
	da.copy_dir(src, dst)
	return OK

func get_cli_abs_path(path:String) -> String:
	if path.is_absolute_path():
		return path
	var exec_path = GDRESettings.get_exec_dir()
	var abs_path = exec_path.path_join(path).simplify_path()
	return abs_path

func normalize_cludes(cludes: PackedStringArray, dir = "res://") -> PackedStringArray:
	var new_cludes: PackedStringArray = []
	if dir != dir.get_base_dir() and dir.ends_with("/"):
		dir = dir.substr(0, dir.length() - 1)
	for clude in cludes:
		clude = clude.replace("\\", "/")
		if not "**" in clude and "*" in clude and not "/" in clude:
			new_cludes.append("res://**/" + clude)
			# new_cludes.append("user://**/" + clude)
			continue
		if clude.begins_with("/") and dir == "res://":
			clude = clude.substr(1, clude.length() - 1)
		if not clude.is_absolute_path():
			clude = dir.path_join(clude)
		elif dir != "res://":
			clude = clude.replace("res:/", dir)
		elif clude.begins_with("/"):
			clude = dir + clude.substr(1, clude.length() - 1)
		new_cludes.append(clude.simplify_path())
	return new_cludes


func recovery(  input_files:PackedStringArray,
				output_dir:String,
				enc_key:String,
				extract_only: bool,
				ignore_checksum_errors: bool = false,
				excludes: PackedStringArray = [],
				includes: PackedStringArray = []):
	var _new_files = []
	for file in input_files:
		file = get_cli_abs_path(file)
		var _files = get_glob_files(file)
		if _files.size() > 0:
			_new_files.append_array(_files)
		else:
			print_usage()
			print("Error: failed to locate " + file)
			return
	print("Input files: ", str(_new_files))
	input_files = _new_files
	var input_file = input_files[0]
	var da:DirAccess
	var is_dir:bool = false
	var err: int = OK
	var parent_dir = "res://"
	# get the current time
	var start_time = Time.get_ticks_msec()
	if output_dir == "":
		output_dir = input_file.get_basename()
		if output_dir.get_extension():
			output_dir += "_recovery"
	else:
		output_dir = get_cli_abs_path(output_dir)

	da = DirAccess.open(input_file.get_base_dir())

	# check if da works
	if da == null:
		print_usage()
		print("Error: failed to locate parent dir for " + input_file)
		return
	#directory
	if da.dir_exists(input_file):
		if input_files.size() > 1:
			print_usage()
			print("Error: cannot specify multiple directories")
			return
		if input_file.get_extension().to_lower() == "app":
			is_dir = false
		elif !da.dir_exists(input_file.path_join(".import")) && !da.dir_exists(input_file.path_join(".godot")):
			print_usage()
			print("Error: " + input_file + " does not appear to be a project directory")
			return
		else:
			parent_dir = input_file
			is_dir = true
	#PCK/APK
	elif not da.file_exists(input_file):
		print_usage()
		print("Error: failed to locate " + input_file)
		return

	GDRESettings.open_log_file(output_dir)
	if (enc_key != ""):
		err = GDRESettings.set_encryption_key_string(enc_key)
		if (err != OK):
			print_usage()
			print("Error: failed to set key!")
			return
	
	err = GDRESettings.load_project(input_files, extract_only)
	if (err != OK):
		print_usage()
		print("Error: failed to open ", (input_files))
		return

	print("Successfully loaded PCK!") 
	ver_major = GDRESettings.get_ver_major()
	ver_minor = GDRESettings.get_ver_minor()
	var version:String = GDRESettings.get_version_string()
	print("Version: " + version)
	var files: PackedStringArray = []
	if translation_only and scripts_only:
		print("Error: cannot specify both --translation-only and --scripts-only")
		return
	elif ((translation_only or scripts_only) and (includes.size() > 0 or excludes.size() > 0)):
		print("Error: cannot specify both --translation-only or --scripts-only and --include or --exclude")
		return
	if (translation_only):
		var new_files:PackedStringArray = []
		# remove all the non ".translation" files
		for file in GDRESettings.get_file_list():
			if (file.get_extension().to_lower() == "translation"):
				new_files.append(file)
		files.append_array(new_files)
		print("Translation only mode, only extracting translation files")
	elif scripts_only:
		var new_files:PackedStringArray = []
		# remove all the non ".gd" files
		for file in GDRESettings.get_file_list():
			if (file.get_extension().to_lower() in SCRIPTS_EXT):
				new_files.append(file)
		files.append_array(new_files)
		print("Scripts only mode, only extracting scripts")
	else:
		if includes.size() > 0:
			includes = normalize_cludes(includes, parent_dir)
			files = get_globs_files(includes)
			if len(files) == 0:
				print("Error: no files found that match includes")
				print("Includes: " + str(includes))
				print(GLOB_NOTES)
				return
		else:
			files = GDRESettings.get_file_list()
		if excludes.size() > 0:
			excludes = normalize_cludes(excludes, parent_dir)
			var result = Glob.fnmatch_list(files, excludes)
			for file in result:
				files.remove_at(files.rfind(file))

		if (includes.size() > 0 or excludes.size() > 0) and files.size() == 0:
			print("Error: no files to extract after filtering")
			if len(includes) > 0:
				print("Includes: " + str(includes))
			if len(excludes) > 0:
				print("Excludes: " + str(excludes))
			print(GLOB_NOTES)
			return

	if output_dir != input_file and not is_dir: 
		if (da.file_exists(output_dir)):
			print("Error: output dir appears to be a file, not extracting...")
			return
	if is_dir:
		if extract_only:
			print("Why did you open a folder to extract it??? What's wrong with you?!!?")
			return
		if copy_dir(input_file, output_dir) != OK:
			print("Error: failed to copy " + input_file + " to " + output_dir)
			return
	else:
		err = dump_files(output_dir, files, ignore_checksum_errors)
		if (err != OK):
			print("Error: failed to extract PAK file, not exporting assets")
			return
	var end_time;
	var secs_taken;
	if (extract_only):
		end_time = Time.get_ticks_msec()
		secs_taken = (end_time - start_time) / 1000
		print("Extraction operation complete in %02dm%02ds" % [(secs_taken) / 60, (secs_taken) % 60])
		return
	export_imports(output_dir, files)
	end_time = Time.get_ticks_msec()
	secs_taken = (end_time - start_time) / 1000
	print("Recovery complete in %02dm%02ds" % [(secs_taken) / 60, (secs_taken) % 60])


func print_version():
	print("Godot RE Tools " + GDRESettings.get_gdre_version())

func close_log():
	var path = GDRESettings.get_log_file_path()
	if path == "":
		return
	GDRESettings.close_log_file()
	print("Log file written to: " + path)
	print("Please include this file when reporting issues!")

func ensure_dir_exists(dir: String):
	var da:DirAccess = DirAccess.open(GDRESettings.get_exec_dir())
	if !da.dir_exists(dir):
		da.make_dir_recursive(dir)

func get_decomp(bytecode_version: String) -> GDScriptDecomp:
	var decomp: GDScriptDecomp = null
	if '.' in bytecode_version:
		decomp = GDScriptDecomp.create_decomp_for_version(bytecode_version)
	else:
		decomp = GDScriptDecomp.create_decomp_for_commit(bytecode_version.hex_to_int())
	if decomp == null:
		print("Error: failed to create decompiler for commit " + bytecode_version + "!\n(run --list-bytecode-versions to see available versions)")
	return decomp

func compile(files: PackedStringArray, bytecode_version: String, output_dir: String):
	# TODO: handle key
	if output_dir == "":
		output_dir = get_cli_abs_path(".") # default to current directory
	if bytecode_version == "":
		print("Error: --bytecode is required for --compile (use --list-bytecode-versions to see available versions)")
		print(COMPILE_OPTS_NOTES)
		return -1
	var decomp: GDScriptDecomp = get_decomp(bytecode_version)
	if decomp == null:
		return -1
	print("Compiling to bytecode version %x (%s)" % [decomp.get_bytecode_rev(), decomp.get_engine_version()])

	var new_files = get_globs_files(files)
	if new_files.size() == 0:
		print("Error: no files found to compile")
		return -1
	ensure_dir_exists(output_dir)
	for file in new_files:
		print("Compiling " + file)
		if file.get_extension() != "gd":
			print("Error: " + file + " is not a GDScript file")
			continue
		var f = FileAccess.open(file, FileAccess.READ)
		var code = f.get_as_text()
		var bytecode: PackedByteArray = decomp.compile_code_string(code)
		if bytecode.is_empty():
			print("Error: failed to compile " + file)
			print(decomp.get_error_message())
			continue
		var out_file = output_dir.path_join(file.get_file().replace(".gd", ".gdc"))
		var out_f = FileAccess.open(out_file, FileAccess.WRITE)
		out_f.store_buffer(bytecode)
		out_f.close()
		print("Compiled " + file + " to " + out_file)		
	print("Compilation complete")
	return 0

func decompile(files: PackedStringArray, bytecode_version: String, output_dir: String, key: String = ""):
	if output_dir == "":
		output_dir = get_cli_abs_path(".") # default to current directory
	if bytecode_version == "":
		print("Error: --bytecode is required for --decompile (use --list-bytecode-versions to see available versions)")
		print(COMPILE_OPTS_NOTES)
		return -1
	var decomp: GDScriptDecomp = get_decomp(bytecode_version)
	if decomp == null:
		return -1
	print("Decompiling from bytecode version %x (%s)" % [decomp.get_bytecode_rev(), decomp.get_engine_version()])
	var new_files = get_globs_files(files)
	if new_files.size() == 0:
		print("Error: no files found to decompile")
		return -1
	ensure_dir_exists(output_dir)

	var err = OK
	if key != "":
		err = GDRESettings.set_encryption_key_string(key)
		if err != OK:
			print("Error: failed to set key!")
			return -1
	for file in new_files:
		var src_ext = file.get_extension().to_lower()
		
		if src_ext != "gdc" and src_ext != "gde":
			print("Error: " + file + " is not a GDScript bytecode file")
			continue
		print("Decompiling " + file)
		err = decomp.decompile_byte_code(file)
		var out_file = file.get_basename() + ".gd"
		if output_dir:
			out_file = output_dir.path_join(out_file.get_file())
		print("Output file: " + out_file)

		if err != OK:
			print("Error: failed to decompile " + file)
			print(decomp.get_error_message())
			continue
		var text = decomp.get_script_text()
		var out_f = FileAccess.open(out_file, FileAccess.WRITE)
		if out_f == null:
			print("Error: failed to open " + out_file + " for writing")
			continue
		out_f.store_string(text)
		out_f.close()
		print("Decompiled " + file + " to " + out_file)		
	print("Decompilation complete")
	return 0

func get_sanitized_args():
	var args = OS.get_cmdline_args()
	#var scene_path = get_tree().root.scene_file_path
	var scene_path = "res://gdre_main.tscn"
	if args.size() > 0 and args[0] == scene_path:
		return args.slice(1)
	return args

func text_to_bin(files: PackedStringArray, output_dir: String):
	var importer:ImportExporter = ImportExporter.new()
	for file in files:
		file = get_cli_abs_path(file)
		var dst_file = file.get_file().replace(".tscn", ".scn").replace(".tres", ".res")
		importer.convert_res_txt_2_bin(output_dir, file, dst_file)

func bin_to_text(files: PackedStringArray, output_dir: String):
	var importer:ImportExporter = ImportExporter.new()
	for file in files:
		file = get_cli_abs_path(file)
		var dst_file = file.get_file().replace(".scn", ".tscn").replace(".res", ".tres")
		importer.convert_res_bin_2_txt(output_dir, file, dst_file)

func handle_cli(args: PackedStringArray) -> bool:
	var input_extract_file:PackedStringArray = []
	var input_file:PackedStringArray = []
	var output_dir: String = ""
	var enc_key: String = ""
	var txt_to_bin = PackedStringArray()
	var bin_to_txt = PackedStringArray()
	var ignore_md5: bool = false
	var decompile_files = PackedStringArray()
	var compile_files = PackedStringArray()
	var bytecode_version: String = ""
	var main_cmds = {}
	var excludes: PackedStringArray = []
	var includes: PackedStringArray = []
	if (args.size() == 0):
		return false
	var any_commands = false
	for i in range(args.size()):
		var arg:String = args[i]
		if arg.begins_with("--"):
			any_commands = true
			break
	if any_commands == false:
		if not GDRESettings.is_headless():
			# not cli mode, drag-and-drop
			return false
		print_usage()
		print("ERROR: no command specified")
		return true
	for i in range(args.size()):
		var arg:String = args[i]
		if arg == "--help":
			print_version()
			print_usage()
			return true
		elif arg.begins_with("--version"):
			print_version()
			return true
		elif arg.begins_with("--extract"):
			input_extract_file.append(get_arg_value(arg).simplify_path())
			main_cmds["extract"] = true
		elif arg.begins_with("--recover"):
			input_file.append(get_arg_value(arg).simplify_path())
			main_cmds["recover"] = true
		elif arg.begins_with("--txt-to-bin"):
			txt_to_bin.append(get_arg_value(arg).simplify_path())
			main_cmds["txt-to-bin"] = true
		elif arg.begins_with("--bin-to-txt"):
			bin_to_txt.append(get_arg_value(arg).simplify_path())
			main_cmds["bin-to-txt"] = true
		elif arg.begins_with("--output-dir"):
			output_dir = get_arg_value(arg).simplify_path()
		elif arg.begins_with("--scripts-only"):
			scripts_only = true
		elif arg.begins_with("--key"):
			enc_key = get_arg_value(arg)
		elif arg.begins_with("--ignore-checksum-errors"):
			ignore_md5 = true
		elif arg.begins_with("--translation-only"):
			translation_only = true
		elif arg.begins_with("--disable-multithreading"):
			disable_multi_threading = true
		elif arg.begins_with("--list-bytecode-versions"):
			var versions = GDScriptDecomp.get_bytecode_versions()
			print("\n--- Available bytecode versions:")
			for version in versions:
				print(version)
			return true
		elif arg.begins_with("--bytecode"):
			bytecode_version = get_arg_value(arg)
		elif arg.begins_with("--decompile"):
			main_cmds["decompile"] = true
			decompile_files.append(get_arg_value(arg))
		elif arg.begins_with("--compile"):
			main_cmds["compile"] = true
			compile_files.append(get_arg_value(arg))
		elif arg.begins_with("--exclude"):
			excludes.append(get_arg_value(arg))
		elif arg.begins_with("--include"):
			includes.append(get_arg_value(arg))
		else:
			print_usage()
			print("ERROR: invalid option '" + arg + "'")
			return true
		if last_error != "":
			print_usage()
			print(last_error)
			return true
	if main_cmds.size() > 1:
		print_usage()
		print("ERROR: invalid option! Must specify only one of " + ", ".join(MAIN_COMMANDS))
		return true
	if compile_files.size() > 0:
		compile(compile_files, bytecode_version, output_dir)
	elif decompile_files.size() > 0:
		decompile(decompile_files, bytecode_version, output_dir, enc_key)
	elif not input_file.is_empty():
		recovery(input_file, output_dir, enc_key, false, ignore_md5, excludes, includes)
		GDRESettings.unload_project()
		close_log()
	elif not input_extract_file.is_empty():
		recovery(input_extract_file, output_dir, enc_key, true, ignore_md5, excludes, includes)
		GDRESettings.unload_project()
		close_log()
	elif txt_to_bin.is_empty() == false:
		text_to_bin(txt_to_bin, output_dir)
	elif bin_to_txt.is_empty() == false:
		bin_to_text(bin_to_txt, output_dir)
	else:
		print_usage()
		print("ERROR: invalid option! Must specify one of " + ", ".join(MAIN_COMMANDS))
	return true
            [gd_scene load_steps=3 format=3 uid="uid://el6o5uk15g2c"]

[ext_resource type="Theme" uid="uid://crq1fwn0ajw7b" path="res://gdre_theme.tres" id="1"]
[ext_resource type="Script" path="res://gdre_main.gd" id="2"]

[node name="root" type="Control"]
layout_mode = 3
anchors_preset = 15
anchor_right = 1.0
anchor_bottom = 1.0
offset_top = 32.0
grow_horizontal = 2
grow_vertical = 2
theme = ExtResource("1")
script = ExtResource("2")

[node name="log_window" type="RichTextLabel" parent="."]
z_index = -1
layout_mode = 1
anchors_preset = 15
anchor_right = 1.0
anchor_bottom = 1.0
grow_horizontal = 2
grow_vertical = 2
focus_mode = 2
theme_override_colors/default_color = Color(0.470588, 0.45098, 0.45098, 1)
theme_override_constants/line_separation = 5
scroll_following = true
selection_enabled = true

[node name="menu_background" type="Panel" parent="."]
layout_mode = 1
anchors_preset = 10
anchor_right = 1.0
offset_top = -32.0
grow_horizontal = 2

[node name="re_editor_standalone" type="GodotREEditorStandalone" parent="."]
layout_mode = 1
anchors_preset = 10
anchor_right = 1.0
offset_top = -32.0
grow_horizontal = 2

[node name="version_lbl" type="Button" parent="."]
layout_mode = 1
anchors_preset = -1
anchor_left = 1.0
anchor_right = 1.0
offset_left = -40.0
offset_top = -30.768
offset_bottom = 0.232
grow_horizontal = 0
grow_vertical = 0
mouse_filter = 1
text = "$$$"
flat = true

[connection signal="write_log_message" from="re_editor_standalone" to="." method="_on_re_editor_standalone_write_log_message"]
[connection signal="pressed" from="version_lbl" to="." method="_on_version_lbl_pressed"]
  [gd_resource type="Theme" load_steps=164 format=3 uid="uid://crq1fwn0ajw7b"]

[sub_resource type="StyleBoxFlat" id="1"]
content_margin_left = 6.0
content_margin_top = 4.0
content_margin_right = 6.0
content_margin_bottom = 4.0
bg_color = Color(0.176471, 0.208235, 0.278824, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.137255, 0.161961, 0.216863, 1)

[sub_resource type="StyleBoxFlat" id="2"]
content_margin_left = 6.0
content_margin_top = 4.0
content_margin_right = 6.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.411765, 0.611765, 0.909804, 1)

[sub_resource type="StyleBoxFlat" id="3"]
content_margin_left = 6.0
content_margin_top = 4.0
content_margin_right = 6.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.397059, 0.423529, 0.482353, 1)

[sub_resource type="StyleBoxFlat" id="4"]
content_margin_left = 6.0
content_margin_top = 4.0
content_margin_right = 6.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.122549, 0.144608, 0.193627, 1)

[sub_resource type="StyleBoxFlat" id="5"]
content_margin_left = 6.0
content_margin_top = 4.0
content_margin_right = 6.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.411765, 0.611765, 0.909804, 1)

[sub_resource type="Image" id="Image_qm34x"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 107, 107, 107, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 107, 107, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 163, 163, 8, 218, 218, 218, 37, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 218, 218, 218, 37, 163, 163, 163, 8, 0, 0, 0, 0, 108, 108, 108, 0, 219, 219, 219, 37, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 219, 219, 219, 37, 108, 108, 108, 0, 111, 111, 111, 0, 222, 222, 222, 46, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 60, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 46, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 106, 224, 224, 224, 244, 221, 221, 221, 106, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 106, 224, 224, 224, 249, 224, 224, 224, 255, 222, 222, 222, 187, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 105, 224, 224, 224, 249, 224, 224, 224, 255, 223, 223, 223, 194, 221, 221, 221, 53, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 49, 222, 222, 222, 68, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 104, 224, 224, 224, 248, 224, 224, 224, 255, 223, 223, 223, 194, 222, 222, 222, 53, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 221, 221, 221, 49, 222, 222, 222, 179, 224, 224, 224, 231, 222, 222, 222, 76, 222, 222, 222, 104, 224, 224, 224, 248, 224, 224, 224, 255, 223, 223, 223, 195, 222, 222, 222, 53, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 65, 223, 223, 223, 226, 224, 224, 224, 255, 223, 223, 223, 235, 224, 224, 224, 248, 224, 224, 224, 255, 223, 223, 223, 196, 222, 222, 222, 53, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 70, 224, 224, 224, 225, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 196, 222, 222, 222, 53, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 69, 223, 223, 223, 225, 222, 222, 222, 197, 222, 222, 222, 53, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 46, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 66, 222, 222, 222, 54, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 46, 111, 111, 111, 0, 108, 108, 108, 0, 219, 219, 219, 37, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 219, 219, 219, 37, 108, 108, 108, 0, 0, 0, 0, 0, 163, 163, 163, 8, 218, 218, 218, 37, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 218, 218, 218, 37, 163, 163, 163, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 107, 107, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 107, 107, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="7"]
image = SubResource("Image_qm34x")

[sub_resource type="Image" id="Image_wkhdc"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 110, 110, 110, 0, 111, 111, 111, 0, 111, 111, 111, 0, 110, 110, 110, 0, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 0, 164, 164, 164, 4, 222, 222, 222, 24, 221, 221, 221, 38, 222, 222, 222, 45, 222, 222, 222, 45, 221, 221, 221, 38, 222, 222, 222, 24, 164, 164, 164, 4, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 52, 52, 0, 209, 209, 209, 15, 221, 221, 221, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 44, 209, 209, 209, 15, 52, 52, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 0, 209, 209, 209, 15, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 209, 209, 209, 15, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 164, 164, 4, 221, 221, 221, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 69, 222, 222, 222, 182, 224, 224, 224, 234, 224, 224, 224, 234, 222, 222, 222, 182, 222, 222, 222, 69, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 44, 164, 164, 164, 4, 0, 0, 0, 0, 56, 56, 56, 0, 222, 222, 222, 24, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 69, 224, 224, 224, 239, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 239, 221, 221, 221, 69, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 24, 56, 56, 56, 0, 110, 110, 110, 0, 221, 221, 221, 38, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 180, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 222, 222, 222, 180, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 38, 110, 110, 110, 0, 111, 111, 111, 0, 222, 222, 222, 44, 222, 222, 222, 47, 222, 222, 222, 47, 223, 223, 223, 232, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 232, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 44, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 44, 222, 222, 222, 47, 222, 222, 222, 47, 224, 224, 224, 234, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 233, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 44, 111, 111, 111, 0, 110, 110, 110, 0, 221, 221, 221, 38, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 182, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 222, 222, 222, 182, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 38, 110, 110, 110, 0, 56, 56, 56, 0, 222, 222, 222, 24, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 69, 224, 224, 224, 240, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 240, 221, 221, 221, 69, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 24, 56, 56, 56, 0, 0, 0, 0, 0, 164, 164, 164, 4, 221, 221, 221, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 69, 222, 222, 222, 182, 224, 224, 224, 234, 224, 224, 224, 234, 222, 222, 222, 182, 222, 222, 222, 69, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 44, 164, 164, 164, 4, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 0, 209, 209, 209, 15, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 209, 209, 209, 15, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 52, 52, 0, 209, 209, 209, 15, 221, 221, 221, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 44, 209, 209, 209, 15, 52, 52, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 0, 166, 166, 166, 4, 222, 222, 222, 24, 221, 221, 221, 38, 222, 222, 222, 45, 222, 222, 222, 45, 221, 221, 221, 38, 222, 222, 222, 24, 164, 164, 164, 4, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 110, 110, 110, 0, 111, 111, 111, 0, 111, 111, 111, 0, 110, 110, 110, 0, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="9"]
image = SubResource("Image_wkhdc")

[sub_resource type="Image" id="Image_l0g3i"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 110, 110, 110, 0, 111, 111, 111, 0, 111, 111, 111, 0, 110, 110, 110, 0, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 0, 164, 164, 164, 4, 222, 222, 222, 24, 221, 221, 221, 38, 222, 222, 222, 45, 222, 222, 222, 45, 221, 221, 221, 38, 222, 222, 222, 24, 164, 164, 164, 4, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 52, 52, 0, 209, 209, 209, 15, 221, 221, 221, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 44, 209, 209, 209, 15, 52, 52, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 0, 209, 209, 209, 15, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 209, 209, 209, 15, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 164, 164, 4, 221, 221, 221, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 44, 164, 164, 164, 4, 0, 0, 0, 0, 56, 56, 56, 0, 222, 222, 222, 24, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 24, 56, 56, 56, 0, 110, 110, 110, 0, 221, 221, 221, 38, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 38, 110, 110, 110, 0, 111, 111, 111, 0, 222, 222, 222, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 44, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 44, 111, 111, 111, 0, 110, 110, 110, 0, 221, 221, 221, 38, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 38, 110, 110, 110, 0, 56, 56, 56, 0, 222, 222, 222, 24, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 24, 56, 56, 56, 0, 0, 0, 0, 0, 164, 164, 164, 4, 221, 221, 221, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 44, 164, 164, 164, 4, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 0, 209, 209, 209, 15, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 209, 209, 209, 15, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 52, 52, 0, 209, 209, 209, 15, 221, 221, 221, 44, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 221, 221, 221, 44, 209, 209, 209, 15, 52, 52, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 0, 166, 166, 166, 4, 222, 222, 222, 24, 221, 221, 221, 38, 222, 222, 222, 45, 222, 222, 222, 45, 221, 221, 221, 38, 222, 222, 222, 24, 164, 164, 164, 4, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 110, 110, 110, 0, 111, 111, 111, 0, 111, 111, 111, 0, 110, 110, 110, 0, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="11"]
image = SubResource("Image_l0g3i")

[sub_resource type="Image" id="Image_b4rug"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 107, 107, 107, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 107, 107, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 163, 163, 8, 218, 218, 218, 37, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 218, 218, 218, 37, 163, 163, 163, 8, 0, 0, 0, 0, 108, 108, 108, 0, 219, 219, 219, 37, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 219, 219, 219, 37, 108, 108, 108, 0, 111, 111, 111, 0, 222, 222, 222, 46, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 46, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 46, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 46, 111, 111, 111, 0, 108, 108, 108, 0, 219, 219, 219, 37, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 219, 219, 219, 37, 108, 108, 108, 0, 0, 0, 0, 0, 163, 163, 163, 8, 218, 218, 218, 37, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 222, 222, 222, 47, 218, 218, 218, 37, 163, 163, 163, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 107, 107, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 107, 107, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="13"]
image = SubResource("Image_b4rug")

[sub_resource type="StyleBoxFlat" id="14"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
draw_center = false
border_color = Color(0.122549, 0.144608, 0.193627, 1)

[sub_resource type="Image" id="Image_35v15"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 110, 110, 0, 221, 221, 221, 22, 219, 219, 219, 84, 222, 222, 222, 143, 222, 222, 222, 169, 222, 222, 222, 189, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 189, 222, 222, 222, 169, 222, 222, 222, 143, 219, 219, 219, 84, 221, 221, 221, 22, 110, 110, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 27, 27, 0, 111, 111, 111, 20, 221, 221, 221, 120, 222, 222, 222, 196, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 196, 221, 221, 221, 120, 111, 111, 111, 20, 27, 27, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 219, 219, 219, 60, 222, 222, 222, 189, 222, 222, 222, 199, 222, 222, 222, 194, 221, 221, 221, 130, 222, 222, 222, 69, 222, 222, 222, 29, 167, 167, 167, 10, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 167, 167, 167, 10, 222, 222, 222, 29, 222, 222, 222, 69, 221, 221, 221, 130, 222, 222, 222, 194, 222, 222, 222, 199, 222, 222, 222, 189, 219, 219, 219, 60, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 222, 222, 222, 85, 222, 222, 222, 197, 222, 222, 222, 199, 221, 221, 221, 132, 219, 219, 219, 25, 110, 110, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 110, 110, 0, 219, 219, 219, 25, 221, 221, 221, 132, 222, 222, 222, 199, 222, 222, 222, 197, 222, 222, 222, 85, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 0, 219, 219, 219, 59, 222, 222, 222, 197, 222, 222, 222, 196, 223, 223, 223, 85, 109, 109, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 109, 109, 0, 223, 223, 223, 86, 222, 222, 222, 196, 222, 222, 222, 197, 219, 219, 219, 59, 48, 48, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196, 196, 196, 20, 222, 222, 222, 188, 222, 222, 222, 199, 223, 223, 223, 85, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 223, 223, 223, 85, 222, 222, 222, 199, 222, 222, 222, 188, 196, 196, 196, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 109, 109, 0, 221, 221, 221, 120, 222, 222, 222, 199, 221, 221, 221, 131, 109, 109, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 109, 109, 109, 0, 221, 221, 221, 131, 222, 222, 222, 199, 221, 221, 221, 120, 109, 109, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 218, 218, 21, 222, 222, 222, 196, 222, 222, 222, 194, 219, 219, 219, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 139, 139, 139, 47, 222, 222, 222, 148, 222, 222, 222, 189, 222, 222, 222, 189, 222, 222, 222, 148, 139, 139, 139, 47, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 140, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 140, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 140, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 140, 111, 111, 111, 0, 0, 0, 0, 0, 219, 219, 219, 25, 222, 222, 222, 194, 222, 222, 222, 196, 218, 218, 218, 21, 0, 0, 0, 0, 51, 51, 51, 0, 216, 216, 216, 82, 222, 222, 222, 199, 221, 221, 221, 129, 109, 109, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 222, 222, 222, 93, 222, 222, 222, 197, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 197, 222, 222, 222, 93, 55, 55, 55, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 139, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 139, 111, 111, 111, 0, 0, 0, 0, 0, 110, 110, 110, 0, 221, 221, 221, 130, 222, 222, 222, 199, 216, 216, 216, 82, 51, 51, 51, 0, 111, 111, 111, 0, 222, 222, 222, 140, 222, 222, 222, 199, 222, 222, 222, 68, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 0, 185, 185, 185, 46, 222, 222, 222, 197, 222, 222, 222, 193, 223, 223, 223, 90, 216, 216, 216, 19, 216, 216, 216, 19, 223, 223, 223, 90, 222, 222, 222, 193, 222, 222, 222, 197, 185, 185, 185, 46, 32, 32, 32, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 167, 167, 167, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 167, 167, 167, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 222, 222, 68, 222, 222, 222, 199, 223, 223, 223, 140, 112, 112, 112, 0, 111, 111, 111, 0, 222, 222, 222, 167, 222, 222, 222, 199, 221, 221, 221, 28, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 146, 222, 222, 222, 199, 222, 222, 222, 90, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 223, 223, 223, 91, 222, 222, 222, 199, 222, 222, 222, 146, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 167, 167, 167, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 167, 167, 167, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 221, 221, 28, 222, 222, 222, 199, 222, 222, 222, 167, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 186, 222, 222, 222, 199, 218, 218, 218, 9, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 188, 222, 222, 222, 199, 217, 217, 217, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 217, 217, 19, 222, 222, 222, 199, 222, 222, 222, 188, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 140, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 140, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 218, 218, 9, 222, 222, 222, 199, 222, 222, 222, 186, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 188, 222, 222, 222, 199, 218, 218, 218, 9, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 188, 222, 222, 222, 199, 218, 218, 218, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 217, 217, 19, 222, 222, 222, 199, 222, 222, 222, 188, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 139, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 139, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 218, 218, 9, 222, 222, 222, 199, 222, 222, 222, 188, 111, 111, 111, 0, 112, 112, 112, 0, 223, 223, 223, 169, 222, 222, 222, 199, 221, 221, 221, 28, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 147, 222, 222, 222, 199, 223, 223, 223, 90, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 223, 223, 223, 91, 222, 222, 222, 199, 222, 222, 222, 147, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 167, 167, 167, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 167, 167, 167, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 221, 221, 28, 222, 222, 222, 199, 223, 223, 223, 169, 112, 112, 112, 0, 110, 110, 110, 0, 221, 221, 221, 141, 222, 222, 222, 199, 222, 222, 222, 68, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 0, 185, 185, 185, 46, 222, 222, 222, 197, 222, 222, 222, 194, 223, 223, 223, 91, 219, 219, 219, 20, 219, 219, 219, 20, 223, 223, 223, 91, 222, 222, 222, 194, 222, 222, 222, 197, 185, 185, 185, 46, 32, 32, 32, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 222, 222, 68, 222, 222, 222, 199, 221, 221, 221, 141, 110, 110, 110, 0, 55, 55, 55, 0, 221, 221, 221, 83, 222, 222, 222, 199, 221, 221, 221, 130, 109, 109, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 222, 222, 222, 93, 222, 222, 222, 197, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 197, 222, 222, 222, 93, 55, 55, 55, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 110, 110, 0, 221, 221, 221, 130, 222, 222, 222, 199, 221, 221, 221, 83, 55, 55, 55, 0, 0, 0, 0, 0, 221, 221, 221, 22, 222, 222, 222, 196, 222, 222, 222, 194, 216, 216, 216, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 138, 138, 138, 46, 222, 222, 222, 147, 222, 222, 222, 189, 222, 222, 222, 189, 222, 222, 222, 147, 138, 138, 138, 46, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 139, 222, 222, 222, 139, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 139, 222, 222, 222, 139, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 219, 219, 24, 222, 222, 222, 194, 222, 222, 222, 196, 221, 221, 221, 22, 0, 0, 0, 0, 0, 0, 0, 0, 110, 110, 110, 0, 221, 221, 221, 120, 222, 222, 222, 199, 220, 220, 220, 130, 109, 109, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 109, 109, 0, 220, 220, 220, 130, 222, 222, 222, 199, 221, 221, 221, 120, 110, 110, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196, 196, 196, 20, 222, 222, 222, 188, 222, 222, 222, 199, 223, 223, 223, 85, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 223, 223, 223, 85, 222, 222, 222, 199, 222, 222, 222, 188, 174, 174, 174, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 0, 219, 219, 219, 61, 222, 222, 222, 198, 222, 222, 222, 196, 223, 223, 223, 85, 109, 109, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 109, 109, 0, 223, 223, 223, 85, 222, 222, 222, 196, 222, 222, 222, 198, 219, 219, 219, 61, 43, 43, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 222, 222, 222, 86, 222, 222, 222, 197, 222, 222, 222, 199, 221, 221, 221, 131, 219, 219, 219, 25, 110, 110, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 110, 110, 0, 219, 219, 219, 25, 221, 221, 221, 131, 222, 222, 222, 199, 222, 222, 222, 197, 222, 222, 222, 85, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 219, 219, 219, 60, 222, 222, 222, 189, 222, 222, 222, 199, 222, 222, 222, 194, 221, 221, 221, 130, 222, 222, 222, 69, 222, 222, 222, 29, 167, 167, 167, 10, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 167, 167, 167, 10, 222, 222, 222, 29, 222, 222, 222, 69, 221, 221, 221, 130, 222, 222, 222, 194, 222, 222, 222, 199, 222, 222, 222, 189, 219, 219, 219, 60, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 27, 27, 0, 111, 111, 111, 20, 223, 223, 223, 120, 222, 222, 222, 196, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 196, 223, 223, 223, 120, 111, 111, 111, 20, 27, 27, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 22, 219, 219, 219, 84, 222, 222, 222, 143, 222, 222, 222, 169, 222, 222, 222, 189, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 189, 222, 222, 222, 169, 222, 222, 222, 143, 219, 219, 219, 84, 221, 221, 221, 22, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 26,
"mipmaps": false,
"width": 42
}

[sub_resource type="ImageTexture" id="16"]
image = SubResource("Image_35v15")

[sub_resource type="Image" id="Image_e2oel"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 110, 110, 0, 221, 221, 221, 22, 219, 219, 219, 84, 222, 222, 222, 143, 222, 222, 222, 169, 222, 222, 222, 189, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 189, 222, 222, 222, 169, 222, 222, 222, 143, 219, 219, 219, 84, 221, 221, 221, 22, 110, 110, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 27, 27, 0, 111, 111, 111, 20, 221, 221, 221, 120, 222, 222, 222, 196, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 196, 221, 221, 221, 120, 111, 111, 111, 20, 27, 27, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 219, 219, 219, 60, 222, 222, 222, 189, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 189, 219, 219, 219, 60, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 222, 222, 222, 85, 222, 222, 222, 197, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 197, 222, 222, 222, 85, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 0, 219, 219, 219, 59, 222, 222, 222, 197, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 197, 219, 219, 219, 59, 48, 48, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196, 196, 196, 20, 222, 222, 222, 188, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 188, 196, 196, 196, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 109, 109, 0, 221, 221, 221, 120, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 120, 109, 109, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 218, 218, 21, 222, 222, 222, 196, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 151, 221, 221, 221, 50, 166, 166, 166, 10, 166, 166, 166, 10, 221, 221, 221, 50, 223, 223, 223, 151, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 51, 209, 209, 209, 42, 222, 222, 222, 186, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 57, 222, 222, 222, 57, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 196, 218, 218, 218, 21, 0, 0, 0, 0, 51, 51, 51, 0, 216, 216, 216, 82, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 104, 160, 160, 160, 2, 56, 56, 56, 0, 112, 112, 112, 0, 112, 112, 112, 0, 56, 56, 56, 0, 160, 160, 160, 2, 222, 222, 222, 104, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 50, 50, 50, 0, 218, 218, 218, 50, 222, 222, 222, 194, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 216, 216, 216, 82, 51, 51, 51, 0, 111, 111, 111, 0, 222, 222, 222, 140, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 151, 155, 155, 155, 1, 164, 164, 164, 5, 223, 223, 223, 107, 223, 223, 223, 179, 223, 223, 223, 179, 223, 223, 223, 107, 164, 164, 164, 5, 155, 155, 155, 1, 221, 221, 221, 151, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 0, 0, 0, 0, 55, 55, 55, 0, 222, 222, 222, 71, 222, 222, 222, 198, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 140, 112, 112, 112, 0, 111, 111, 111, 0, 222, 222, 222, 167, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 50, 55, 55, 55, 0, 222, 222, 222, 106, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 106, 55, 55, 55, 0, 222, 222, 222, 50, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 55, 55, 55, 0, 166, 166, 166, 10, 56, 56, 56, 0, 222, 222, 222, 96, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 167, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 186, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 218, 218, 218, 9, 111, 111, 111, 0, 222, 222, 222, 177, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 177, 111, 111, 111, 0, 218, 218, 218, 9, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 142, 157, 157, 157, 3, 104, 104, 104, 0, 215, 215, 215, 120, 222, 222, 222, 199, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 186, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 188, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 218, 218, 218, 9, 111, 111, 111, 0, 222, 222, 222, 178, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 177, 111, 111, 111, 0, 218, 218, 218, 9, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 215, 215, 215, 120, 103, 103, 103, 0, 159, 159, 159, 3, 222, 222, 222, 142, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 188, 111, 111, 111, 0, 112, 112, 112, 0, 223, 223, 223, 169, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 50, 56, 56, 56, 0, 222, 222, 222, 106, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 106, 55, 55, 55, 0, 221, 221, 221, 50, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 95, 56, 56, 56, 0, 166, 166, 166, 10, 56, 56, 56, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 169, 112, 112, 112, 0, 110, 110, 110, 0, 221, 221, 221, 141, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 151, 155, 155, 155, 1, 162, 162, 162, 5, 223, 223, 223, 107, 223, 223, 223, 178, 223, 223, 223, 178, 223, 223, 223, 107, 162, 162, 162, 5, 155, 155, 155, 1, 221, 221, 221, 151, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 198, 222, 222, 222, 70, 55, 55, 55, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 141, 110, 110, 110, 0, 55, 55, 55, 0, 221, 221, 221, 83, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 104, 164, 164, 164, 2, 56, 56, 56, 0, 112, 112, 112, 0, 112, 112, 112, 0, 56, 56, 56, 0, 164, 164, 164, 2, 222, 222, 222, 104, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 194, 217, 217, 217, 49, 50, 50, 50, 0, 111, 111, 111, 0, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 83, 55, 55, 55, 0, 0, 0, 0, 0, 221, 221, 221, 22, 222, 222, 222, 196, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 151, 221, 221, 221, 51, 167, 167, 167, 10, 167, 167, 167, 10, 221, 221, 221, 51, 222, 222, 222, 151, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 57, 222, 222, 222, 57, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 186, 209, 209, 209, 42, 221, 221, 221, 51, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 196, 221, 221, 221, 22, 0, 0, 0, 0, 0, 0, 0, 0, 110, 110, 110, 0, 221, 221, 221, 120, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 120, 110, 110, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196, 196, 196, 20, 222, 222, 222, 188, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 188, 174, 174, 174, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 0, 219, 219, 219, 61, 222, 222, 222, 198, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 198, 219, 219, 219, 61, 43, 43, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 222, 222, 222, 86, 222, 222, 222, 197, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 197, 222, 222, 222, 85, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 219, 219, 219, 60, 222, 222, 222, 189, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 189, 219, 219, 219, 60, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 27, 27, 0, 111, 111, 111, 20, 223, 223, 223, 120, 222, 222, 222, 196, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 196, 223, 223, 223, 120, 111, 111, 111, 20, 27, 27, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 22, 219, 219, 219, 84, 222, 222, 222, 143, 222, 222, 222, 169, 222, 222, 222, 189, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 189, 222, 222, 222, 169, 222, 222, 222, 143, 219, 219, 219, 84, 221, 221, 221, 22, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 26,
"mipmaps": false,
"width": 42
}

[sub_resource type="ImageTexture" id="18"]
image = SubResource("Image_e2oel")

[sub_resource type="StyleBoxFlat" id="19"]
content_margin_left = 6.0
content_margin_top = 4.0
content_margin_right = 6.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
draw_center = false
border_color = Color(0.122549, 0.144608, 0.193627, 1)

[sub_resource type="Image" id="Image_qc34w"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 168, 168, 168, 0, 224, 224, 224, 255, 224, 224, 224, 255, 168, 168, 168, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 168, 168, 168, 0, 224, 224, 224, 255, 224, 224, 224, 255, 168, 168, 168, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="21"]
image = SubResource("Image_qc34w")

[sub_resource type="Image" id="Image_xrop6"]
data = {
"data": PackedByteArray(224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="23"]
image = SubResource("Image_xrop6")

[sub_resource type="Image" id="Image_kt4lh"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 112, 112, 112, 0, 112, 112, 112, 0, 54, 54, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 54, 54, 0, 219, 219, 219, 73, 224, 224, 224, 227, 224, 224, 224, 227, 219, 219, 219, 73, 54, 54, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 225, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 225, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 168, 168, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 168, 168, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 168, 168, 0, 224, 224, 224, 255, 168, 168, 168, 0, 168, 168, 168, 0, 224, 224, 224, 255, 168, 168, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 111, 111, 111, 0, 111, 111, 111, 0, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 223, 223, 223, 220, 220, 220, 220, 73, 220, 220, 220, 74, 223, 223, 223, 219, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 54, 54, 0, 217, 217, 217, 67, 224, 224, 224, 255, 224, 224, 224, 255, 217, 217, 217, 67, 54, 54, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 224, 224, 224, 255, 224, 224, 224, 255, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="25"]
image = SubResource("Image_kt4lh")

[sub_resource type="StyleBoxFlat" id="26"]
content_margin_left = 2.0
content_margin_top = 0.0
content_margin_right = 0.0
content_margin_bottom = 0.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
border_width_left = 2

[sub_resource type="StyleBoxFlat" id="27"]
content_margin_left = 8.0
content_margin_top = 8.0
content_margin_right = 8.0
content_margin_bottom = 8.0
bg_color = Color(0.122549, 0.144608, 0.193627, 1)
border_width_left = 1
border_width_top = 24
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.122549, 0.144608, 0.193627, 1)
expand_margin_top = 24.0
shadow_color = Color(0, 0, 0, 0.3)
shadow_size = 4

[sub_resource type="StyleBoxFlat" id="1350"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.122549, 0.144608, 0.193627, 1)

[sub_resource type="StyleBoxFlat" id="1351"]
content_margin_left = 5.0
content_margin_top = 5.0
content_margin_right = 5.0
content_margin_bottom = 5.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.0980392, 0.115686, 0.154902, 1)
expand_margin_top = -33.0

[sub_resource type="StyleBoxFlat" id="1352"]
content_margin_left = 2.0
content_margin_top = 4.0
content_margin_right = 2.0
content_margin_bottom = 2.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.0980392, 0.115686, 0.154902, 1)

[sub_resource type="StyleBoxFlat" id="1353"]
content_margin_left = 5.0
content_margin_top = 5.0
content_margin_right = 5.0
content_margin_bottom = 5.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_color = Color(0.0980392, 0.115686, 0.154902, 1)

[sub_resource type="StyleBoxFlat" id="1354"]
content_margin_left = 10.0
content_margin_top = 5.0
content_margin_right = 10.0
content_margin_bottom = 5.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_color = Color(0.122549, 0.144608, 0.193627, 1)
expand_margin_bottom = 1.0

[sub_resource type="StyleBoxFlat" id="1355"]
content_margin_left = 10.0
content_margin_top = 5.0
content_margin_right = 10.0
content_margin_bottom = 5.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_color = Color(0.0980392, 0.115686, 0.154902, 1)
expand_margin_bottom = 1.0

[sub_resource type="StyleBoxFlat" id="1356"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
draw_center = false
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.497549, 0.519608, 0.568627, 1)

[sub_resource type="StyleBoxFlat" id="1357"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.196078, 0.231373, 0.309804, 0.5)
border_color = Color(0.196078, 0.231373, 0.309804, 1)

[sub_resource type="StyleBoxFlat" id="1358"]
content_margin_left = 6.0
content_margin_top = 4.0
content_margin_right = 6.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
draw_center = false
border_width_bottom = 1
border_color = Color(0.411765, 0.611765, 0.909804, 1)

[sub_resource type="StyleBoxEmpty" id="1359"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0

[sub_resource type="StyleBoxEmpty" id="1360"]
content_margin_left = 0.0
content_margin_top = 0.0
content_margin_right = 0.0
content_margin_bottom = 0.0

[sub_resource type="StyleBoxEmpty" id="1361"]
content_margin_left = 4.0
content_margin_top = 0.0
content_margin_right = 4.0
content_margin_bottom = 4.0

[sub_resource type="Image" id="Image_w2kt3"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 223, 223, 223, 179, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 179, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 220, 220, 220, 73, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 111, 111, 111, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 179, 111, 111, 111, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 111, 111, 111, 0, 223, 223, 223, 179, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 179, 111, 111, 111, 0, 0, 0, 0, 0, 111, 111, 111, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="441"]
image = SubResource("Image_w2kt3")

[sub_resource type="Image" id="Image_gcqom"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 56, 0, 0, 0, 84, 0, 0, 0, 95, 0, 0, 0, 95, 0, 0, 0, 84, 0, 0, 0, 56, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 57, 30, 30, 30, 111, 129, 129, 129, 179, 202, 202, 202, 226, 219, 219, 219, 247, 219, 219, 219, 247, 202, 202, 202, 226, 129, 129, 129, 179, 30, 30, 30, 111, 0, 0, 0, 57, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 73, 93, 93, 93, 149, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 93, 93, 93, 149, 0, 0, 0, 73, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 92, 92, 92, 149, 223, 223, 223, 254, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 254, 92, 92, 92, 149, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 17, 30, 30, 30, 111, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 30, 30, 30, 111, 0, 0, 0, 17, 0, 0, 0, 55, 128, 128, 128, 178, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 128, 128, 128, 178, 0, 0, 0, 55, 0, 0, 0, 83, 201, 201, 201, 225, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 201, 201, 201, 225, 0, 0, 0, 82, 0, 0, 0, 95, 219, 219, 219, 246, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 219, 219, 219, 246, 0, 0, 0, 94, 0, 0, 0, 95, 219, 219, 219, 246, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 219, 219, 219, 246, 0, 0, 0, 95, 0, 0, 0, 83, 201, 201, 201, 225, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 201, 201, 201, 225, 0, 0, 0, 83, 0, 0, 0, 56, 129, 129, 129, 178, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 129, 129, 129, 178, 0, 0, 0, 56, 0, 0, 0, 17, 30, 30, 30, 111, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 30, 30, 30, 111, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 57, 94, 94, 94, 149, 223, 223, 223, 254, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 254, 94, 94, 94, 149, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 74, 94, 94, 94, 150, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 94, 94, 94, 150, 0, 0, 0, 74, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 57, 31, 31, 31, 111, 129, 129, 129, 179, 202, 202, 202, 226, 219, 219, 219, 247, 219, 219, 219, 247, 202, 202, 202, 226, 129, 129, 129, 179, 30, 30, 30, 111, 0, 0, 0, 57, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 56, 0, 0, 0, 84, 0, 0, 0, 95, 0, 0, 0, 95, 0, 0, 0, 84, 0, 0, 0, 56, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="1339"]
image = SubResource("Image_gcqom")

[sub_resource type="Image" id="Image_on0af"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 56, 0, 0, 0, 84, 0, 0, 0, 95, 0, 0, 0, 95, 0, 0, 0, 84, 0, 0, 0, 56, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 57, 30, 30, 30, 111, 129, 129, 129, 179, 202, 202, 202, 226, 219, 219, 219, 247, 219, 219, 219, 247, 202, 202, 202, 226, 129, 129, 129, 179, 30, 30, 30, 111, 0, 0, 0, 57, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 73, 93, 93, 93, 149, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 93, 93, 93, 149, 0, 0, 0, 73, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 92, 92, 92, 149, 223, 223, 223, 254, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 254, 92, 92, 92, 149, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 17, 30, 30, 30, 111, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 30, 30, 30, 111, 0, 0, 0, 17, 0, 0, 0, 55, 128, 128, 128, 178, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 128, 128, 128, 178, 0, 0, 0, 55, 0, 0, 0, 83, 201, 201, 201, 225, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 201, 201, 201, 225, 0, 0, 0, 82, 0, 0, 0, 95, 219, 219, 219, 246, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 219, 219, 219, 246, 0, 0, 0, 94, 0, 0, 0, 95, 219, 219, 219, 246, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 219, 219, 219, 246, 0, 0, 0, 95, 0, 0, 0, 83, 201, 201, 201, 225, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 201, 201, 201, 225, 0, 0, 0, 83, 0, 0, 0, 56, 129, 129, 129, 178, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 129, 129, 129, 178, 0, 0, 0, 56, 0, 0, 0, 17, 30, 30, 30, 111, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 30, 30, 30, 111, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 57, 94, 94, 94, 149, 223, 223, 223, 254, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 254, 94, 94, 94, 149, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 74, 94, 94, 94, 150, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 94, 94, 94, 150, 0, 0, 0, 74, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 57, 31, 31, 31, 111, 129, 129, 129, 179, 202, 202, 202, 226, 219, 219, 219, 247, 219, 219, 219, 247, 202, 202, 202, 226, 129, 129, 129, 179, 30, 30, 30, 111, 0, 0, 0, 57, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 56, 0, 0, 0, 84, 0, 0, 0, 95, 0, 0, 0, 95, 0, 0, 0, 84, 0, 0, 0, 56, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="1341"]
image = SubResource("Image_on0af")

[sub_resource type="Image" id="Image_pm745"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 56, 0, 0, 0, 84, 0, 0, 0, 95, 0, 0, 0, 95, 0, 0, 0, 84, 0, 0, 0, 56, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 57, 30, 30, 30, 111, 129, 129, 129, 179, 202, 202, 202, 226, 219, 219, 219, 247, 219, 219, 219, 247, 202, 202, 202, 226, 129, 129, 129, 179, 30, 30, 30, 111, 0, 0, 0, 57, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 73, 93, 93, 93, 149, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 93, 93, 93, 149, 0, 0, 0, 73, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 92, 92, 92, 149, 223, 223, 223, 254, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 254, 92, 92, 92, 149, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 17, 30, 30, 30, 111, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 191, 191, 191, 221, 59, 59, 59, 128, 95, 95, 95, 146, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 30, 30, 30, 111, 0, 0, 0, 17, 0, 0, 0, 55, 128, 128, 128, 178, 224, 224, 224, 255, 224, 224, 224, 255, 221, 221, 221, 250, 126, 126, 126, 172, 6, 6, 6, 102, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 128, 128, 128, 178, 0, 0, 0, 55, 0, 0, 0, 83, 201, 201, 201, 225, 224, 224, 224, 255, 224, 224, 224, 255, 172, 172, 172, 207, 0, 0, 0, 100, 6, 6, 6, 102, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 201, 201, 201, 225, 0, 0, 0, 82, 0, 0, 0, 95, 219, 219, 219, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 128, 128, 128, 171, 191, 191, 191, 221, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 219, 219, 219, 246, 0, 0, 0, 94, 0, 0, 0, 95, 219, 219, 219, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 219, 219, 219, 246, 0, 0, 0, 95, 0, 0, 0, 83, 201, 201, 201, 225, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 201, 201, 201, 225, 0, 0, 0, 83, 0, 0, 0, 56, 129, 129, 129, 178, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 129, 129, 129, 178, 0, 0, 0, 56, 0, 0, 0, 17, 30, 30, 30, 111, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 0, 0, 0, 100, 0, 0, 0, 100, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 30, 30, 30, 111, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 57, 94, 94, 94, 149, 223, 223, 223, 254, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 223, 223, 223, 254, 94, 94, 94, 149, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 74, 94, 94, 94, 150, 218, 218, 218, 246, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 218, 218, 218, 246, 94, 94, 94, 150, 0, 0, 0, 74, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 57, 31, 31, 31, 111, 129, 129, 129, 179, 202, 202, 202, 226, 219, 219, 219, 247, 219, 219, 219, 247, 202, 202, 202, 226, 129, 129, 129, 179, 30, 30, 30, 111, 0, 0, 0, 57, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 56, 0, 0, 0, 84, 0, 0, 0, 95, 0, 0, 0, 95, 0, 0, 0, 84, 0, 0, 0, 56, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="1343"]
image = SubResource("Image_pm745")

[sub_resource type="Image" id="Image_inpsi"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 168, 168, 168, 0, 224, 224, 224, 255, 224, 224, 224, 255, 168, 168, 168, 0, 112, 112, 112, 0, 112, 112, 112, 0, 168, 168, 168, 0, 224, 224, 224, 255, 224, 224, 224, 255, 168, 168, 168, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 168, 168, 168, 0, 224, 224, 224, 255, 224, 224, 224, 255, 168, 168, 168, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 113, 255, 255, 255, 156, 255, 255, 255, 156, 255, 255, 255, 113, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 168, 168, 168, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 191, 191, 191, 18, 255, 255, 255, 161, 255, 255, 255, 174, 255, 255, 255, 174, 255, 255, 255, 174, 255, 255, 255, 174, 255, 255, 255, 161, 191, 191, 191, 18, 0, 0, 0, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 128, 128, 128, 0, 255, 255, 255, 112, 255, 255, 255, 174, 255, 255, 255, 124, 255, 255, 255, 19, 255, 255, 255, 19, 255, 255, 255, 124, 255, 255, 255, 174, 255, 255, 255, 112, 128, 128, 128, 0, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 128, 128, 128, 0, 255, 255, 255, 155, 255, 255, 255, 174, 255, 255, 255, 19, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 19, 255, 255, 255, 174, 255, 255, 255, 155, 128, 128, 128, 0, 112, 112, 112, 0, 112, 112, 112, 0, 168, 168, 168, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 128, 128, 128, 0, 255, 255, 255, 174, 255, 255, 255, 174, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 174, 255, 255, 255, 174, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 128, 128, 128, 0, 255, 255, 255, 174, 255, 255, 255, 174, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 174, 255, 255, 255, 174, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 224, 224, 224, 255, 224, 224, 224, 255, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="1119"]
image = SubResource("Image_inpsi")

[sub_resource type="StyleBoxFlat" id="1362"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.0980392, 0.115686, 0.154902, 1)

[sub_resource type="Image" id="Image_ene13"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 77, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 77, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 78, 255, 255, 255, 228, 255, 255, 255, 188, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 188, 255, 255, 255, 228, 255, 255, 255, 78, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 189, 255, 255, 255, 229, 255, 255, 255, 188, 191, 191, 191, 18, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 18, 255, 255, 255, 188, 255, 255, 255, 229, 255, 255, 255, 189, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 190, 255, 255, 255, 229, 255, 255, 255, 187, 191, 191, 191, 18, 191, 191, 191, 18, 255, 255, 255, 187, 255, 255, 255, 229, 255, 255, 255, 190, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 190, 255, 255, 255, 229, 255, 255, 255, 186, 255, 255, 255, 187, 255, 255, 255, 229, 255, 255, 255, 190, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 191, 255, 255, 255, 229, 255, 255, 255, 229, 255, 255, 255, 191, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 189, 255, 255, 255, 229, 255, 255, 255, 229, 255, 255, 255, 189, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 188, 255, 255, 255, 229, 255, 255, 255, 189, 255, 255, 255, 189, 255, 255, 255, 229, 255, 255, 255, 188, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 18, 255, 255, 255, 188, 255, 255, 255, 229, 255, 255, 255, 190, 191, 191, 191, 20, 191, 191, 191, 20, 255, 255, 255, 190, 255, 255, 255, 229, 255, 255, 255, 187, 191, 191, 191, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 18, 255, 255, 255, 187, 255, 255, 255, 229, 255, 255, 255, 190, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 190, 255, 255, 255, 229, 255, 255, 255, 187, 191, 191, 191, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 78, 255, 255, 255, 228, 255, 255, 255, 191, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 191, 255, 255, 255, 228, 255, 255, 255, 77, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 79, 191, 191, 191, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 21, 255, 255, 255, 79, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="511"]
image = SubResource("Image_ene13")

[sub_resource type="Image" id="Image_1dhk2"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 61, 255, 255, 255, 190, 255, 255, 255, 242, 255, 255, 255, 242, 255, 255, 255, 190, 255, 255, 255, 61, 128, 128, 128, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 122, 255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 121, 128, 128, 128, 0, 255, 255, 255, 60, 255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 60, 255, 255, 255, 189, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 255, 255, 255, 241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 255, 255, 255, 241, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 255, 255, 255, 189, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 189, 255, 255, 255, 61, 255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 61, 128, 128, 128, 0, 255, 255, 255, 122, 255, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 122, 128, 128, 128, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 61, 255, 255, 255, 190, 255, 255, 255, 242, 255, 255, 255, 242, 255, 255, 255, 190, 255, 255, 255, 61, 128, 128, 128, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 10,
"mipmaps": false,
"width": 10
}

[sub_resource type="ImageTexture" id="517"]
image = SubResource("Image_1dhk2")

[sub_resource type="Image" id="Image_6tb33"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 105, 255, 255, 255, 105, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 150, 255, 255, 255, 150, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 150, 255, 255, 255, 150, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 150, 255, 255, 255, 150, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 150, 255, 255, 255, 150, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 150, 255, 255, 255, 150, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 191, 191, 191, 0, 255, 255, 255, 150, 255, 255, 255, 150, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 105, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 105, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 105, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="531"]
image = SubResource("Image_6tb33")

[sub_resource type="StyleBoxFlat" id="1363"]
content_margin_left = 28.0
content_margin_top = 24.0
content_margin_right = 28.0
content_margin_bottom = 5.0
bg_color = Color(0, 0, 0, 0.9)
draw_center = false
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(1, 0.87, 0.4, 1)
shadow_color = Color(1, 0.87, 0.4, 0.1)
shadow_size = 8

[sub_resource type="StyleBoxFlat" id="1364"]
content_margin_left = 28.0
content_margin_top = 24.0
content_margin_right = 28.0
content_margin_bottom = 5.0
bg_color = Color(0, 0, 0, 0.3)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(1, 1, 1, 0.9)

[sub_resource type="StyleBoxFlat" id="1365"]
content_margin_left = 28.0
content_margin_top = 24.0
content_margin_right = 28.0
content_margin_bottom = 5.0
bg_color = Color(0, 0, 0, 0.4)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(1, 1, 1, 0.9)

[sub_resource type="StyleBoxFlat" id="1366"]
content_margin_left = 28.0
content_margin_top = 24.0
content_margin_right = 28.0
content_margin_bottom = 5.0
bg_color = Color(0, 0, 0, 0.7)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(1, 1, 1, 0.9)

[sub_resource type="StyleBoxFlat" id="1367"]
content_margin_left = 28.0
content_margin_top = 24.0
content_margin_right = 28.0
content_margin_bottom = 5.0
bg_color = Color(0, 0, 0, 0.9)
draw_center = false
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(1, 0.47, 0.42, 1)
shadow_color = Color(1, 0.47, 0.42, 0.2)
shadow_size = 8

[sub_resource type="StyleBoxFlat" id="1368"]
content_margin_left = 28.0
content_margin_top = 24.0
content_margin_right = 28.0
content_margin_bottom = 5.0
bg_color = Color(0, 0, 0, 0.9)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.411765, 0.611765, 0.909804, 0.9)
shadow_color = Color(0, 0, 0, 0.3)
shadow_size = 8

[sub_resource type="StyleBoxFlat" id="1369"]
content_margin_left = 28.0
content_margin_top = 24.0
content_margin_right = 28.0
content_margin_bottom = 5.0
bg_color = Color(0, 0, 0, 0.7)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(1, 1, 1, 0.9)

[sub_resource type="StyleBoxFlat" id="1370"]
content_margin_left = 28.0
content_margin_top = 24.0
content_margin_right = 28.0
content_margin_bottom = 5.0
bg_color = Color(0, 0, 0, 0.9)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.411765, 0.611765, 0.909804, 0.9)
shadow_color = Color(0, 0, 0, 0.3)
shadow_size = 8

[sub_resource type="ImageTexture" id="1371"]

[sub_resource type="Image" id="Image_fu6wn"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 20, 255, 255, 255, 62, 255, 255, 255, 62, 255, 255, 255, 20, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 62, 255, 255, 255, 70, 255, 255, 255, 70, 255, 255, 255, 61, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 62, 255, 255, 255, 70, 255, 255, 255, 70, 255, 255, 255, 62, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 20, 255, 255, 255, 62, 255, 255, 255, 62, 255, 255, 255, 20, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 12,
"mipmaps": false,
"width": 12
}

[sub_resource type="ImageTexture" id="539"]
image = SubResource("Image_fu6wn")

[sub_resource type="StyleBoxTexture" id="1372"]
content_margin_left = 2.0
content_margin_top = 2.0
content_margin_right = 2.0
content_margin_bottom = 2.0
texture = SubResource("539")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="Image" id="Image_lls82"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 62, 62, 0, 124, 124, 124, 0, 124, 124, 124, 0, 62, 62, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180, 180, 180, 4, 248, 248, 248, 99, 248, 248, 248, 167, 248, 248, 248, 167, 248, 248, 248, 99, 180, 180, 180, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 62, 62, 0, 247, 247, 247, 98, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 186, 247, 247, 247, 98, 62, 62, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 124, 124, 0, 248, 248, 248, 166, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 166, 124, 124, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 124, 124, 0, 248, 248, 248, 166, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 166, 124, 124, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 62, 62, 0, 247, 247, 247, 98, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 186, 248, 248, 248, 186, 247, 247, 247, 98, 62, 62, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180, 180, 180, 5, 248, 248, 248, 99, 248, 248, 248, 167, 248, 248, 248, 167, 248, 248, 248, 99, 180, 180, 180, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 62, 62, 0, 124, 124, 124, 0, 124, 124, 124, 0, 62, 62, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 12,
"mipmaps": false,
"width": 12
}

[sub_resource type="ImageTexture" id="541"]
image = SubResource("Image_lls82")

[sub_resource type="StyleBoxTexture" id="1373"]
content_margin_left = 2.0
content_margin_top = 2.0
content_margin_right = 2.0
content_margin_bottom = 2.0
texture = SubResource("541")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="Image" id="Image_jfhg0"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 43, 43, 0, 87, 87, 87, 0, 87, 87, 87, 0, 43, 43, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 124, 124, 4, 173, 173, 173, 98, 173, 173, 173, 166, 173, 173, 173, 166, 173, 173, 173, 98, 124, 124, 124, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 43, 43, 0, 173, 173, 173, 98, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 98, 43, 43, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 87, 87, 0, 173, 173, 173, 165, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 165, 87, 87, 87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 87, 87, 0, 173, 173, 173, 165, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 165, 87, 87, 87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 43, 43, 0, 173, 173, 173, 98, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 185, 173, 173, 173, 98, 43, 43, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 5, 173, 173, 173, 98, 173, 173, 173, 166, 173, 173, 173, 166, 173, 173, 173, 98, 128, 128, 128, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 43, 43, 0, 87, 87, 87, 0, 87, 87, 87, 0, 43, 43, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 12,
"mipmaps": false,
"width": 12
}

[sub_resource type="ImageTexture" id="543"]
image = SubResource("Image_jfhg0")

[sub_resource type="StyleBoxTexture" id="1374"]
content_margin_left = 2.0
content_margin_top = 2.0
content_margin_right = 2.0
content_margin_bottom = 2.0
texture = SubResource("543")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="Image" id="Image_13cus"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 12,
"mipmaps": false,
"width": 12
}

[sub_resource type="ImageTexture" id="537"]
image = SubResource("Image_13cus")

[sub_resource type="StyleBoxTexture" id="1375"]
content_margin_left = 0.0
content_margin_top = 0.0
content_margin_right = 0.0
content_margin_bottom = 0.0
texture = SubResource("537")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="StyleBoxTexture" id="1376"]
content_margin_left = 0.0
content_margin_top = 0.0
content_margin_right = 0.0
content_margin_bottom = 0.0
texture = SubResource("537")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="StyleBoxLine" id="1377"]
color = Color(1, 1, 1, 0.1)

[sub_resource type="Image" id="Image_qhj0u"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 54, 54, 0, 110, 110, 110, 0, 111, 111, 111, 0, 111, 111, 111, 0, 110, 110, 110, 0, 54, 54, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 166, 166, 166, 6, 219, 219, 219, 37, 222, 222, 222, 59, 222, 222, 222, 69, 222, 222, 222, 69, 222, 222, 222, 59, 219, 219, 219, 37, 166, 166, 166, 6, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 217, 217, 217, 23, 223, 223, 223, 69, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 69, 217, 217, 217, 23, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 217, 217, 217, 23, 223, 223, 223, 73, 223, 223, 223, 73, 222, 222, 222, 50, 221, 221, 221, 17, 152, 152, 152, 2, 152, 152, 152, 2, 221, 221, 221, 17, 222, 222, 222, 50, 223, 223, 223, 73, 223, 223, 223, 73, 217, 217, 217, 23, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165, 165, 165, 6, 223, 223, 223, 69, 223, 223, 223, 73, 222, 222, 222, 33, 110, 110, 110, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 110, 110, 110, 0, 222, 222, 222, 33, 223, 223, 223, 73, 223, 223, 223, 69, 165, 165, 165, 6, 0, 0, 0, 0, 54, 54, 54, 0, 219, 219, 219, 37, 223, 223, 223, 73, 222, 222, 222, 50, 110, 110, 110, 0, 191, 191, 191, 10, 255, 255, 255, 141, 255, 255, 255, 218, 255, 255, 255, 215, 255, 255, 255, 130, 191, 191, 191, 5, 110, 110, 110, 0, 222, 222, 222, 50, 223, 223, 223, 73, 219, 219, 219, 37, 54, 54, 54, 0, 110, 110, 110, 0, 221, 221, 221, 59, 223, 223, 223, 73, 221, 221, 221, 17, 128, 128, 128, 0, 255, 255, 255, 144, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 126, 64, 64, 64, 0, 221, 221, 221, 17, 223, 223, 223, 73, 221, 221, 221, 59, 110, 110, 110, 0, 111, 111, 111, 0, 222, 222, 222, 69, 223, 223, 223, 73, 112, 112, 112, 2, 191, 191, 191, 2, 255, 255, 255, 222, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 208, 128, 128, 128, 0, 149, 149, 149, 2, 223, 223, 223, 73, 222, 222, 222, 69, 111, 111, 111, 0, 111, 111, 111, 0, 222, 222, 222, 69, 223, 223, 223, 73, 149, 149, 149, 2, 191, 191, 191, 2, 255, 255, 255, 222, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 208, 128, 128, 128, 0, 112, 112, 112, 2, 223, 223, 223, 73, 222, 222, 222, 69, 111, 111, 111, 0, 110, 110, 110, 0, 221, 221, 221, 59, 223, 223, 223, 73, 221, 221, 221, 17, 128, 128, 128, 0, 255, 255, 255, 144, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 126, 64, 64, 64, 0, 221, 221, 221, 17, 223, 223, 223, 73, 221, 221, 221, 59, 110, 110, 110, 0, 54, 54, 54, 0, 219, 219, 219, 37, 223, 223, 223, 73, 221, 221, 221, 49, 110, 110, 110, 0, 191, 191, 191, 10, 255, 255, 255, 141, 255, 255, 255, 218, 255, 255, 255, 215, 255, 255, 255, 130, 191, 191, 191, 5, 110, 110, 110, 0, 221, 221, 221, 49, 223, 223, 223, 73, 219, 219, 219, 37, 54, 54, 54, 0, 0, 0, 0, 0, 166, 166, 166, 6, 223, 223, 223, 69, 223, 223, 223, 73, 222, 222, 222, 33, 110, 110, 110, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 110, 110, 110, 0, 222, 222, 222, 33, 223, 223, 223, 73, 223, 223, 223, 69, 166, 166, 166, 6, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 217, 217, 217, 23, 223, 223, 223, 73, 223, 223, 223, 73, 222, 222, 222, 50, 221, 221, 221, 17, 152, 152, 152, 2, 152, 152, 152, 2, 221, 221, 221, 17, 222, 222, 222, 50, 223, 223, 223, 73, 223, 223, 223, 73, 217, 217, 217, 23, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 208, 208, 208, 23, 223, 223, 223, 69, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 73, 223, 223, 223, 69, 208, 208, 208, 23, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 50, 50, 0, 166, 166, 166, 6, 219, 219, 219, 37, 222, 222, 222, 59, 222, 222, 222, 69, 222, 222, 222, 69, 222, 222, 222, 59, 219, 219, 219, 37, 166, 166, 166, 6, 50, 50, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 54, 54, 0, 110, 110, 110, 0, 111, 111, 111, 0, 111, 111, 111, 0, 110, 110, 110, 0, 54, 54, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="545"]
image = SubResource("Image_qhj0u")

[sub_resource type="Image" id="Image_4oj25"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 111, 111, 111, 0, 112, 112, 112, 0, 112, 112, 112, 0, 111, 111, 111, 0, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 167, 167, 167, 20, 223, 223, 223, 129, 223, 223, 223, 208, 224, 224, 224, 242, 224, 224, 224, 242, 223, 223, 223, 208, 223, 223, 223, 129, 167, 167, 167, 20, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 222, 222, 222, 81, 224, 224, 224, 241, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 241, 222, 222, 222, 81, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 222, 222, 222, 81, 224, 224, 224, 254, 224, 224, 224, 255, 221, 221, 221, 175, 222, 222, 222, 61, 163, 163, 163, 8, 164, 164, 164, 9, 222, 222, 222, 62, 222, 222, 222, 175, 224, 224, 224, 255, 224, 224, 224, 254, 222, 222, 222, 81, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 20, 224, 224, 224, 241, 224, 224, 224, 255, 223, 223, 223, 116, 110, 110, 110, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 110, 110, 110, 0, 223, 223, 223, 116, 224, 224, 224, 255, 224, 224, 224, 241, 167, 167, 167, 20, 0, 0, 0, 0, 55, 55, 55, 0, 223, 223, 223, 128, 224, 224, 224, 255, 222, 222, 222, 175, 110, 110, 110, 0, 191, 191, 191, 10, 255, 255, 255, 141, 255, 255, 255, 218, 255, 255, 255, 215, 255, 255, 255, 130, 191, 191, 191, 5, 110, 110, 110, 0, 222, 222, 222, 175, 224, 224, 224, 255, 223, 223, 223, 128, 55, 55, 55, 0, 111, 111, 111, 0, 223, 223, 223, 206, 224, 224, 224, 255, 222, 222, 222, 61, 128, 128, 128, 0, 255, 255, 255, 144, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 126, 64, 64, 64, 0, 221, 221, 221, 62, 224, 224, 224, 255, 223, 223, 223, 206, 111, 111, 111, 0, 111, 111, 111, 0, 223, 223, 223, 241, 224, 224, 224, 255, 205, 205, 205, 8, 191, 191, 191, 2, 255, 255, 255, 222, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 208, 128, 128, 128, 0, 195, 195, 195, 8, 224, 224, 224, 255, 223, 223, 223, 241, 111, 111, 111, 0, 111, 111, 111, 0, 223, 223, 223, 241, 224, 224, 224, 255, 194, 194, 194, 8, 191, 191, 191, 2, 255, 255, 255, 222, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 208, 128, 128, 128, 0, 205, 205, 205, 8, 224, 224, 224, 255, 223, 223, 223, 241, 111, 111, 111, 0, 111, 111, 111, 0, 223, 223, 223, 206, 224, 224, 224, 255, 222, 222, 222, 61, 128, 128, 128, 0, 255, 255, 255, 144, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 231, 255, 255, 255, 126, 64, 64, 64, 0, 222, 222, 222, 61, 224, 224, 224, 255, 223, 223, 223, 206, 111, 111, 111, 0, 56, 56, 56, 0, 223, 223, 223, 129, 224, 224, 224, 255, 222, 222, 222, 174, 110, 110, 110, 0, 191, 191, 191, 10, 255, 255, 255, 141, 255, 255, 255, 218, 255, 255, 255, 215, 255, 255, 255, 130, 191, 191, 191, 5, 109, 109, 109, 0, 221, 221, 221, 174, 224, 224, 224, 255, 223, 223, 223, 129, 56, 56, 56, 0, 0, 0, 0, 0, 167, 167, 167, 20, 224, 224, 224, 241, 224, 224, 224, 255, 223, 223, 223, 116, 110, 110, 110, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 110, 110, 110, 0, 223, 223, 223, 116, 224, 224, 224, 255, 224, 224, 224, 241, 167, 167, 167, 20, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 222, 222, 222, 82, 224, 224, 224, 254, 224, 224, 224, 255, 222, 222, 222, 175, 222, 222, 222, 62, 164, 164, 164, 9, 163, 163, 163, 8, 222, 222, 222, 61, 221, 221, 221, 175, 224, 224, 224, 255, 224, 224, 224, 254, 222, 222, 222, 82, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 223, 223, 223, 82, 224, 224, 224, 241, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 241, 223, 223, 223, 82, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 167, 167, 167, 21, 223, 223, 223, 129, 223, 223, 223, 208, 224, 224, 224, 242, 224, 224, 224, 242, 223, 223, 223, 208, 223, 223, 223, 129, 167, 167, 167, 20, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 111, 111, 111, 0, 112, 112, 112, 0, 112, 112, 112, 0, 111, 111, 111, 0, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="547"]
image = SubResource("Image_4oj25")

[sub_resource type="StyleBoxFlat" id="1378"]
content_margin_left = 0.0
content_margin_top = 2.0
content_margin_right = 0.0
content_margin_bottom = 2.0
bg_color = Color(0.397059, 0.423529, 0.482353, 1)

[sub_resource type="StyleBoxFlat" id="1379"]
content_margin_left = 0.0
content_margin_top = 2.0
content_margin_right = 0.0
content_margin_bottom = 2.0
bg_color = Color(0.0980392, 0.115686, 0.154902, 1)

[sub_resource type="Image" id="Image_ij2gv"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 66, 255, 255, 255, 66, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 100, 255, 255, 255, 100, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 66, 255, 255, 255, 66, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 64,
"mipmaps": false,
"width": 8
}

[sub_resource type="ImageTexture" id="521"]
image = SubResource("Image_ij2gv")

[sub_resource type="Image" id="Image_nick8"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0),
"format": "LumAlpha8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="1381"]
image = SubResource("Image_nick8")

[sub_resource type="StyleBoxTexture" id="1382"]
texture = SubResource("1381")
region_rect = Rect2(0, 0, 16, 16)

[sub_resource type="StyleBoxFlat" id="1383"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.0980392, 0.115686, 0.154902, 1)

[sub_resource type="StyleBoxFlat" id="1384"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
draw_center = false
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(1, 1, 1, 0.2)

[sub_resource type="StyleBoxFlat" id="1385"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(1, 1, 1, 0.2)
border_color = Color(0.196078, 0.231373, 0.309804, 1)

[sub_resource type="StyleBoxFlat" id="1386"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(1, 1, 1, 0.2)
border_color = Color(0.196078, 0.231373, 0.309804, 1)

[sub_resource type="Image" id="Image_wfv6n"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 146, 255, 255, 255, 151, 191, 191, 191, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 15, 255, 255, 255, 149, 255, 255, 255, 151, 128, 128, 128, 0, 128, 128, 128, 0, 255, 255, 255, 156, 255, 255, 255, 199, 255, 255, 255, 163, 191, 191, 191, 16, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 14, 255, 255, 255, 161, 255, 255, 255, 199, 255, 255, 255, 160, 128, 128, 128, 0, 0, 0, 0, 0, 191, 191, 191, 17, 255, 255, 255, 165, 255, 255, 255, 199, 255, 255, 255, 163, 191, 191, 191, 16, 191, 191, 191, 14, 255, 255, 255, 160, 255, 255, 255, 199, 255, 255, 255, 167, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 17, 255, 255, 255, 165, 255, 255, 255, 199, 255, 255, 255, 162, 255, 255, 255, 160, 255, 255, 255, 199, 255, 255, 255, 168, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 18, 255, 255, 255, 166, 255, 255, 255, 199, 255, 255, 255, 199, 255, 255, 255, 168, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 18, 255, 255, 255, 154, 255, 255, 255, 157, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 12,
"mipmaps": false,
"width": 12
}

[sub_resource type="ImageTexture" id="525"]
image = SubResource("Image_wfv6n")

[sub_resource type="StyleBoxFlat" id="1387"]
content_margin_left = 6.0
content_margin_top = 4.0
content_margin_right = 6.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)

[sub_resource type="Image" id="Image_is7ne"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 223, 223, 223, 175, 223, 223, 223, 196, 167, 167, 167, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 191, 223, 223, 223, 254, 223, 223, 223, 211, 167, 167, 167, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 20, 223, 223, 223, 208, 223, 223, 223, 254, 223, 223, 223, 211, 167, 167, 167, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 223, 223, 223, 20, 223, 223, 223, 209, 223, 223, 223, 254, 223, 223, 223, 210, 166, 166, 166, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 223, 223, 223, 175, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 196, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 223, 223, 223, 175, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 197, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 112, 112, 112, 0, 112, 112, 112, 0, 112, 112, 112, 0, 222, 222, 222, 20, 223, 223, 223, 207, 223, 223, 223, 254, 223, 223, 223, 212, 166, 166, 166, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 19, 223, 223, 223, 207, 223, 223, 223, 254, 223, 223, 223, 213, 166, 166, 166, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 223, 223, 223, 190, 223, 223, 223, 254, 223, 223, 223, 214, 167, 167, 167, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 223, 223, 223, 175, 223, 223, 223, 197, 167, 167, 167, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="91"]
image = SubResource("Image_is7ne")

[sub_resource type="Image" id="Image_u5e5u"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 35, 128, 128, 128, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 1, 222, 222, 222, 35, 111, 111, 111, 0, 0, 0, 0, 0, 112, 112, 112, 0, 223, 223, 223, 184, 223, 223, 223, 254, 222, 222, 222, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 222, 222, 65, 223, 223, 223, 254, 223, 223, 223, 184, 112, 112, 112, 0, 56, 56, 56, 0, 223, 223, 223, 121, 223, 223, 223, 254, 223, 223, 223, 199, 166, 166, 166, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 6, 223, 223, 223, 200, 223, 223, 223, 254, 223, 223, 223, 121, 56, 56, 56, 0, 0, 0, 0, 0, 165, 165, 165, 11, 223, 223, 223, 222, 223, 223, 223, 254, 223, 223, 223, 177, 163, 163, 163, 6, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 56, 56, 0, 163, 163, 163, 6, 223, 223, 223, 177, 223, 223, 223, 254, 223, 223, 223, 222, 165, 165, 165, 11, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 21, 223, 223, 223, 212, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 214, 223, 223, 223, 89, 220, 220, 220, 22, 221, 221, 221, 23, 223, 223, 223, 89, 223, 223, 223, 214, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 212, 166, 166, 166, 21, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 12, 223, 223, 223, 194, 223, 223, 223, 212, 223, 223, 223, 216, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 216, 223, 223, 223, 212, 223, 223, 223, 193, 167, 167, 167, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 12, 167, 167, 167, 21, 166, 166, 166, 6, 222, 222, 222, 107, 223, 223, 223, 191, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 191, 222, 222, 222, 106, 166, 166, 166, 6, 166, 166, 166, 21, 167, 167, 167, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 167, 167, 167, 0, 223, 223, 223, 254, 223, 223, 223, 252, 167, 167, 167, 0, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="573"]
image = SubResource("Image_u5e5u")

[sub_resource type="Image" id="Image_x0670"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 56, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 164, 164, 2, 222, 222, 222, 92, 223, 223, 223, 185, 223, 223, 223, 231, 223, 223, 223, 231, 223, 223, 223, 186, 222, 222, 222, 94, 155, 155, 155, 3, 32, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 54, 54, 0, 217, 217, 217, 43, 223, 223, 223, 208, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 211, 178, 178, 178, 48, 52, 52, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 220, 220, 44, 223, 223, 223, 239, 223, 223, 223, 254, 223, 223, 223, 226, 213, 213, 213, 88, 222, 222, 222, 25, 222, 222, 222, 25, 213, 213, 213, 88, 223, 223, 223, 226, 223, 223, 223, 254, 223, 223, 223, 241, 184, 184, 184, 49, 32, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 8, 223, 223, 223, 217, 223, 223, 223, 254, 223, 223, 223, 226, 167, 167, 167, 18, 103, 103, 103, 0, 112, 112, 112, 0, 111, 111, 111, 0, 103, 103, 103, 0, 167, 167, 167, 18, 223, 223, 223, 226, 223, 223, 223, 254, 223, 223, 223, 222, 167, 167, 167, 10, 0, 0, 0, 0, 55, 55, 55, 0, 221, 221, 221, 115, 223, 223, 223, 254, 223, 223, 223, 254, 213, 213, 213, 88, 103, 103, 103, 0, 217, 217, 217, 71, 223, 223, 223, 226, 223, 223, 223, 226, 217, 217, 217, 71, 105, 105, 105, 0, 216, 216, 216, 88, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 120, 56, 56, 56, 0, 111, 111, 111, 0, 223, 223, 223, 215, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 25, 112, 112, 112, 0, 223, 223, 223, 223, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 223, 112, 112, 112, 0, 223, 223, 223, 25, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 217, 112, 112, 112, 0, 111, 111, 111, 0, 223, 223, 223, 218, 223, 223, 223, 254, 223, 223, 223, 254, 218, 218, 218, 22, 112, 112, 112, 0, 223, 223, 223, 225, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 224, 112, 112, 112, 0, 223, 223, 223, 24, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 217, 111, 111, 111, 0, 55, 55, 55, 0, 222, 222, 222, 123, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 86, 110, 110, 110, 0, 217, 217, 217, 72, 223, 223, 223, 226, 223, 223, 223, 226, 217, 217, 217, 72, 110, 110, 110, 0, 223, 223, 223, 86, 223, 223, 223, 254, 223, 223, 223, 254, 222, 222, 222, 123, 55, 55, 55, 0, 0, 0, 0, 0, 167, 167, 167, 12, 223, 223, 223, 226, 223, 223, 223, 254, 223, 223, 223, 225, 167, 167, 167, 18, 103, 103, 103, 0, 112, 112, 112, 0, 112, 112, 112, 0, 103, 103, 103, 0, 167, 167, 167, 18, 223, 223, 223, 225, 223, 223, 223, 254, 223, 223, 223, 226, 167, 167, 167, 12, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 0, 213, 213, 213, 55, 223, 223, 223, 245, 223, 223, 223, 254, 223, 223, 223, 226, 213, 213, 213, 88, 222, 222, 222, 25, 222, 222, 222, 25, 213, 213, 213, 88, 223, 223, 223, 226, 223, 223, 223, 254, 223, 223, 223, 245, 213, 213, 213, 55, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 214, 214, 214, 54, 223, 223, 223, 217, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 217, 214, 214, 214, 54, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 164, 164, 164, 4, 219, 219, 219, 98, 223, 223, 223, 189, 223, 223, 223, 233, 223, 223, 223, 233, 223, 223, 223, 189, 219, 219, 219, 98, 164, 164, 164, 4, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="575"]
image = SubResource("Image_x0670")

[sub_resource type="Image" id="Image_kp8vr"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 54, 54, 0, 111, 111, 111, 0, 112, 112, 112, 0, 112, 112, 112, 0, 111, 111, 111, 0, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 152, 152, 2, 220, 220, 220, 101, 223, 223, 223, 197, 223, 223, 223, 236, 222, 222, 222, 91, 221, 221, 221, 73, 218, 218, 218, 37, 147, 147, 147, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 0, 202, 202, 202, 49, 223, 223, 223, 216, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 253, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 83, 119, 119, 119, 19, 47, 47, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 210, 210, 210, 50, 223, 223, 223, 243, 223, 223, 223, 254, 223, 223, 223, 232, 208, 208, 208, 97, 218, 218, 218, 32, 209, 209, 209, 10, 203, 203, 203, 34, 221, 221, 221, 89, 221, 221, 221, 100, 221, 221, 221, 95, 132, 132, 132, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 163, 163, 10, 223, 223, 223, 224, 223, 223, 223, 254, 223, 223, 223, 232, 166, 166, 166, 23, 101, 101, 101, 0, 111, 111, 111, 0, 112, 112, 112, 0, 94, 94, 94, 0, 165, 165, 165, 7, 222, 222, 222, 89, 221, 221, 221, 100, 221, 221, 221, 88, 166, 166, 166, 4, 0, 0, 0, 0, 54, 54, 54, 0, 220, 220, 220, 124, 223, 223, 223, 254, 223, 223, 223, 254, 208, 208, 208, 98, 99, 99, 99, 0, 216, 216, 216, 77, 223, 223, 223, 234, 222, 222, 222, 89, 208, 208, 208, 28, 99, 99, 99, 0, 211, 211, 211, 35, 221, 221, 221, 100, 221, 221, 221, 100, 223, 223, 223, 47, 56, 56, 56, 0, 111, 111, 111, 0, 223, 223, 223, 224, 223, 223, 223, 254, 223, 223, 223, 254, 219, 219, 219, 32, 112, 112, 112, 0, 223, 223, 223, 232, 223, 223, 223, 254, 221, 221, 221, 100, 222, 222, 222, 88, 111, 111, 111, 0, 209, 209, 209, 10, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 85, 111, 111, 111, 0, 112, 112, 112, 0, 223, 223, 223, 226, 223, 223, 223, 254, 223, 223, 223, 254, 217, 217, 217, 28, 112, 112, 112, 0, 223, 223, 223, 233, 223, 223, 223, 254, 221, 221, 221, 100, 222, 222, 222, 88, 111, 111, 111, 0, 208, 208, 208, 9, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 86, 111, 111, 111, 0, 54, 54, 54, 0, 220, 220, 220, 131, 223, 223, 223, 254, 223, 223, 223, 254, 215, 215, 215, 96, 105, 105, 105, 0, 219, 219, 219, 77, 223, 223, 223, 234, 222, 222, 222, 89, 208, 208, 208, 28, 94, 94, 94, 0, 203, 203, 203, 34, 221, 221, 221, 100, 221, 221, 221, 100, 217, 217, 217, 48, 53, 53, 53, 0, 0, 0, 0, 0, 166, 166, 166, 15, 223, 223, 223, 232, 223, 223, 223, 254, 223, 223, 223, 231, 166, 166, 166, 22, 101, 101, 101, 0, 111, 111, 111, 0, 112, 112, 112, 0, 94, 94, 94, 0, 164, 164, 164, 7, 221, 221, 221, 89, 221, 221, 221, 100, 222, 222, 222, 89, 160, 160, 160, 5, 0, 0, 0, 0, 0, 0, 0, 0, 43, 43, 43, 0, 201, 201, 201, 61, 223, 223, 223, 248, 223, 223, 223, 254, 223, 223, 223, 232, 208, 208, 208, 97, 218, 218, 218, 32, 209, 209, 209, 10, 203, 203, 203, 34, 221, 221, 221, 89, 221, 221, 221, 100, 221, 221, 221, 96, 187, 187, 187, 22, 32, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 203, 203, 203, 60, 223, 223, 223, 224, 223, 223, 223, 254, 223, 223, 223, 254, 223, 223, 223, 253, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 85, 185, 185, 185, 21, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46, 46, 46, 0, 160, 160, 160, 5, 218, 218, 218, 107, 223, 223, 223, 201, 223, 223, 223, 238, 222, 222, 222, 91, 221, 221, 221, 75, 220, 220, 220, 39, 155, 155, 155, 1, 32, 32, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 53, 53, 0, 111, 111, 111, 0, 112, 112, 112, 0, 111, 111, 111, 0, 111, 111, 111, 0, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="577"]
image = SubResource("Image_kp8vr")

[sub_resource type="StyleBoxFlat" id="1388"]
content_margin_left = 6.0
content_margin_top = 4.0
content_margin_right = 6.0
content_margin_bottom = 4.0
bg_color = Color(0.147059, 0.173529, 0.232353, 1)
border_color = Color(0.122549, 0.144608, 0.193627, 1)

[sub_resource type="StyleBoxLine" id="1389"]
color = Color(1, 1, 1, 0.1)
grow_begin = 7.0

[sub_resource type="StyleBoxLine" id="1390"]
color = Color(1, 1, 1, 0.1)
grow_end = 7.0

[sub_resource type="StyleBoxFlat" id="1391"]
content_margin_left = 8.0
content_margin_top = 8.0
content_margin_right = 8.0
content_margin_bottom = 8.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.397059, 0.423529, 0.482353, 1)
shadow_color = Color(0, 0, 0, 0.3)
shadow_size = 4

[sub_resource type="StyleBoxLine" id="1392"]
color = Color(1, 1, 1, 0.1)
grow_begin = 7.0
grow_end = 7.0

[sub_resource type="Image" id="Image_08quy"]
data = {
"data": PackedByteArray(204, 204, 204, 27, 222, 222, 222, 89, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 88, 204, 204, 204, 27, 222, 222, 222, 88, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 88, 221, 221, 221, 100, 221, 221, 221, 100, 166, 166, 166, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 166, 166, 166, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 166, 166, 166, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 166, 166, 166, 0, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 88, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 88, 204, 204, 204, 27, 222, 222, 222, 89, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 89, 204, 204, 204, 27),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="527"]
image = SubResource("Image_08quy")

[sub_resource type="StyleBoxTexture" id="1393"]
content_margin_left = 0.0
content_margin_top = 0.0
content_margin_right = 0.0
content_margin_bottom = 0.0
texture = SubResource("527")
region_rect = Rect2(0, 0, 16, 16)

[sub_resource type="Image" id="Image_o535j"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 70, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 70, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 70, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 221, 221, 221, 100, 222, 222, 222, 70, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="529"]
image = SubResource("Image_o535j")

[sub_resource type="StyleBoxTexture" id="1394"]
content_margin_left = 2.0
content_margin_top = 1.0
content_margin_right = 2.0
content_margin_bottom = 1.0
texture = SubResource("529")
region_rect = Rect2(0, 0, 16, 16)

[sub_resource type="StyleBoxEmpty" id="1395"]

[sub_resource type="Image" id="Image_ageuv"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 16, 223, 223, 223, 152, 223, 223, 223, 151, 167, 167, 167, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 16, 223, 223, 223, 164, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 164, 167, 167, 167, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 16, 223, 223, 223, 163, 222, 222, 222, 199, 222, 222, 222, 164, 222, 222, 222, 164, 222, 222, 222, 199, 223, 223, 223, 163, 167, 167, 167, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 16, 223, 223, 223, 163, 222, 222, 222, 199, 222, 222, 222, 164, 165, 165, 165, 17, 165, 165, 165, 17, 222, 222, 222, 164, 222, 222, 222, 199, 223, 223, 223, 163, 167, 167, 167, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 223, 223, 223, 156, 222, 222, 222, 199, 222, 222, 222, 165, 166, 166, 166, 17, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 17, 222, 222, 222, 165, 222, 222, 222, 199, 223, 223, 223, 156, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 154, 222, 222, 222, 159, 166, 166, 166, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 18, 222, 222, 222, 159, 222, 222, 222, 154, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 110, 110, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 110, 110, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 150, 223, 223, 223, 152, 167, 167, 167, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 16, 223, 223, 223, 153, 222, 222, 222, 151, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 156, 222, 222, 222, 199, 223, 223, 223, 164, 167, 167, 167, 16, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 16, 223, 223, 223, 164, 222, 222, 222, 199, 222, 222, 222, 156, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165, 165, 165, 17, 222, 222, 222, 164, 222, 222, 222, 199, 223, 223, 223, 163, 167, 167, 167, 16, 167, 167, 167, 16, 223, 223, 223, 163, 222, 222, 222, 199, 222, 222, 222, 164, 165, 165, 165, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 17, 222, 222, 222, 165, 222, 222, 222, 199, 223, 223, 223, 163, 223, 223, 223, 163, 222, 222, 222, 199, 222, 222, 222, 165, 166, 166, 166, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 17, 223, 223, 223, 165, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 165, 166, 166, 166, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 18, 222, 222, 222, 153, 222, 222, 222, 153, 166, 166, 166, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="549"]
image = SubResource("Image_ageuv")

[sub_resource type="Image" id="Image_8lias"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 162, 162, 5, 221, 221, 221, 84, 222, 222, 222, 156, 222, 222, 222, 189, 222, 222, 222, 189, 222, 222, 222, 156, 221, 221, 221, 84, 162, 162, 162, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 21, 223, 223, 223, 160, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 160, 167, 167, 167, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 162, 162, 5, 223, 223, 223, 160, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 182, 187, 187, 187, 46, 222, 222, 222, 57, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 160, 162, 162, 162, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 54, 54, 0, 220, 220, 220, 83, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 182, 167, 167, 167, 34, 64, 64, 64, 0, 187, 187, 187, 45, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 220, 220, 220, 83, 54, 54, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 223, 223, 223, 154, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 182, 183, 183, 183, 34, 58, 58, 58, 0, 151, 151, 151, 33, 222, 222, 222, 181, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 154, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 188, 222, 222, 222, 199, 222, 222, 222, 199, 203, 203, 203, 46, 43, 43, 43, 0, 56, 56, 56, 32, 222, 222, 222, 181, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 188, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 188, 222, 222, 222, 199, 222, 222, 222, 199, 187, 187, 187, 45, 64, 64, 64, 0, 151, 151, 151, 34, 222, 222, 222, 182, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 188, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 223, 223, 223, 154, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 181, 151, 151, 151, 33, 53, 53, 53, 0, 183, 183, 183, 34, 222, 222, 222, 182, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 154, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 221, 221, 221, 83, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 181, 56, 56, 56, 32, 43, 43, 43, 0, 203, 203, 203, 46, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 83, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 162, 162, 5, 222, 222, 222, 161, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 181, 139, 139, 139, 45, 222, 222, 222, 57, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 161, 162, 162, 162, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 21, 223, 223, 223, 161, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 161, 166, 166, 166, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 162, 162, 5, 221, 221, 221, 84, 222, 222, 222, 156, 222, 222, 222, 189, 222, 222, 222, 189, 222, 222, 222, 156, 221, 221, 221, 84, 162, 162, 162, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="533"]
image = SubResource("Image_8lias")

[sub_resource type="Image" id="Image_c0mi8"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 162, 162, 5, 221, 221, 221, 84, 222, 222, 222, 156, 222, 222, 222, 189, 222, 222, 222, 189, 222, 222, 222, 156, 221, 221, 221, 84, 162, 162, 162, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 167, 167, 21, 223, 223, 223, 160, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 160, 167, 167, 167, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 162, 162, 5, 223, 223, 223, 160, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 57, 187, 187, 187, 46, 222, 222, 222, 182, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 160, 162, 162, 162, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 54, 54, 0, 220, 220, 220, 83, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 187, 187, 187, 45, 64, 64, 64, 0, 167, 167, 167, 34, 222, 222, 222, 182, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 220, 220, 220, 83, 54, 54, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 223, 223, 223, 154, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 181, 151, 151, 151, 33, 58, 58, 58, 0, 183, 183, 183, 34, 222, 222, 222, 182, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 154, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 188, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 181, 56, 56, 56, 32, 43, 43, 43, 0, 203, 203, 203, 46, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 188, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 111, 111, 0, 222, 222, 222, 188, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 182, 151, 151, 151, 33, 64, 64, 64, 0, 187, 187, 187, 45, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 188, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 112, 112, 0, 223, 223, 223, 154, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 182, 183, 183, 183, 34, 53, 53, 53, 0, 151, 151, 151, 33, 222, 222, 222, 181, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 154, 112, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 221, 221, 221, 83, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 203, 203, 203, 46, 43, 43, 43, 0, 56, 56, 56, 32, 222, 222, 222, 181, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 221, 221, 221, 83, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 162, 162, 5, 222, 222, 222, 161, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 57, 139, 139, 139, 45, 222, 222, 222, 181, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 161, 162, 162, 162, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 166, 166, 21, 223, 223, 223, 161, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 222, 222, 222, 199, 223, 223, 223, 161, 166, 166, 166, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 162, 162, 5, 221, 221, 221, 84, 222, 222, 222, 156, 222, 222, 222, 189, 222, 222, 222, 189, 222, 222, 222, 156, 221, 221, 221, 84, 162, 162, 162, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 55, 55, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 111, 111, 111, 0, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="535"]
image = SubResource("Image_c0mi8")

[sub_resource type="Image" id="Image_emyh8"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 28, 255, 255, 255, 89, 255, 255, 255, 89, 255, 255, 255, 28, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 88, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 88, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 89, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 88, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 28, 255, 255, 255, 89, 255, 255, 255, 89, 255, 255, 255, 28, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 28, 255, 255, 255, 89, 255, 255, 255, 89, 255, 255, 255, 28, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 88, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 88, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 89, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 88, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 28, 255, 255, 255, 89, 255, 255, 255, 89, 255, 255, 255, 28, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 128, 128, 128, 0, 128, 128, 128, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 28, 255, 255, 255, 89, 255, 255, 255, 89, 255, 255, 255, 28, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 88, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 88, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 89, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 88, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 28, 255, 255, 255, 89, 255, 255, 255, 89, 255, 255, 255, 28, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="553"]
image = SubResource("Image_emyh8")

[sub_resource type="StyleBoxFlat" id="1396"]
content_margin_left = 5.0
content_margin_top = 5.0
content_margin_right = 5.0
content_margin_bottom = 5.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.0980392, 0.115686, 0.154902, 1)

[sub_resource type="StyleBoxFlat" id="1397"]
content_margin_left = 10.0
content_margin_top = 5.0
content_margin_right = 10.0
content_margin_bottom = 5.0
bg_color = Color(0.176471, 0.208235, 0.278824, 1)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_color = Color(0.137255, 0.161961, 0.216863, 1)
expand_margin_bottom = 1.0

[sub_resource type="Image" id="Image_2lrkn"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 77, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 77, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 78, 255, 255, 255, 228, 255, 255, 255, 188, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 188, 255, 255, 255, 228, 255, 255, 255, 78, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 189, 255, 255, 255, 229, 255, 255, 255, 188, 191, 191, 191, 18, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 18, 255, 255, 255, 188, 255, 255, 255, 229, 255, 255, 255, 189, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 190, 255, 255, 255, 229, 255, 255, 255, 187, 191, 191, 191, 18, 191, 191, 191, 18, 255, 255, 255, 187, 255, 255, 255, 229, 255, 255, 255, 190, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 190, 255, 255, 255, 229, 255, 255, 255, 186, 255, 255, 255, 187, 255, 255, 255, 229, 255, 255, 255, 190, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 191, 255, 255, 255, 229, 255, 255, 255, 229, 255, 255, 255, 191, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 189, 255, 255, 255, 229, 255, 255, 255, 229, 255, 255, 255, 189, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 19, 255, 255, 255, 188, 255, 255, 255, 229, 255, 255, 255, 189, 255, 255, 255, 189, 255, 255, 255, 229, 255, 255, 255, 188, 191, 191, 191, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 18, 255, 255, 255, 188, 255, 255, 255, 229, 255, 255, 255, 190, 191, 191, 191, 20, 191, 191, 191, 20, 255, 255, 255, 190, 255, 255, 255, 229, 255, 255, 255, 187, 191, 191, 191, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 18, 255, 255, 255, 187, 255, 255, 255, 229, 255, 255, 255, 190, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 190, 255, 255, 255, 229, 255, 255, 255, 187, 191, 191, 191, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 78, 255, 255, 255, 228, 255, 255, 255, 191, 191, 191, 191, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 20, 255, 255, 255, 191, 255, 255, 255, 228, 255, 255, 255, 77, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 79, 191, 191, 191, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 21, 255, 255, 255, 79, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 16,
"mipmaps": false,
"width": 16
}

[sub_resource type="ImageTexture" id="509"]
image = SubResource("Image_2lrkn")

[sub_resource type="Image" id="Image_08vun"]
data = {
"data": PackedByteArray(255, 255, 255, 35, 255, 255, 255, 38, 191, 191, 191, 4, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 50, 255, 255, 255, 50, 255, 255, 255, 38, 255, 255, 255, 50, 255, 255, 255, 41, 191, 191, 191, 4, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 50, 255, 255, 255, 50, 191, 191, 191, 4, 255, 255, 255, 41, 255, 255, 255, 50, 255, 255, 255, 41, 191, 191, 191, 4, 128, 128, 128, 0, 255, 255, 255, 50, 255, 255, 255, 50, 0, 0, 0, 0, 191, 191, 191, 4, 255, 255, 255, 41, 255, 255, 255, 50, 255, 255, 255, 38, 255, 255, 255, 0, 255, 255, 255, 50, 255, 255, 255, 50, 0, 0, 0, 0, 191, 191, 191, 4, 255, 255, 255, 41, 255, 255, 255, 50, 255, 255, 255, 38, 255, 255, 255, 0, 255, 255, 255, 50, 255, 255, 255, 50, 191, 191, 191, 4, 255, 255, 255, 41, 255, 255, 255, 50, 255, 255, 255, 41, 191, 191, 191, 4, 128, 128, 128, 0, 255, 255, 255, 50, 255, 255, 255, 50, 255, 255, 255, 38, 255, 255, 255, 50, 255, 255, 255, 41, 191, 191, 191, 4, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 50, 255, 255, 255, 50, 255, 255, 255, 35, 255, 255, 255, 38, 191, 191, 191, 4, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 50, 255, 255, 255, 50),
"format": "RGBA8",
"height": 8,
"mipmaps": false,
"width": 8
}

[sub_resource type="ImageTexture" id="551"]
image = SubResource("Image_08vun")

[sub_resource type="StyleBoxFlat" id="1398"]
content_margin_left = 1.0
content_margin_top = 1.0
content_margin_right = 1.0
content_margin_bottom = 1.0
bg_color = Color(1, 1, 1, 0.9)
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(1, 1, 1, 1)
shadow_color = Color(0, 0, 0, 0.3)
shadow_size = 4

[sub_resource type="Image" id="Image_sp0mp"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 66, 255, 255, 255, 73, 191, 191, 191, 8, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 8, 255, 255, 255, 73, 255, 255, 255, 65, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 73, 255, 255, 255, 100, 255, 255, 255, 82, 191, 191, 191, 8, 191, 191, 191, 8, 255, 255, 255, 82, 255, 255, 255, 100, 255, 255, 255, 73, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 8, 255, 255, 255, 83, 255, 255, 255, 100, 255, 255, 255, 82, 255, 255, 255, 82, 255, 255, 255, 100, 255, 255, 255, 83, 191, 191, 191, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 9, 255, 255, 255, 83, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 83, 191, 191, 191, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 9, 255, 255, 255, 77, 255, 255, 255, 76, 191, 191, 191, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 12,
"mipmaps": false,
"width": 12
}

[sub_resource type="ImageTexture" id="555"]
image = SubResource("Image_sp0mp")

[sub_resource type="Image" id="Image_7eb3v"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 66, 255, 255, 255, 73, 191, 191, 191, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 73, 255, 255, 255, 100, 255, 255, 255, 82, 191, 191, 191, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 8, 255, 255, 255, 83, 255, 255, 255, 100, 255, 255, 255, 82, 191, 191, 191, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 9, 255, 255, 255, 83, 255, 255, 255, 100, 255, 255, 255, 76, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 8, 255, 255, 255, 82, 255, 255, 255, 100, 255, 255, 255, 76, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 8, 255, 255, 255, 82, 255, 255, 255, 100, 255, 255, 255, 83, 191, 191, 191, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 72, 255, 255, 255, 100, 255, 255, 255, 83, 191, 191, 191, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 66, 255, 255, 255, 73, 191, 191, 191, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 12,
"mipmaps": false,
"width": 12
}

[sub_resource type="ImageTexture" id="557"]
image = SubResource("Image_7eb3v")

[sub_resource type="Image" id="Image_hb2tv"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 191, 191, 191, 6, 191, 191, 191, 6, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 20, 255, 255, 255, 94, 255, 255, 255, 93, 255, 255, 255, 20, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 20, 255, 255, 255, 93, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 93, 255, 255, 255, 20, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 20, 255, 255, 255, 93, 255, 255, 255, 100, 255, 255, 255, 67, 255, 255, 255, 67, 255, 255, 255, 100, 255, 255, 255, 93, 255, 255, 255, 20, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 82, 255, 255, 255, 100, 255, 255, 255, 67, 191, 191, 191, 2, 191, 191, 191, 2, 255, 255, 255, 67, 255, 255, 255, 100, 255, 255, 255, 81, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 255, 255, 255, 45, 255, 255, 255, 50, 191, 191, 191, 2, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 2, 255, 255, 255, 50, 255, 255, 255, 45, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 64, 64, 0, 64, 64, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 12,
"mipmaps": false,
"width": 12
}

[sub_resource type="ImageTexture" id="559"]
image = SubResource("Image_hb2tv")

[sub_resource type="Image" id="Image_5d1rm"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 98, 255, 255, 255, 109, 191, 191, 191, 12, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 12, 255, 255, 255, 109, 255, 255, 255, 98, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 109, 255, 255, 255, 150, 255, 255, 255, 123, 191, 191, 191, 12, 191, 191, 191, 12, 255, 255, 255, 123, 255, 255, 255, 150, 255, 255, 255, 109, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 13, 255, 255, 255, 124, 255, 255, 255, 150, 255, 255, 255, 123, 255, 255, 255, 123, 255, 255, 255, 150, 255, 255, 255, 124, 191, 191, 191, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 13, 255, 255, 255, 124, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 124, 191, 191, 191, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 13, 255, 255, 255, 115, 255, 255, 255, 115, 191, 191, 191, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 14,
"mipmaps": false,
"width": 14
}

[sub_resource type="ImageTexture" id="513"]
image = SubResource("Image_5d1rm")

[sub_resource type="Image" id="Image_5vdmi"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 78, 255, 255, 255, 142, 255, 255, 255, 77, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 142, 255, 255, 255, 150, 255, 255, 255, 141, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 78, 255, 255, 255, 142, 255, 255, 255, 78, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 78, 255, 255, 255, 142, 255, 255, 255, 77, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 142, 255, 255, 255, 150, 255, 255, 255, 141, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 78, 255, 255, 255, 142, 255, 255, 255, 78, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 78, 255, 255, 255, 142, 255, 255, 255, 77, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 142, 255, 255, 255, 150, 255, 255, 255, 141, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 78, 255, 255, 255, 142, 255, 255, 255, 78, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 14,
"mipmaps": false,
"width": 14
}

[sub_resource type="ImageTexture" id="561"]
image = SubResource("Image_5vdmi")

[sub_resource type="Image" id="Image_y6tlm"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 12, 255, 255, 255, 115, 255, 255, 255, 114, 191, 191, 191, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 12, 255, 255, 255, 123, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 123, 191, 191, 191, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 12, 255, 255, 255, 123, 255, 255, 255, 150, 255, 255, 255, 124, 255, 255, 255, 124, 255, 255, 255, 150, 255, 255, 255, 123, 191, 191, 191, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 114, 255, 255, 255, 150, 255, 255, 255, 124, 191, 191, 191, 13, 191, 191, 191, 13, 255, 255, 255, 124, 255, 255, 255, 150, 255, 255, 255, 114, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 105, 255, 255, 255, 115, 191, 191, 191, 13, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 13, 255, 255, 255, 115, 255, 255, 255, 105, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 105, 255, 255, 255, 114, 191, 191, 191, 12, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 12, 255, 255, 255, 115, 255, 255, 255, 105, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 114, 255, 255, 255, 150, 255, 255, 255, 123, 191, 191, 191, 12, 191, 191, 191, 12, 255, 255, 255, 123, 255, 255, 255, 150, 255, 255, 255, 114, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 13, 255, 255, 255, 124, 255, 255, 255, 150, 255, 255, 255, 123, 255, 255, 255, 123, 255, 255, 255, 150, 255, 255, 255, 124, 191, 191, 191, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 13, 255, 255, 255, 124, 255, 255, 255, 150, 255, 255, 255, 150, 255, 255, 255, 124, 191, 191, 191, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 191, 191, 13, 255, 255, 255, 115, 255, 255, 255, 115, 191, 191, 191, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 14,
"mipmaps": false,
"width": 14
}

[sub_resource type="ImageTexture" id="563"]
image = SubResource("Image_y6tlm")

[sub_resource type="StyleBoxFlat" id="1399"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.397059, 0.423529, 0.482353, 1)
border_color = Color(0.196078, 0.231373, 0.309804, 1)

[sub_resource type="StyleBoxFlat" id="1400"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
draw_center = false
border_width_left = 1
border_width_top = 1
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.397059, 0.423529, 0.482353, 1)

[sub_resource type="StyleBoxEmpty" id="1401"]

[sub_resource type="StyleBoxEmpty" id="1402"]

[sub_resource type="StyleBoxFlat" id="1403"]
content_margin_left = 4.0
content_margin_top = 4.0
content_margin_right = 4.0
content_margin_bottom = 4.0
bg_color = Color(0.0980392, 0.115686, 0.154902, 1)
border_color = Color(0.196078, 0.231373, 0.309804, 1)

[sub_resource type="StyleBoxTexture" id="1404"]
content_margin_left = 2.0
content_margin_top = 2.0
content_margin_right = 2.0
content_margin_bottom = 2.0
texture = SubResource("539")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="StyleBoxTexture" id="1405"]
content_margin_left = 2.0
content_margin_top = 2.0
content_margin_right = 2.0
content_margin_bottom = 2.0
texture = SubResource("541")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="StyleBoxTexture" id="1406"]
content_margin_left = 2.0
content_margin_top = 2.0
content_margin_right = 2.0
content_margin_bottom = 2.0
texture = SubResource("543")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="StyleBoxTexture" id="1407"]
content_margin_left = 0.0
content_margin_top = 0.0
content_margin_right = 0.0
content_margin_bottom = 0.0
texture = SubResource("537")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="StyleBoxTexture" id="1408"]
content_margin_left = 0.0
content_margin_top = 0.0
content_margin_right = 0.0
content_margin_bottom = 0.0
texture = SubResource("537")
region_rect = Rect2(0, 0, 12, 12)

[sub_resource type="StyleBoxLine" id="1409"]
color = Color(1, 1, 1, 0.1)
grow_begin = 0.0
grow_end = 0.0
vertical = true

[sub_resource type="StyleBoxFlat" id="1410"]
content_margin_left = 2.0
content_margin_top = 0.0
content_margin_right = 2.0
content_margin_bottom = 0.0
bg_color = Color(0.397059, 0.423529, 0.482353, 1)

[sub_resource type="StyleBoxFlat" id="1411"]
content_margin_left = 2.0
content_margin_top = 0.0
content_margin_right = 2.0
content_margin_bottom = 0.0
bg_color = Color(0.0980392, 0.115686, 0.154902, 1)

[sub_resource type="Image" id="Image_dfs7x"]
data = {
"data": PackedByteArray(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 128, 128, 128, 0, 255, 255, 255, 64, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 64, 128, 128, 128, 0, 128, 128, 128, 0, 255, 255, 255, 64, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 100, 255, 255, 255, 64, 128, 128, 128, 0, 0, 0, 0, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 128, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
"format": "RGBA8",
"height": 8,
"mipmaps": false,
"width": 64
}

[sub_resource type="ImageTexture" id="581"]
image = SubResource("Image_dfs7x")

[sub_resource type="Image" id="Image_5gewq"]
data = {
"data": PackedByteArray(0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24, 0, 0, 0, 24),
"format": "RGBA8",
"height": 8,
"mipmaps": false,
"width": 8
}

[sub_resource type="ImageTexture" id="579"]
image = SubResource("Image_5gewq")

[sub_resource type="StyleBoxTexture" id="1412"]
texture = SubResource("579")
region_rect = Rect2(0, 0, 8, 8)

[sub_resource type="StyleBoxFlat" id="1413"]
content_margin_left = 8.0
content_margin_top = 8.0
content_margin_right = 8.0
content_margin_bottom = 8.0
bg_color = Color(0.196078, 0.231373, 0.309804, 1)
border_width_left = 1
border_width_top = 24
border_width_right = 1
border_width_bottom = 1
border_color = Color(0.196078, 0.231373, 0.309804, 1)
expand_margin_top = 24.0
shadow_color = Color(0, 0, 0, 0.3)
shadow_size = 4

[resource]
BoxContainer/constants/separation = 4
Button/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
Button/colors/font_color_disabled = Color(1, 1, 1, 0.3)
Button/colors/font_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
Button/colors/font_color_pressed = Color(0.411765, 0.611765, 0.909804, 1)
Button/colors/icon_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
Button/colors/icon_color_pressed = Color(0.473529, 0.703529, 1.04627, 1)
Button/styles/disabled = SubResource("1")
Button/styles/focus = SubResource("2")
Button/styles/hover = SubResource("3")
Button/styles/normal = SubResource("4")
Button/styles/pressed = SubResource("5")
CheckBox/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
CheckBox/colors/font_color_disabled = Color(1, 1, 1, 0.3)
CheckBox/colors/font_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
CheckBox/colors/font_color_pressed = Color(0.411765, 0.611765, 0.909804, 1)
CheckBox/colors/icon_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
CheckBox/constants/check_vadjust = 0
CheckBox/constants/hseparation = 4
CheckBox/icons/checked = SubResource("7")
CheckBox/icons/radio_checked = SubResource("9")
CheckBox/icons/radio_unchecked = SubResource("11")
CheckBox/icons/unchecked = SubResource("13")
CheckBox/styles/disabled = SubResource("14")
CheckBox/styles/hover = SubResource("14")
CheckBox/styles/normal = SubResource("14")
CheckBox/styles/pressed = SubResource("14")
CheckButton/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
CheckButton/colors/font_color_disabled = Color(1, 1, 1, 0.3)
CheckButton/colors/font_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
CheckButton/colors/font_color_pressed = Color(0.411765, 0.611765, 0.909804, 1)
CheckButton/colors/icon_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
CheckButton/constants/check_vadjust = 0
CheckButton/constants/hseparation = 4
CheckButton/icons/off = SubResource("16")
CheckButton/icons/on = SubResource("18")
CheckButton/styles/disabled = SubResource("19")
CheckButton/styles/hover = SubResource("19")
CheckButton/styles/normal = SubResource("19")
CheckButton/styles/pressed = SubResource("19")
ColorPicker/constants/h_width = 30
ColorPicker/constants/label_width = 10
ColorPicker/constants/margin = 8
ColorPicker/constants/sv_height = 256
ColorPicker/constants/sv_width = 256
ColorPicker/icons/add_preset = SubResource("21")
ColorPicker/icons/preset_bg = SubResource("23")
ColorPicker/icons/screen_picker = SubResource("25")
ColorPickerButton/icons/bg = SubResource("23")
Editor/colors/accent_color = Color(0.411765, 0.611765, 0.909804, 1)
Editor/colors/base_color = Color(0.196078, 0.231373, 0.309804, 1)
Editor/colors/contrast_color_1 = Color(0.397059, 0.423529, 0.482353, 1)
Editor/colors/contrast_color_2 = Color(0.497549, 0.519608, 0.568627, 1)
Editor/colors/dark_color_1 = Color(0.147059, 0.173529, 0.232353, 1)
Editor/colors/dark_color_2 = Color(0.122549, 0.144608, 0.193627, 1)
Editor/colors/dark_color_3 = Color(0.0980392, 0.115686, 0.154902, 1)
Editor/colors/disabled_font_color = Color(1, 1, 1, 0.3)
Editor/colors/error_color = Color(1, 0.47, 0.42, 1)
Editor/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
Editor/colors/highlight_color = Color(1, 1, 1, 0.2)
Editor/colors/highlighted_font_color = Color(0.879412, 0.884706, 0.896471, 1)
Editor/colors/mono_color = Color(1, 1, 1, 1)
Editor/colors/prop_category = Color(0.249412, 0.272706, 0.324471, 1)
Editor/colors/prop_section = Color(0.223824, 0.247912, 0.301441, 1)
Editor/colors/prop_subsection = Color(0.198235, 0.223118, 0.278412, 1)
Editor/colors/property_color = Color(0.64951, 0.653922, 0.663725, 1)
Editor/colors/success_color = Color(0.45, 0.95, 0.5, 1)
Editor/colors/warning_color = Color(1, 0.87, 0.4, 1)
Editor/constants/dark_theme = 1
Editor/constants/inspector_margin = 8
Editor/constants/scale = 1
Editor/constants/thumb_size = 64
Editor/styles/sub_inspector_bg = SubResource("26")
EditorAbout/styles/panel = SubResource("27")
EditorFonts/fonts/bold = null
EditorFonts/fonts/doc = null
EditorFonts/fonts/doc_source = null
EditorFonts/fonts/doc_title = null
EditorFonts/fonts/output_source = null
EditorFonts/fonts/rulers = null
EditorFonts/fonts/source = null
EditorFonts/fonts/status_source = null
EditorFonts/fonts/title = null
EditorHelp/colors/headline_color = Color(1, 1, 1, 1)
EditorSettingsDialog/styles/panel = SubResource("27")
EditorStyles/styles/Background = SubResource("1350")
EditorStyles/styles/BottomPanelDebuggerOverride = SubResource("1351")
EditorStyles/styles/Content = SubResource("1352")
EditorStyles/styles/DebuggerPanel = SubResource("1353")
EditorStyles/styles/DebuggerTabBG = SubResource("1354")
EditorStyles/styles/DebuggerTabFG = SubResource("1355")
EditorStyles/styles/Focus = SubResource("1356")
EditorStyles/styles/Information3dViewport = SubResource("1357")
EditorStyles/styles/MenuHover = SubResource("1358")
EditorStyles/styles/MenuPanel = SubResource("19")
EditorStyles/styles/PlayButtonPanel = SubResource("1359")
EditorStyles/styles/SceneTabBG = SubResource("1354")
EditorStyles/styles/SceneTabFG = SubResource("1355")
EditorStyles/styles/ScriptEditor = SubResource("1360")
EditorStyles/styles/ScriptEditorPanel = SubResource("1361")
FileDialog/colors/files_disabled = Color(1, 1, 1, 0.3)
FileDialog/icons/folder = SubResource("441")
GraphEdit/colors/activity = Color(0.411765, 0.611765, 0.909804, 1)
GraphEdit/colors/grid_major = Color(1, 1, 1, 0.15)
GraphEdit/colors/grid_minor = Color(1, 1, 1, 0.07)
GraphEdit/constants/bezier_len_neg = 160
GraphEdit/constants/bezier_len_pos = 80
GraphEdit/icons/minus = SubResource("1339")
GraphEdit/icons/more = SubResource("1341")
GraphEdit/icons/reset = SubResource("1343")
GraphEdit/icons/snap = SubResource("1119")
GraphEdit/styles/bg = SubResource("1362")
GraphNode/colors/close_color = Color(1, 1, 1, 0.7)
GraphNode/colors/title_color = Color(1, 1, 1, 1)
GraphNode/constants/close_h_offset = 20
GraphNode/constants/close_offset = 20
GraphNode/constants/port_offset = 14
GraphNode/constants/separation = 1
GraphNode/constants/title_h_offset = -16
GraphNode/constants/title_offset = 20
GraphNode/icons/close = SubResource("511")
GraphNode/icons/port = SubResource("517")
GraphNode/icons/resizer = SubResource("531")
GraphNode/styles/breakpoint = SubResource("1363")
GraphNode/styles/comment = SubResource("1364")
GraphNode/styles/commentfocus = SubResource("1365")
GraphNode/styles/frame = SubResource("1366")
GraphNode/styles/position = SubResource("1367")
GraphNode/styles/selectedframe = SubResource("1368")
GraphNode/styles/state_machine_frame = SubResource("1369")
GraphNode/styles/state_machine_selectedframe = SubResource("1370")
GridContainer/constants/hseparation = 4
GridContainer/constants/vseparation = 4
GridContainer/constants/vseperation = 4
HBoxContainer/constants/separation = 4
HScrollBar/icons/decrement = SubResource("1371")
HScrollBar/icons/decrement_highlight = SubResource("1371")
HScrollBar/icons/increment = SubResource("1371")
HScrollBar/icons/increment_highlight = SubResource("1371")
HScrollBar/styles/grabber = SubResource("1372")
HScrollBar/styles/grabber_highlight = SubResource("1373")
HScrollBar/styles/grabber_pressed = SubResource("1374")
HScrollBar/styles/scroll = SubResource("1375")
HScrollBar/styles/scroll_focus = SubResource("1376")
HSeparator/styles/separator = SubResource("1377")
HSlider/icons/grabber = SubResource("545")
HSlider/icons/grabber_highlight = SubResource("547")
HSlider/styles/grabber_area = SubResource("1378")
HSlider/styles/slider = SubResource("1379")
HSplitContainer/constants/separation = 8
HSplitContainer/icons/grabber = SubResource("521")
HSplitContainer/styles/bg = SubResource("1382")
ItemList/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
ItemList/colors/font_color_selected = Color(1, 1, 1, 1)
ItemList/colors/guide_color = Color(1, 1, 1, 0.05)
ItemList/constants/hseparation = 3
ItemList/constants/icon_margin = 4
ItemList/constants/line_separation = 3
ItemList/constants/vseparation = 3
ItemList/styles/bg = SubResource("1383")
ItemList/styles/bg_focus = SubResource("1356")
ItemList/styles/cursor = SubResource("1384")
ItemList/styles/cursor_unfocused = SubResource("1384")
ItemList/styles/selected = SubResource("1385")
ItemList/styles/selected_focus = SubResource("1386")
Label/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
Label/colors/font_color_shadow = Color(0, 0, 0, 0)
Label/constants/line_spacing = 3
Label/constants/shadow_as_outline = 0
Label/constants/shadow_offset_x = 1
Label/constants/shadow_offset_y = 1
Label/styles/normal = SubResource("1359")
LineEdit/colors/clear_button_color = Color(0.79902, 0.807843, 0.827451, 1)
LineEdit/colors/clear_button_color_pressed = Color(0.411765, 0.611765, 0.909804, 1)
LineEdit/colors/cursor_color = Color(0.79902, 0.807843, 0.827451, 1)
LineEdit/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
LineEdit/colors/read_only = Color(1, 1, 1, 0.3)
LineEdit/colors/selection_color = Color(0.490196, 0.490196, 0.490196, 1)
LineEdit/styles/focus = SubResource("2")
LineEdit/styles/normal = SubResource("4")
LineEdit/styles/read_only = SubResource("1")
LinkButton/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
LinkButton/styles/focus = SubResource("1359")
MarginContainer/constants/margin_bottom = 0
MarginContainer/constants/margin_left = 0
MarginContainer/constants/margin_right = 0
MarginContainer/constants/margin_top = 0
MenuButton/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
MenuButton/colors/font_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
MenuButton/styles/disabled = SubResource("19")
MenuButton/styles/focus = SubResource("19")
MenuButton/styles/hover = SubResource("19")
MenuButton/styles/normal = SubResource("19")
MenuButton/styles/pressed = SubResource("19")
OptionButton/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
OptionButton/colors/font_color_disabled = Color(1, 1, 1, 0.3)
OptionButton/colors/font_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
OptionButton/colors/font_color_pressed = Color(0.411765, 0.611765, 0.909804, 1)
OptionButton/colors/icon_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
OptionButton/constants/arrow_margin = 4
OptionButton/constants/hseparation = 4
OptionButton/constants/modulate_arrow = 1
OptionButton/icons/arrow = SubResource("525")
OptionButton/styles/disabled = SubResource("1")
OptionButton/styles/focus = SubResource("2")
OptionButton/styles/hover = SubResource("3")
OptionButton/styles/normal = SubResource("4")
OptionButton/styles/pressed = SubResource("5")
Panel/styles/panel = SubResource("1387")
PanelContainer/styles/panel = SubResource("19")
PopupMenu/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
PopupMenu/colors/font_color_accel = Color(1, 1, 1, 0.3)
PopupMenu/colors/font_color_disabled = Color(1, 1, 1, 0.3)
PopupMenu/colors/font_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
PopupMenu/constants/vseparation = 5
PopupMenu/icons/checked = SubResource("7")
PopupMenu/icons/radio_checked = SubResource("9")
PopupMenu/icons/radio_unchecked = SubResource("11")
PopupMenu/icons/submenu = SubResource("91")
PopupMenu/icons/unchecked = SubResource("13")
PopupMenu/icons/visibility_hidden = SubResource("573")
PopupMenu/icons/visibility_visible = SubResource("575")
PopupMenu/icons/visibility_xray = SubResource("577")
PopupMenu/styles/disabled = SubResource("19")
PopupMenu/styles/focus = SubResource("19")
PopupMenu/styles/hover = SubResource("1388")
PopupMenu/styles/labeled_separator_left = SubResource("1389")
PopupMenu/styles/labeled_separator_right = SubResource("1390")
PopupMenu/styles/normal = SubResource("19")
PopupMenu/styles/panel = SubResource("1391")
PopupMenu/styles/pressed = SubResource("19")
PopupMenu/styles/separator = SubResource("1392")
PopupPanel/styles/panel = SubResource("1391")
ProgressBar/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
ProgressBar/styles/bg = SubResource("1393")
ProgressBar/styles/fg = SubResource("1394")
ProjectSettingsEditor/styles/panel = SubResource("27")
RichTextLabel/colors/default_color = Color(0.79902, 0.807843, 0.827451, 1)
RichTextLabel/colors/font_color_shadow = Color(0, 0, 0, 0)
RichTextLabel/constants/shadow_as_outline = 0
RichTextLabel/constants/shadow_offset_x = 1
RichTextLabel/constants/shadow_offset_y = 1
RichTextLabel/styles/focus = SubResource("1395")
RichTextLabel/styles/normal = SubResource("1362")
SpinBox/icons/updown = SubResource("549")
TabContainer/colors/font_color_bg = Color(1, 1, 1, 0.3)
TabContainer/colors/font_color_fg = Color(0.79902, 0.807843, 0.827451, 1)
TabContainer/constants/side_margin = 0
TabContainer/icons/decrement = SubResource("533")
TabContainer/icons/decrement_highlight = SubResource("533")
TabContainer/icons/increment = SubResource("535")
TabContainer/icons/increment_highlight = SubResource("535")
TabContainer/icons/menu = SubResource("553")
TabContainer/icons/menu_hl = SubResource("553")
TabContainer/styles/panel = SubResource("1396")
TabContainer/styles/tab_bg = SubResource("1354")
TabContainer/styles/tab_disabled = SubResource("1397")
TabContainer/styles/tab_fg = SubResource("1355")
Tabs/colors/font_color_bg = Color(1, 1, 1, 0.3)
Tabs/colors/font_color_fg = Color(0.79902, 0.807843, 0.827451, 1)
Tabs/constants/hseparation = 4
Tabs/icons/close = SubResource("509")
Tabs/icons/decrement = SubResource("533")
Tabs/icons/decrement_highlight = SubResource("533")
Tabs/icons/increment = SubResource("535")
Tabs/icons/increment_highlight = SubResource("535")
Tabs/styles/button = SubResource("19")
Tabs/styles/button_pressed = SubResource("19")
Tabs/styles/tab_bg = SubResource("1354")
Tabs/styles/tab_disabled = SubResource("1397")
Tabs/styles/tab_fg = SubResource("1355")
TextEdit/colors/caret_color = Color(1, 1, 1, 0.2)
TextEdit/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
TextEdit/colors/selection_color = Color(0.490196, 0.490196, 0.490196, 1)
TextEdit/icons/tab = SubResource("551")
TextEdit/styles/focus = SubResource("3")
TextEdit/styles/normal = SubResource("4")
TextEdit/styles/read_only = SubResource("1")
ToolButton/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
ToolButton/colors/font_color_hover = Color(0.879412, 0.884706, 0.896471, 1)
ToolButton/colors/font_color_pressed = Color(0.411765, 0.611765, 0.909804, 1)
ToolButton/styles/disabled = SubResource("19")
ToolButton/styles/focus = SubResource("19")
ToolButton/styles/hover = SubResource("19")
ToolButton/styles/normal = SubResource("19")
ToolButton/styles/pressed = SubResource("19")
TooltipLabel/colors/font_color = Color(0.20098, 0.192157, 0.172549, 1)
TooltipLabel/colors/font_color_shadow = Color(0, 0, 0, 0.1)
TooltipPanel/styles/panel = SubResource("1398")
Tree/colors/custom_button_font_highlight = Color(0.879412, 0.884706, 0.896471, 1)
Tree/colors/drop_position_color = Color(0.411765, 0.611765, 0.909804, 1)
Tree/colors/font_color = Color(0.79902, 0.807843, 0.827451, 1)
Tree/colors/font_color_selected = Color(1, 1, 1, 1)
Tree/colors/guide_color = Color(1, 1, 1, 0.05)
Tree/colors/title_button_color = Color(0.79902, 0.807843, 0.827451, 1)
Tree/constants/button_margin = 4
Tree/constants/draw_relationship_lines = 0
Tree/constants/guide_width = 1
Tree/constants/hseparation = 4
Tree/constants/item_margin = 12
Tree/constants/scroll_border = 4
Tree/constants/scroll_speed = 12
Tree/constants/vseparation = 4
Tree/icons/arrow = SubResource("555")
Tree/icons/arrow_collapsed = SubResource("557")
Tree/icons/arrow_up = SubResource("559")
Tree/icons/checked = SubResource("7")
Tree/icons/select_arrow = SubResource("513")
Tree/icons/select_option = SubResource("561")
Tree/icons/unchecked = SubResource("13")
Tree/icons/updown = SubResource("563")
Tree/styles/bg = SubResource("1362")
Tree/styles/bg_focus = SubResource("1356")
Tree/styles/button_pressed = SubResource("1399")
Tree/styles/cursor = SubResource("1400")
Tree/styles/cursor_unfocused = SubResource("1400")
Tree/styles/custom_button = SubResource("1401")
Tree/styles/custom_button_hover = SubResource("4")
Tree/styles/custom_button_pressed = SubResource("1402")
Tree/styles/selected = SubResource("1385")
Tree/styles/selected_focus = SubResource("1386")
Tree/styles/title_button_hover = SubResource("1403")
Tree/styles/title_button_normal = SubResource("1403")
Tree/styles/title_button_pressed = SubResource("1403")
VBoxContainer/constants/separation = 4
VScrollBar/icons/decrement = SubResource("1371")
VScrollBar/icons/decrement_highlight = SubResource("1371")
VScrollBar/icons/increment = SubResource("1371")
VScrollBar/icons/increment_highlight = SubResource("1371")
VScrollBar/styles/grabber = SubResource("1404")
VScrollBar/styles/grabber_highlight = SubResource("1405")
VScrollBar/styles/grabber_pressed = SubResource("1406")
VScrollBar/styles/scroll = SubResource("1407")
VScrollBar/styles/scroll_focus = SubResource("1408")
VSeparator/styles/separator = SubResource("1409")
VSlider/icons/grabber = SubResource("545")
VSlider/icons/grabber_highlight = SubResource("547")
VSlider/styles/grabber_area = SubResource("1410")
VSlider/styles/slider = SubResource("1411")
VSplitContainer/constants/separation = 8
VSplitContainer/icons/grabber = SubResource("581")
VSplitContainer/styles/bg = SubResource("1412")
WindowDialog/colors/title_color = Color(0.79902, 0.807843, 0.827451, 1)
WindowDialog/constants/close_h_ofs = 22
WindowDialog/constants/close_v_ofs = 20
WindowDialog/constants/title_height = 24
WindowDialog/fonts/title_font = null
WindowDialog/icons/close = SubResource("509")
WindowDialog/icons/close_highlight = SubResource("509")
WindowDialog/styles/panel = SubResource("1413")
   list=Array[Dictionary]([])
     PNG

   
IHDR   @   @   iq   sBIT|d   	pHYs    +   tEXtSoftware www.inkscape.org<  
IDATx[{pT}fPcqv/F&<nRÌ;RM6a.6&XNGm;4ay(I(6EKmkD
G#	y=_ؽw̝ɞy{}`TU)WOp0짯OXYb jq۸k"!.WzuLx?7_nX7Vlo.Hu-4V>b]e`NZ~E^%5Md3akwn\ $:yL
6A 2e	
@^\
c?Z"PII 7*:BerFDڥDψo
KƴPOc:v֌޵{0)PMD%v?fl\
H/K`>3^,փ?'Ht@4mSvvvDI)'nl9 [hH"
@3weV"8' S k85ɏᚚ
W2pt2	!~fҦB0A80+555_3*`(  =`n^M0!F
/e-r&kߟnP ݩg.f̪>Ë`WBM<޷o_XLAkWqe^	"z|,SL._PĠB pƌ(beKKE!03i`jDzIFH 4 ' r my!bjp:p5"Q_Z)2	- nP;w~ -N `׺V&Z\ @ۓ=,k'm6	Pp89p8NX
OGz=Q  z{7T&No
Xy}
-$WCq q-Yo=H% Pt&-lgŐtn.̬F-  PīL5HF 7"TUU) 'HDZ   ! G+'/G43_VlM 921VzwhKaC;iiiwg $xmՖV
- .sļKG9?0%"bi
W1sz \^m9ƌ?FUAR1]FW"z F4M[ |.@G{ahQJkJ/imu5Qcvvnk>V#/>@X*9Jxf+
fnc-$y0f,fU ̌ݨ# x(|f ?(h9jU|הsd*xYm7k:  AcN1tNֹSl~N jr'߫Vsu	v(WiNt[01 Ii0%LZ4-b-8.+|R 9mf.@Cmie'(*SUU4}~t~if~,++4I RK۽j-
Ubp2 h!fffE"k: dx-CѲV _.̴l;2!c!Hw3<͍qe=G@N;N":Whh!ngf߱X,D	2B0
@Z;o73@

yvy""L~}?\mg"Nv%um
>|<RE>4-bWh2޽$jŐ+J7/$R
ֺVoH-[}(EJwoUaM6k"
/!E |,]+
L荏7$ 1	I  6ԐW
O_h»&曟ET*<)bHBRW `8yčob+t"$!8O+/R,ć@6"l1 M+8YQQV JoIf. p:Valm,1*P;^g&)s :iqڵ4 <ĆY<"KeNb0cW7b3Y"L˽\X
Ykثj*J`/z
2c3pԍU9Y
w}0"!4܁k@eeegÄG'OGU 
n<	(

o> p:0}Y6NgF-Ls,րPXF\F$%8\wt TVsr΄8rqq!W>dA`Ɏ;)) 4r=aU9	@`${EyjlPUЗA 
oIubL%''g\m7|`5@D



n#UUk֨u%VV(//vT$#ǵrgϾz-B0?r 1<;.!{`G} @=]w5I~)gnxҋ.ۘs??gd~2Krc| (ĿGϡti)'/>yDe	kh
|-AZEyf54$,^o+ %9xiO,^暙W2g4    IENDB`      lrQ=F   res://gdre_icon.png?Cs߂R   res://gdre_main.gdA<   res://gdre_main.tscnA
FS   res://gdre_theme.tres              ECFG      application/config/name         Godot RE Tools     application/run/main_scene         res://gdre_main.tscn   application/config/features   "         4.4    application/config/icon         res://gdre_icon.png *   display/window/subwindows/embed_subwindows             display/window/size/width           display/window/size/height         .   editor/export/convert_text_resources_to_binary          #   rendering/renderer/rendering_method         gl_compatibility4   rendering/textures/vram_compression/import_etc2_astc         )   rendering/environment/default_clear_color      ==+=  ?              